/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Cluster;
import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterListener;
import com.mongodb.ClusterSettings;
import com.mongodb.DefaultClusterableServerFactory;
import com.mongodb.Mongo;
import com.mongodb.MultiServerCluster;
import com.mongodb.NoOpClusterListener;
import com.mongodb.ServerSettings;
import com.mongodb.SingleServerCluster;

final class Clusters {
    private Clusters() {
    }

    public static Cluster create(String clusterId, ClusterSettings settings, ServerSettings serverSettings, ClusterListener clusterListener, Mongo mongo) {
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(clusterId, serverSettings, mongo);
        if (settings.getMode() == ClusterConnectionMode.Single) {
            return new SingleServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        if (settings.getMode() == ClusterConnectionMode.Multiple) {
            return new MultiServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)settings.getMode()));
    }
}

