/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.authentication;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.authentication.AuthenticationPlugin;
import com.mysql.cj.api.io.PacketBuffer;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.io.Buffer;
import java.util.List;
import java.util.Properties;

public class MysqlClearPasswordPlugin
implements AuthenticationPlugin {
    private Protocol protocol;
    private String password = null;

    @Override
    public void init(MysqlConnection conn, Properties props, Log log) {
        this.init(conn, ((JdbcConnection)conn).getSession().getProtocol(), props);
    }

    @Override
    public void init(MysqlConnection conn, Protocol prot, Properties props) {
        this.protocol = prot;
    }

    @Override
    public void destroy() {
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return "mysql_clear_password";
    }

    @Override
    public boolean requiresConfidentiality() {
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
    }

    @Override
    public boolean nextAuthenticationStep(PacketBuffer fromServer, List<PacketBuffer> toServer) {
        toServer.clear();
        String encoding = this.protocol.versionMeetsMinimum(5, 7, 6) ? this.protocol.getPasswordCharacterEncoding() : "UTF-8";
        Buffer bresp = new Buffer(StringUtils.getBytes(this.password != null ? this.password : "", encoding));
        bresp.setPosition(bresp.getBufLength());
        int oldBufLength = bresp.getBufLength();
        bresp.writeByte((byte)0);
        bresp.setBufLength(oldBufLength + 1);
        bresp.setPosition(0);
        toServer.add(bresp);
        return true;
    }
}

