/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public final class PrepareStatementCache
extends LinkedHashMap<String, PrepareResult> {
    private final int maxSize;
    private final Protocol protocol;

    private PrepareStatementCache(int size, Protocol protocol) {
        super(size, 0.75f, true);
        this.maxSize = size;
        this.protocol = protocol;
    }

    public static PrepareStatementCache newInstance(int size, Protocol protocol) {
        return new PrepareStatementCache(size, protocol);
    }

    @Override
    public boolean removeEldestEntry(Map.Entry eldest) {
        boolean mustBeRemoved;
        boolean bl = mustBeRemoved = this.size() > this.maxSize;
        if (mustBeRemoved) {
            PrepareResult prepareResult = (PrepareResult)eldest.getValue();
            prepareResult.setRemoveFromCache();
            if (prepareResult.canBeDeallocate()) {
                try {
                    this.protocol.forceReleasePrepareStatement(prepareResult.getStatementId());
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
        }
        return mustBeRemoved;
    }

    public synchronized PrepareResult put(String key, PrepareResult result, boolean force) {
        PrepareResult cachedPrepareResult;
        if (!force && (cachedPrepareResult = (PrepareResult)super.get(key)) != null && cachedPrepareResult.incrementShareCounter()) {
            return cachedPrepareResult;
        }
        result.setAddToCache();
        super.put(key, result);
        return null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PrepareStatementCache.map[");
        for (Map.Entry entry : this.entrySet()) {
            stringBuilder.append("\n").append((String)entry.getKey()).append("-").append(((PrepareResult)entry.getValue()).getShareCounter());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

