// -*- c++ -*-
// Generated by gmmproc 2.45.3 -- DO NOT MODIFY!
#ifndef _GTKMM_ENTRYCOMPLETION_H
#define _GTKMM_ENTRYCOMPLETION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: entrycompletion.hg,v 1.24 2006/07/19 16:58:50 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ytkmm/widget.h>
#include <ytkmm/treemodel.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEntryCompletion GtkEntryCompletion;
typedef struct _GtkEntryCompletionClass GtkEntryCompletionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class EntryCompletion_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

class Entry;

//TODO: This should derive+implement from CellLayout, when we can break ABI.
//Then we should add "It derives from the Gtk::CellLayout, to allow the user to add extra cells to the Gtk::TreeView with completion matches".

/** Completion functionality for Gtk::Entry.
 *
 * Gtk::EntryCompletion is an auxiliary object to be used in conjunction with 
 * Gtk::Entry to provide the completion functionality. 
 * 
 * "Completion functionality" means that when the user modifies the text in the 
 * entry, Gtk::EntryCompletion checks which rows in the model match the current 
 * content of the entry, and displays a list of matches. By default, the
 * matching is done by comparing the entry text case-insensitively against 
 * the text column of the model (see set_text_column()), 
 * but this can be overridden with a custom match function (see set_match_func()).
 *
 * When the user selects a completion, the content of the entry is updated. 
 * By default, the content of the entry is replaced by the text column of the 
 * model, but this can be overridden by connecting to the match_selected signal 
 * and updating the entry in the signal handler. Note that you should return true 
 * from the signal handler to suppress the default behaviour.
 * 
 * To add completion functionality to an entry, use Gtk::Entry::set_completion().
 * 
 * In addition to regular completion matches, which will be inserted into 
 * the entry when they are selected, Gtk::EntryCompletion also allows the display of  
 * "actions" in the popup window. Their appearance is similar to menu items, 
 * to differentiate them clearly from completion strings. When an action is 
 * selected, the action_activated signal is emitted. 
 */

class EntryCompletion : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef EntryCompletion CppObjectType;
  typedef EntryCompletion_Class CppClassType;
  typedef GtkEntryCompletion BaseObjectType;
  typedef GtkEntryCompletionClass BaseClassType;

private:  friend class EntryCompletion_Class;
  static CppClassType entrycompletion_class_;

private:
  // noncopyable
  EntryCompletion(const EntryCompletion&);
  EntryCompletion& operator=(const EntryCompletion&);

protected:
  explicit EntryCompletion(const Glib::ConstructParams& construct_params);
  explicit EntryCompletion(GtkEntryCompletion* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~EntryCompletion();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkEntryCompletion*       gobj()       { return reinterpret_cast<GtkEntryCompletion*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkEntryCompletion* gobj() const { return reinterpret_cast<GtkEntryCompletion*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkEntryCompletion* gobj_copy();

private:


protected:
  EntryCompletion();

public:
  
  static Glib::RefPtr<EntryCompletion> create();


  //Careful, this actually returns a GtkWidget*, so it might not always be a GtkEntry in future GTK+ versions.
  
  /** Gets the entry @a completion has been attached to.
   * 
   * @return The entry @a completion has been attached to.
   */
  Entry* get_entry();
  
  /** Gets the entry @a completion has been attached to.
   * 
   * @return The entry @a completion has been attached to.
   */
  const Entry* get_entry() const;

  
  /** Sets the model for a Gtk::EntryCompletion. If @a completion already has
   * a model set, it will remove it before setting the new model.
   * Use unset_model() to unset the old model.
   * 
   * @param model The Gtk::TreeModel.
   */
  void set_model(const Glib::RefPtr<TreeModel>& model);
  
  /** Returns the model the Gtk::EntryCompletion is using as data source.
   * Returns <tt>0</tt> if the model is unset.
   * 
   * @return A Gtk::TreeModel, or <tt>0</tt> if none
   * is currently being used.
   */
  Glib::RefPtr<TreeModel> get_model();
  
  /** Returns the model the Gtk::EntryCompletion is using as data source.
   * Returns <tt>0</tt> if the model is unset.
   * 
   * @return A Gtk::TreeModel, or <tt>0</tt> if none
   * is currently being used.
   */
  Glib::RefPtr<const TreeModel> get_model() const;

  /** Remove the model from the EntryCompletion.
   *
   * @see set_model().
   */
  void unset_model();

  /// For example, bool on_match(const Glib::ustring& key, const TreeModel::const_iterator& iter);
  typedef sigc::slot<bool, const Glib::ustring&, const TreeModel::const_iterator&> SlotMatch;
  
  void set_match_func(const SlotMatch& slot);
  
  
  /** Requires the length of the search key for @a completion to be at least
   *  @a length. This is useful for long lists, where completing using a small
   * key takes a lot of time and will come up with meaningless results anyway
   * (ie, a too large dataset).
   * 
   * @param length The minimum length of the key in order to start completing.
   */
  void set_minimum_key_length(int length);
  
  /** Returns the minimum key length as set for @a completion.
   * 
   * @return The currently used minimum key length.
   */
  int get_minimum_key_length() const;
  
  /** Requests a completion operation, or in other words a refiltering of the
   * current list with completions, using the current key. The completion list
   * view will be updated accordingly.
   */
  void complete();

  
  /** Requests a prefix insertion. 
   */
  void insert_prefix();

  //We reordered the parameters, compared to the C version, so that we can have method overloads without the index.

  // TODO: We would really like an insert() which before-inserts an iterator, like ListStore::insert(),
  // but there is no EntryCompletion::insert_before() for us to use.
  void insert_action_text(const Glib::ustring& text, int index);
  void prepend_action_text(const Glib::ustring& text);
  //TODO: Add append_action_text() somehow? It would be slow if we count the children each time. murrayc.
  
  void insert_action_markup(const Glib::ustring& markup, int index);
  void prepend_action_markup(const Glib::ustring& markup);
  

  //TODO: Change default - it would be nicer to delete the last action instead of the first.
  
  /** Deletes the action at @a index from @a completion's action list.
   * 
   * @param index The index of the item to Delete.
   */
  void delete_action(int index =  0);

  
  /** Sets whether the common prefix of the possible completions should
   * be automatically inserted in the entry.
   * 
   * @param inline_completion <tt>true</tt> to do inline completion.
   */
  void set_inline_completion(bool inline_completion =  true);
  
  /** Returns whether the common prefix of the possible completions should
   * be automatically inserted in the entry.
   * 
   * @return <tt>true</tt> if inline completion is turned on.
   */
  bool get_inline_completion() const;
  
  /** Sets whether it is possible to cycle through the possible completions
   * inside the entry.
   * 
   * @param inline_selection <tt>true</tt> to do inline selection.
   */
  void set_inline_selection(bool inline_selection =  true);
  
  /** Returns <tt>true</tt> if inline-selection mode is turned on.
   * 
   * @return <tt>true</tt> if inline-selection mode is on.
   */
  bool get_inline_selection() const;
  
  /** Sets whether the completions should be presented in a popup window.
   * 
   * @param popup_completion <tt>true</tt> to do popup completion.
   */
  void set_popup_completion(bool popup_completion =  true);
  
  /** Returns whether the completions should be presented in a popup window.
   * 
   * @return <tt>true</tt> if popup completion is turned on.
   */
  bool get_popup_completion() const;

  
  /** Sets whether the completion popup window will be resized to be the same
   * width as the entry.
   * 
   * @param popup_set_width <tt>true</tt> to make the width of the popup the same as the entry.
   */
  void set_popup_set_width(bool popup_set_width =  true);
  
  /** Returns whether the  completion popup window will be resized to the 
   * width of the entry.
   * 
   * @return <tt>true</tt> if the popup window will be resized to the width of 
   * the entry.
   */
  bool get_popup_set_width() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets whether the completion popup window will appear even if there is
   * only a single match. You may want to set this to <tt>false</tt> if you
   * are using inline
   * completion.
   * 
   * @deprecated Use set_popup_single_match() instead. This function was wrongly named.
   * 
   * @param popup_single_match <tt>true</tt> if the popup should appear even for a single
   * match.
   */
  void set_popup_single_width(bool popup_single_match =  true);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets whether the completion popup window will appear even if there is
   * only a single match. You may want to set this to <tt>false</tt> if you
   * are using inline
   * completion.
   * 
   * @param popup_single_match <tt>true</tt> if the popup should appear even for a single
   * match.
   */
  void set_popup_single_match(bool popup_single_match =  true);

  
  /** Returns whether the completion popup window will appear even if there is
   * only a single match. 
   * 
   * @return <tt>true</tt> if the popup window will appear regardless of the
   * number of matches.
   */
  bool get_popup_single_match() const;
  
  /** Get the original text entered by the user that triggered
   * the completion or an empty string if there's no completion ongoing.
   * 
   * @return The prefix for the current completion
   */
  Glib::ustring get_completion_prefix() const;

  
  /** Convenience function for setting up the most used case of this code: a
   * completion list with just strings. This function will set up @a completion
   * to have a list displaying all (and just) strings in the completion list,
   * and to get those strings from @a column in the model of @a completion.
   * 
   * This functions creates and adds a Gtk::CellRendererText for the selected 
   * column. If you need to set the text column, but don't want the cell 
   * renderer, use Glib::object_set() to set the text_column property directly.
   * 
   * @param column The column in the model of @a completion to get strings from.
   */
  void set_text_column(const TreeModelColumnBase& column);
  
  /** Convenience function for setting up the most used case of this code: a
   * completion list with just strings. This function will set up @a completion
   * to have a list displaying all (and just) strings in the completion list,
   * and to get those strings from @a column in the model of @a completion.
   * 
   * This functions creates and adds a Gtk::CellRendererText for the selected 
   * column. If you need to set the text column, but don't want the cell 
   * renderer, use Glib::object_set() to set the text_column property directly.
   * 
   * @param column The column in the model of @a completion to get strings from.
   */
  void set_text_column(int column);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns the column in the model of @a completion to get strings from.
   * 
   * @deprecated Use the const version of this method.
   * 
   * @return The column containing the strings.
   */
  int get_text_column();
#endif // GTKMM_DISABLE_DEPRECATED


  /** Returns the column in the model of @a completion to get strings from.
   * 
   * @return The column containing the strings.
   */
  int get_text_column() const;

  
  /** Emitted when an action is activated.
   *
   * @param index The index of the activated action.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%action_activated(int index)</tt>
   *
   */

  Glib::SignalProxy1< void,int > signal_action_activated();


  //We completely hand-code these signals because we want to change how the parameters are wrapped,
  //because we need both the iter and the model to make the C++ iter.
  
  
  /** Emitted when a match from the list is selected. 
   * The default behaviour is to replace the contents of the 
   * entry with the contents of the text column in the row 
   * pointed to by @a iter.
   *
   * It is necessary to connect your signal handler <i>before</i>
   * the default one, which would otherwise return <tt>true</tt>,
   * a value which signifies that the signal has been handled,
   * thus preventing any other handler from being invoked.
   *
   * To do this, pass <tt>false</tt> to this signal proxy's
   * <tt>connect()</tt> method. For example:
   * <tt> completion->signal_match_selected().connect(sigc::mem_fun(*this, &YourClass::on_completion_match_selected), false); </tt>
   *
   * @param model The TreeModel containing the matches
   * @param iter A TreeModel::iterator positioned at the selected match
   * @result true if the signal has been handled
   * 
   * @par Prototype:
   * <tt>bool %on_match_selected(const TreeModel::iterator& iter)</tt>
   */
  Glib::SignalProxy1< bool, const TreeModel::iterator& > signal_match_selected();

  /** Emitted when a match from the cursor is on a match
   * of the list. The default behaviour is to replace the contents
   * of the entry with the contents of the text column in the row 
   * pointed to by @a iter.
   *
   * @param model The TreeModel containing the matches
   * @param iter A TreeModel::iterator positioned at the selected match
   * @result true if the signal has been handled
   * 
   * @par Prototype:
   * <tt>bool %on_cursor_on_match(const TreeModel::iterator& iter)</tt>
   */
  Glib::SignalProxy1< bool, const TreeModel::iterator& > signal_cursor_on_match();


  //We use no_default_handler for these signals, because we can not add a new vfunc without breaking ABI.
  //TODO: Remove no_default_handler when we do an ABI-break-with-parallel-install.

  
  /** Emitted when the inline autocompletion is triggered. 
   * The default behaviour is to make the entry display the 
   * whole prefix and select the newly inserted part.
   *
   * Applications may connect to this signal in order to insert only a
   * smaller part of the @a prefix into the entry - e.g. the entry used in
   * the FileChooser inserts only the part of the prefix up to the 
   * next '/'.
   * 
   * @param prefix The common prefix of all possible completions.
   * @result true if the signal has been handled
   *
   * @par Slot Prototype:
   * <tt>bool on_my_%insert_prefix(const Glib::ustring& prefix)</tt>
   *
   */

  Glib::SignalProxy1< bool,const Glib::ustring& > signal_insert_prefix();


  /** The model to find matches in.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::TreeModel> > property_model() ;

/** The model to find matches in.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::TreeModel> > property_model() const;

  /** Minimum length of the search key in order to look up matches.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_minimum_key_length() ;

/** Minimum length of the search key in order to look up matches.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_minimum_key_length() const;

  /** The column of the model containing the strings.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_text_column() ;

/** The column of the model containing the strings.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_text_column() const;

  /** Whether the common prefix should be inserted automatically.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_inline_completion() ;

/** Whether the common prefix should be inserted automatically.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_inline_completion() const;

  /** Whether the completions should be shown in a popup window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_popup_completion() ;

/** Whether the completions should be shown in a popup window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_popup_completion() const;

  /** If TRUE, the popup window will have the same size as the entry.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_popup_set_width() ;

/** If TRUE, the popup window will have the same size as the entry.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_popup_set_width() const;

  /** If TRUE, the popup window will appear for a single match.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_popup_single_match() ;

/** If TRUE, the popup window will appear for a single match.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_popup_single_match() const;

  /** Your description here.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_inline_selection() ;

/** Your description here.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_inline_selection() const;


protected:

  //Default Signal Handler:
  virtual bool on_match_selected(const TreeModel::iterator& iter);  
  //No default handler for on_cursor_on_match(), to preserver ABI. TODO: Add this when we can break ABI.      


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_action_activated().
  virtual void on_action_activated(int index);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::EntryCompletion
   */
  Glib::RefPtr<Gtk::EntryCompletion> wrap(GtkEntryCompletion* object, bool take_copy = false);
}


#endif /* _GTKMM_ENTRYCOMPLETION_H */

