deb-build-artifact-gather
=========================

The `deb-build-artifact-gather` is a tool for gathering build time artifacts
from Debian builds.

Most Debian builds are performed inside a chroot or container to segregate the
build and its dependencies from the host system. This is desirable to ensure
that the build cannot taint the host and vice versa. In many cases it also acts
as a security boundary between the two. However, there are a multitude of
different methods for creating this context boundary, and they all have different
behaviors, which has made it non-trivial for gather arbitrary build artifacts
from the builder side.

This is where `deb-build-artifact-gather` comes in. It provides a standardized way
to request artifacts to be extracted. The build orchestration tooling is responsible
for invoking `deb-build-artifact-gather` at the right time with parameters. The
`deb-build-artifact-gather` will then collect relevant artifacts and provide them
to the build orchestration tooling, so they can be published.

Prerequisites
-------------

On a (modern) Debian system, you can install prerequisites via the following apt command.

     apt build-deps -y .

This includes the minimal development stack used to build the `deb-build-artifact-gather`
package.  Have a look at `debian/control` if you want the minimal dependencies for
running `deb-build-artifact-gather` directly.


Running deb-build-artifact-gather from source
---------------------------------------------

While developing, it is useful to run `deb-build-artifact-gather` directly from the source tree
without having to build first.  This can be done by invoking the `deb-build-artifact-gather.sh`
command in the source root on any system that has `#!/bin/sh`.

Which only relies on the `PYTHONPATH` environment variable being set correctly and having `python3`
in `PATH`.

How to use / example run:
-------------------------

Assuming no chroot boundry:

```shell
    # "$(mktemp -d)" is a perfectly fine alternative to DEB_ARTIFACTS_EXTRACTION_IPC_DIR 
    DEB_ARTIFACTS_EXTRACTION_IPC_DIR="../artifact-variable-dir"
    export DEB_ARTIFACTS_EXTRACTION_IPC_DIR

    cd /path/to/unpacked-source-root
    dpkg-buildpackage

    if deb-build-artifact-gather collect-into ../artifacts-from-build.tar.xz; then
        # Copy ../artifacts-from-build.tar.xz out of the chroot somehow
        rm -f ../artifacts-from-build.tar.xz
    fi

    [ -e "${DEB_ARTIFACTS_EXTRACTION_IPC_DIR}"] && rm -fr "${DEB_ARTIFACTS_EXTRACTION_IPC_DIR}"
```

# Interface docs

If you are looking for how to interface with **deb-build-artifact-gather**, then please review:

 * [INTERFACE-CHROOT-PROVIDER.md](docs/INTERFACE-CHROOT-PROVIDER.md) if you are maintaining a build
   wrapping tool like **sbuild**, **pbuilder**, or **debuild**
 * [INTERFACE-PACKAGE-HELPER.md](docs/INTERFACE-PACKAGE-HELPER.md) if you are maintaining a package
   helper like **debhelper** or **debputy**.

# Communication channels:

The following communication channels are available:

 * Using the <https://salsa.debian.org/debian/deb-build-artifact-gather> features, such as issues.
   Generally, these will be available to the public. While confidential issues can be filed, please
   note that all Debian Developers can read them.
 * Filing bugs via `reportbug deb-build-artifact-gather` to Debian's Bug Tracking System. Note all
   such bugs will have public archives.
 * Mail to Debian Build Artifact Gather Maintainers <deb-build-artifact-gather@packages.debian.org>.
   Please note that no public archive is available but anyone can subscribe via tracker.debian.org.

## Security policy and issues

Please see [SECURITY.md](SECURITY.md) for details on that matter.
