# Interface description for chroot providers and build wrappers

This document describes the interface between build tools that provide
the build environment such as **sbuild**, **pbuilder**, or **debuild**.
From here on out, these tools will collectively be referred to as
the `build-wrapper`.

The document written with the assumption that the reader is a maintainer
of a tool like this and want to integrate `deb-build-artifact-gather`.

## Security consideration

Any `build-wrapper` that integrates with `deb-build-artifact-gather`
should review [SECUIRTY.md](../SECURITY.md) and probably also mention
it in its documentation for how to activate the `deb-build-artifact-gather`
feature to ensure users are aware of their responsibility.

Even if the `build-wrapper` provides "perfect" isolation,
`deb-build-artifact-gather` opens a way for the build process to
extract arbitrary data from the isolation layer.

Even if the security aspect is not a concern for the users of
`build-wrapper`, the use of `deb-build-artifact-gather` should
likely be optional as it comes with extra resource usage.

## What is the `build-wrapper` required to do?

The `build-wrapper` is required to do the following before doing the build:

 * Set `DEB_ARTIFACTS_EXTRACTION_IPC_DIR` to a path that is writable
   to the build process. If the path is relative, it will be relative
   to the unpacked source root (where the build will be performed).
   When absolute, it is the absolute path as seen by the build process.

After the `build-wrapper` has performed the build, it should perform the
following:


 1. Run `deb-build-artifact-gather` with the **same** environment as
    the build process itself after the build occurred but before any
    clean up starts.
    
    Note `deb-build-artifact-gather` can be called from the host
    system when the chroot is accessible via the host's file system.
    But `deb-build-artifact-gather` still needs the same environment
    variables as the build process saw.

 2. If `deb-build-artifact-gather` finds any artifacts to collect,
    make them available to the caller (how is implementation defined,
    but it will probably involve copying or moving it to some predefined
    directory).

 3. If `DEB_ARTIFACTS_EXTRACTION_IPC_DIR` exists, delete it.

As mentioned, `deb-build-artifact-gather` can either be called from
the host system with information about where to find the chroot OR
be installed and run inside the chroot.

## Additional features

The `build-wrapper` can choose to provide additional features on
top of this. This can include adding extra patterns to be extracted.

It can do so via the `DEB_ARTIFACTS_EXTRACTION_IPC_DIR`. Please
review the [INTERFACE-PACKAGE-HELPER.md](INTERFACE-PACKAGE-HELPER.md)
documentation for more information on that.

## What will `deb-build-artifact-gather` do for your tool?

The `deb-build-artifact-gather` will:

 1) handle collecting all relevant paths (logs, etc.) into a path
    decided by the `build-wrapper`.

 2) maintain common collection patterns

 3) interface with the package helpers such as **debhelper** and
    **debputy** to enhance the patterns.

In other words, segregation of duties. The `build-wrapper` can focus
on setup and cleanup without being involved in how artifacts
are extracted. Meanwhile `deb-build-artifact-gather` focus on
what is collected and how to minimize the effort from packagers.
