To run the full test suite
after compiling and installing djbsort,
run `djbsort-fulltest`.
This indicates success in two ways:
it prints `full tests succeeded` as its last line of output;
it exits 0.

Any change in the compiled library
(compiling for a different architecture, compiling with a different compiler, etc.) must be subjected to a new round of tests.
A compiled version of djbsort that does not pass the full test suite is **not supported**.

One run of `djbsort-fulltest` for `djbsort-20260210`
was observed to take 46 core-minutes on cezanne (AMD Ryzen 5 PRO 5650G; 6 cores, 2 threads/core)
with overclocking disabled (so running at 3.9GHz).
This test finished in under 5 minutes of real time;
`djbsort-fulltest` includes some automatic parallelization.
To limit the number of threads used to 1,
run `env THREADS=1 djbsort-fulltest`.

djbsort automatically selects
AVX2 implementations when it is running on an Intel/AMD CPU that supports AVX2,
while falling back to portable implementations otherwise.
Running `djbsort-fulltest` on an Intel/AMD CPU without AVX2
will say `CPU does not support implementation` for the AVX2 implementations
and will fail.
To test a compilation of djbsort for Intel/AMD CPUs,
you have to run `djbsort-fulltest` on an Intel/AMD CPU with AVX2.

The rest of this page says more about what is happening inside `djbsort-fulltest`.

## Conventional tests {#conventional}

The workhorse inside `djbsort-fulltest`
is a separate `djbsort-test` program.

Simply calling `djbsort-test` without arguments
will run various tests on the subroutines in djbsort,
and will indicate success in two ways:
printing `all tests succeeded` as the last line of output,
and exiting 0.

For parallelism,
`djbsort-fulltest` calls `djbsort-test` many times,
using optional `djbsort-test` arguments to narrow what is being tested in each call.

## Data-flow tests {#dataflow}

Another way that `djbsort-fulltest`
runs `djbsort-test` is as follows,
running [TIMECOP](https://bench.cr.yp.to/tips.html#timecop)-style tests that branch conditions and array indices
are independent of secrets:

    env valgrind_multiplier=1 \
    valgrind -q \
    --error-exitcode=99 \
    djbsort-test

This requires `valgrind` to be installed at test time.
The output will include a line `valgrind 1 declassify 1`
if the library was compiled with `--valgrind` (which is the only supported option),
or a line `valgrind 1 declassify 0 (expect false positives)` otherwise.

These data-flow tests
do not supersede the conventional tests.
The conventional tests run code directly on the CPU
and might catch issues hidden by the emulation in `valgrind`.
The conventional tests also include some memory tests that are disabled to improve the `valgrind` memory tests
but that are not necessarily superseded by the `valgrind` memory tests.
