/*
 * fspy - Linux filesystem activity monitor
 *
 * Copyright (C) 2007  Richard Sammet (e-axe) <richard.sammet@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef _STATING_H
#define _STATING_H

#include <sys/stat.h>
#include <sys/inotify.h>

char *gettype(const char *fpath, char *ptr, struct stat *statdat);
int checktype(const char *event_fpath, struct inotify_event *event,
              char *tstring, struct stat *statdat);
int isdir(const char *path, struct stat *statdat);
int statit(const char *path, struct stat *buf);

#endif
