// Code generated by smithy-go-codegen DO NOT EDIT.

package securityir

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityir/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing case.
func (c *Client) UpdateCase(ctx context.Context, params *UpdateCaseInput, optFns ...func(*Options)) (*UpdateCaseOutput, error) {
	if params == nil {
		params = &UpdateCaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateCase", params, optFns, c.addOperationUpdateCaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateCaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateCaseInput struct {

	// Required element for UpdateCase to identify the case ID for updates.
	//
	// This member is required.
	CaseId *string

	// Optional element for UpdateCase to provide content for the incident start date
	// field.
	ActualIncidentStartDate *time.Time

	// Optional element for UpdateCase to provide content for the description field.
	Description *string

	// Optional element for UpdateCase to provide content for the engagement type
	// field. Available engagement types include Security Incident | Investigation .
	EngagementType types.EngagementType

	// Optional element for UpdateCase to provide content to add accounts impacted.
	//
	// AWS account ID's may appear less than 12 characters and need to be
	// zero-prepended. An example would be 123123123 which is nine digits, and with
	// zero-prepend would be 000123123123 . Not zero-prepending to 12 digits could
	// result in errors.
	ImpactedAccountsToAdd []string

	// Optional element for UpdateCase to provide content to add accounts impacted.
	//
	// AWS account ID's may appear less than 12 characters and need to be
	// zero-prepended. An example would be 123123123 which is nine digits, and with
	// zero-prepend would be 000123123123 . Not zero-prepending to 12 digits could
	// result in errors.
	ImpactedAccountsToDelete []string

	// Optional element for UpdateCase to provide content to add regions impacted.
	ImpactedAwsRegionsToAdd []types.ImpactedAwsRegion

	// Optional element for UpdateCase to provide content to remove regions impacted.
	ImpactedAwsRegionsToDelete []types.ImpactedAwsRegion

	// Optional element for UpdateCase to provide content to add services impacted.
	ImpactedServicesToAdd []string

	// Optional element for UpdateCase to provide content to remove services impacted.
	ImpactedServicesToDelete []string

	// Optional element for UpdateCase to provide content for the customer reported
	// incident start date field.
	ReportedIncidentStartDate *time.Time

	// Optional element for UpdateCase to provide content to add additional suspicious
	// IP addresses related to a case.
	ThreatActorIpAddressesToAdd []types.ThreatActorIp

	// Optional element for UpdateCase to provide content to remove suspicious IP
	// addresses from a case.
	ThreatActorIpAddressesToDelete []types.ThreatActorIp

	// Optional element for UpdateCase to provide content for the title field.
	Title *string

	// Optional element for UpdateCase to provide content to add additional watchers
	// to a case.
	WatchersToAdd []types.Watcher

	// Optional element for UpdateCase to provide content to remove existing watchers
	// from a case.
	WatchersToDelete []types.Watcher

	noSmithyDocumentSerde
}

type UpdateCaseOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateCaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateCase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateCase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateCase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateCaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateCase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateCase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateCase",
	}
}
