//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseAccountsServer is a fake server for instances of the armcosmos.DatabaseAccountsClient type.
type DatabaseAccountsServer struct {
	// CheckNameExists is the fake for method DatabaseAccountsClient.CheckNameExists
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	CheckNameExists func(ctx context.Context, accountName string, options *armcosmos.DatabaseAccountsClientCheckNameExistsOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientCheckNameExistsResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method DatabaseAccountsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, createUpdateParameters armcosmos.DatabaseAccountCreateUpdateParameters, options *armcosmos.DatabaseAccountsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DatabaseAccountsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientBeginDeleteOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailoverPriorityChange is the fake for method DatabaseAccountsClient.BeginFailoverPriorityChange
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginFailoverPriorityChange func(ctx context.Context, resourceGroupName string, accountName string, failoverParameters armcosmos.FailoverPolicies, options *armcosmos.DatabaseAccountsClientBeginFailoverPriorityChangeOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientFailoverPriorityChangeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DatabaseAccountsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientGetOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientGetResponse], errResp azfake.ErrorResponder)

	// GetReadOnlyKeys is the fake for method DatabaseAccountsClient.GetReadOnlyKeys
	// HTTP status codes to indicate success: http.StatusOK
	GetReadOnlyKeys func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientGetReadOnlyKeysOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientGetReadOnlyKeysResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DatabaseAccountsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcosmos.DatabaseAccountsClientListOptions) (resp azfake.PagerResponder[armcosmos.DatabaseAccountsClientListResponse])

	// NewListByResourceGroupPager is the fake for method DatabaseAccountsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armcosmos.DatabaseAccountsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armcosmos.DatabaseAccountsClientListByResourceGroupResponse])

	// ListConnectionStrings is the fake for method DatabaseAccountsClient.ListConnectionStrings
	// HTTP status codes to indicate success: http.StatusOK
	ListConnectionStrings func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientListConnectionStringsOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientListConnectionStringsResponse], errResp azfake.ErrorResponder)

	// ListKeys is the fake for method DatabaseAccountsClient.ListKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListKeys func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientListKeysOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientListKeysResponse], errResp azfake.ErrorResponder)

	// NewListMetricDefinitionsPager is the fake for method DatabaseAccountsClient.NewListMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionsPager func(resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientListMetricDefinitionsOptions) (resp azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricDefinitionsResponse])

	// NewListMetricsPager is the fake for method DatabaseAccountsClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(resourceGroupName string, accountName string, filter string, options *armcosmos.DatabaseAccountsClientListMetricsOptions) (resp azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricsResponse])

	// ListReadOnlyKeys is the fake for method DatabaseAccountsClient.ListReadOnlyKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListReadOnlyKeys func(ctx context.Context, resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientListReadOnlyKeysOptions) (resp azfake.Responder[armcosmos.DatabaseAccountsClientListReadOnlyKeysResponse], errResp azfake.ErrorResponder)

	// NewListUsagesPager is the fake for method DatabaseAccountsClient.NewListUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesPager func(resourceGroupName string, accountName string, options *armcosmos.DatabaseAccountsClientListUsagesOptions) (resp azfake.PagerResponder[armcosmos.DatabaseAccountsClientListUsagesResponse])

	// BeginOfflineRegion is the fake for method DatabaseAccountsClient.BeginOfflineRegion
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginOfflineRegion func(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOffline armcosmos.RegionForOnlineOffline, options *armcosmos.DatabaseAccountsClientBeginOfflineRegionOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientOfflineRegionResponse], errResp azfake.ErrorResponder)

	// BeginOnlineRegion is the fake for method DatabaseAccountsClient.BeginOnlineRegion
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginOnlineRegion func(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOnline armcosmos.RegionForOnlineOffline, options *armcosmos.DatabaseAccountsClientBeginOnlineRegionOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientOnlineRegionResponse], errResp azfake.ErrorResponder)

	// BeginRegenerateKey is the fake for method DatabaseAccountsClient.BeginRegenerateKey
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRegenerateKey func(ctx context.Context, resourceGroupName string, accountName string, keyToRegenerate armcosmos.DatabaseAccountRegenerateKeyParameters, options *armcosmos.DatabaseAccountsClientBeginRegenerateKeyOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientRegenerateKeyResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method DatabaseAccountsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, updateParameters armcosmos.DatabaseAccountUpdateParameters, options *armcosmos.DatabaseAccountsClientBeginUpdateOptions) (resp azfake.PollerResponder[armcosmos.DatabaseAccountsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDatabaseAccountsServerTransport creates a new instance of DatabaseAccountsServerTransport with the provided implementation.
// The returned DatabaseAccountsServerTransport instance is connected to an instance of armcosmos.DatabaseAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseAccountsServerTransport(srv *DatabaseAccountsServer) *DatabaseAccountsServerTransport {
	return &DatabaseAccountsServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientCreateOrUpdateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientDeleteResponse]](),
		beginFailoverPriorityChange:   newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientFailoverPriorityChangeResponse]](),
		newListPager:                  newTracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListResponse]](),
		newListByResourceGroupPager:   newTracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListByResourceGroupResponse]](),
		newListMetricDefinitionsPager: newTracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricDefinitionsResponse]](),
		newListMetricsPager:           newTracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricsResponse]](),
		newListUsagesPager:            newTracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListUsagesResponse]](),
		beginOfflineRegion:            newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientOfflineRegionResponse]](),
		beginOnlineRegion:             newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientOnlineRegionResponse]](),
		beginRegenerateKey:            newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientRegenerateKeyResponse]](),
		beginUpdate:                   newTracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientUpdateResponse]](),
	}
}

// DatabaseAccountsServerTransport connects instances of armcosmos.DatabaseAccountsClient to instances of DatabaseAccountsServer.
// Don't use this type directly, use NewDatabaseAccountsServerTransport instead.
type DatabaseAccountsServerTransport struct {
	srv                           *DatabaseAccountsServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientCreateOrUpdateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientDeleteResponse]]
	beginFailoverPriorityChange   *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientFailoverPriorityChangeResponse]]
	newListPager                  *tracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListResponse]]
	newListByResourceGroupPager   *tracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListByResourceGroupResponse]]
	newListMetricDefinitionsPager *tracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricDefinitionsResponse]]
	newListMetricsPager           *tracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListMetricsResponse]]
	newListUsagesPager            *tracker[azfake.PagerResponder[armcosmos.DatabaseAccountsClientListUsagesResponse]]
	beginOfflineRegion            *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientOfflineRegionResponse]]
	beginOnlineRegion             *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientOnlineRegionResponse]]
	beginRegenerateKey            *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientRegenerateKeyResponse]]
	beginUpdate                   *tracker[azfake.PollerResponder[armcosmos.DatabaseAccountsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for DatabaseAccountsServerTransport.
func (d *DatabaseAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseAccountsClient.CheckNameExists":
		resp, err = d.dispatchCheckNameExists(req)
	case "DatabaseAccountsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DatabaseAccountsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DatabaseAccountsClient.BeginFailoverPriorityChange":
		resp, err = d.dispatchBeginFailoverPriorityChange(req)
	case "DatabaseAccountsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabaseAccountsClient.GetReadOnlyKeys":
		resp, err = d.dispatchGetReadOnlyKeys(req)
	case "DatabaseAccountsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DatabaseAccountsClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DatabaseAccountsClient.ListConnectionStrings":
		resp, err = d.dispatchListConnectionStrings(req)
	case "DatabaseAccountsClient.ListKeys":
		resp, err = d.dispatchListKeys(req)
	case "DatabaseAccountsClient.NewListMetricDefinitionsPager":
		resp, err = d.dispatchNewListMetricDefinitionsPager(req)
	case "DatabaseAccountsClient.NewListMetricsPager":
		resp, err = d.dispatchNewListMetricsPager(req)
	case "DatabaseAccountsClient.ListReadOnlyKeys":
		resp, err = d.dispatchListReadOnlyKeys(req)
	case "DatabaseAccountsClient.NewListUsagesPager":
		resp, err = d.dispatchNewListUsagesPager(req)
	case "DatabaseAccountsClient.BeginOfflineRegion":
		resp, err = d.dispatchBeginOfflineRegion(req)
	case "DatabaseAccountsClient.BeginOnlineRegion":
		resp, err = d.dispatchBeginOnlineRegion(req)
	case "DatabaseAccountsClient.BeginRegenerateKey":
		resp, err = d.dispatchBeginRegenerateKey(req)
	case "DatabaseAccountsClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchCheckNameExists(req *http.Request) (*http.Response, error) {
	if d.srv.CheckNameExists == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameExists not implemented")}
	}
	const regexStr = `/providers/Microsoft\.DocumentDB/databaseAccountNames/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckNameExists(req.Context(), accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.DatabaseAccountCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginFailoverPriorityChange(req *http.Request) (*http.Response, error) {
	if d.srv.BeginFailoverPriorityChange == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailoverPriorityChange not implemented")}
	}
	beginFailoverPriorityChange := d.beginFailoverPriorityChange.get(req)
	if beginFailoverPriorityChange == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverPriorityChange`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.FailoverPolicies](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginFailoverPriorityChange(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailoverPriorityChange = &respr
		d.beginFailoverPriorityChange.add(req, beginFailoverPriorityChange)
	}

	resp, err := server.PollerResponderNext(beginFailoverPriorityChange, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginFailoverPriorityChange.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailoverPriorityChange) {
		d.beginFailoverPriorityChange.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseAccountGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchGetReadOnlyKeys(req *http.Request) (*http.Response, error) {
	if d.srv.GetReadOnlyKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetReadOnlyKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/readonlykeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetReadOnlyKeys(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseAccountListReadOnlyKeysResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListPager(nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchListConnectionStrings(req *http.Request) (*http.Response, error) {
	if d.srv.ListConnectionStrings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListConnectionStrings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listConnectionStrings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ListConnectionStrings(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseAccountListConnectionStringsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchListKeys(req *http.Request) (*http.Response, error) {
	if d.srv.ListKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ListKeys(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseAccountListKeysResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchNewListMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionsPager not implemented")}
	}
	newListMetricDefinitionsPager := d.newListMetricDefinitionsPager.get(req)
	if newListMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricDefinitionsPager(resourceGroupNameParam, accountNameParam, nil)
		newListMetricDefinitionsPager = &resp
		d.newListMetricDefinitionsPager.add(req, newListMetricDefinitionsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionsPager) {
		d.newListMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := d.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricsPager(resourceGroupNameParam, accountNameParam, filterParam, nil)
		newListMetricsPager = &resp
		d.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		d.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchListReadOnlyKeys(req *http.Request) (*http.Response, error) {
	if d.srv.ListReadOnlyKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListReadOnlyKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/readonlykeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ListReadOnlyKeys(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseAccountListReadOnlyKeysResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchNewListUsagesPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesPager not implemented")}
	}
	newListUsagesPager := d.newListUsagesPager.get(req)
	if newListUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armcosmos.DatabaseAccountsClientListUsagesOptions
		if filterParam != nil {
			options = &armcosmos.DatabaseAccountsClientListUsagesOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListUsagesPager(resourceGroupNameParam, accountNameParam, options)
		newListUsagesPager = &resp
		d.newListUsagesPager.add(req, newListUsagesPager)
	}
	resp, err := server.PagerResponderNext(newListUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesPager) {
		d.newListUsagesPager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginOfflineRegion(req *http.Request) (*http.Response, error) {
	if d.srv.BeginOfflineRegion == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginOfflineRegion not implemented")}
	}
	beginOfflineRegion := d.beginOfflineRegion.get(req)
	if beginOfflineRegion == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offlineRegion`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RegionForOnlineOffline](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginOfflineRegion(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginOfflineRegion = &respr
		d.beginOfflineRegion.add(req, beginOfflineRegion)
	}

	resp, err := server.PollerResponderNext(beginOfflineRegion, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginOfflineRegion.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginOfflineRegion) {
		d.beginOfflineRegion.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginOnlineRegion(req *http.Request) (*http.Response, error) {
	if d.srv.BeginOnlineRegion == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginOnlineRegion not implemented")}
	}
	beginOnlineRegion := d.beginOnlineRegion.get(req)
	if beginOnlineRegion == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/onlineRegion`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RegionForOnlineOffline](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginOnlineRegion(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginOnlineRegion = &respr
		d.beginOnlineRegion.add(req, beginOnlineRegion)
	}

	resp, err := server.PollerResponderNext(beginOnlineRegion, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginOnlineRegion.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginOnlineRegion) {
		d.beginOnlineRegion.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginRegenerateKey(req *http.Request) (*http.Response, error) {
	if d.srv.BeginRegenerateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRegenerateKey not implemented")}
	}
	beginRegenerateKey := d.beginRegenerateKey.get(req)
	if beginRegenerateKey == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateKey`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.DatabaseAccountRegenerateKeyParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginRegenerateKey(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRegenerateKey = &respr
		d.beginRegenerateKey.add(req, beginRegenerateKey)
	}

	resp, err := server.PollerResponderNext(beginRegenerateKey, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginRegenerateKey.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRegenerateKey) {
		d.beginRegenerateKey.remove(req)
	}

	return resp, nil
}

func (d *DatabaseAccountsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.DatabaseAccountUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}
