//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datacatalog/armdatacatalog"
	"net/http"
)

// ADCOperationsServer is a fake server for instances of the armdatacatalog.ADCOperationsClient type.
type ADCOperationsServer struct {
	// List is the fake for method ADCOperationsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armdatacatalog.ADCOperationsClientListOptions) (resp azfake.Responder[armdatacatalog.ADCOperationsClientListResponse], errResp azfake.ErrorResponder)
}

// NewADCOperationsServerTransport creates a new instance of ADCOperationsServerTransport with the provided implementation.
// The returned ADCOperationsServerTransport instance is connected to an instance of armdatacatalog.ADCOperationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewADCOperationsServerTransport(srv *ADCOperationsServer) *ADCOperationsServerTransport {
	return &ADCOperationsServerTransport{srv: srv}
}

// ADCOperationsServerTransport connects instances of armdatacatalog.ADCOperationsClient to instances of ADCOperationsServer.
// Don't use this type directly, use NewADCOperationsServerTransport instead.
type ADCOperationsServerTransport struct {
	srv *ADCOperationsServer
}

// Do implements the policy.Transporter interface for ADCOperationsServerTransport.
func (a *ADCOperationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ADCOperationsClient.List":
		resp, err = a.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ADCOperationsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if a.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	respr, errRespr := a.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperationEntityListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
