//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhealthcareapis_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/healthcareapis/armhealthcareapis"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceGet.json
func ExampleServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Get(ctx, "rg1", "service1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServicesDescription = armhealthcareapis.ServicesDescription{
	// 	Name: to.Ptr("service1"),
	// 	Type: to.Ptr("Microsoft.HealthcareApis/services"),
	// 	Etag: to.Ptr("etagvalue"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/service1"),
	// 	Kind: to.Ptr(armhealthcareapis.KindFhirR4),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armhealthcareapis.ServicesProperties{
	// 		AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
	// 			},
	// 			{
	// 				ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
	// 		}},
	// 		AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
	// 			Audience: to.Ptr("https://azurehealthcareapis.com"),
	// 			Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
	// 			SmartProxyEnabled: to.Ptr(true),
	// 		},
	// 		CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
	// 			AllowCredentials: to.Ptr(false),
	// 			Headers: []*string{
	// 				to.Ptr("*")},
	// 				MaxAge: to.Ptr[int32](1440),
	// 				Methods: []*string{
	// 					to.Ptr("DELETE"),
	// 					to.Ptr("GET"),
	// 					to.Ptr("OPTIONS"),
	// 					to.Ptr("PATCH"),
	// 					to.Ptr("POST"),
	// 					to.Ptr("PUT")},
	// 					Origins: []*string{
	// 						to.Ptr("*")},
	// 					},
	// 					CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
	// 						KeyVaultKeyURI: to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
	// 						OfferThroughput: to.Ptr[int32](1000),
	// 					},
	// 					PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
	// 					},
	// 					ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceCreate.json
func ExampleServicesClient_BeginCreateOrUpdate_createOrUpdateAServiceWithAllParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginCreateOrUpdate(ctx, "rg1", "service1", armhealthcareapis.ServicesDescription{
		Identity: &armhealthcareapis.ServicesResourceIdentity{
			Type: to.Ptr(armhealthcareapis.ManagedServiceIdentityTypeSystemAssigned),
		},
		Kind:     to.Ptr(armhealthcareapis.KindFhirR4),
		Location: to.Ptr("westus2"),
		Tags:     map[string]*string{},
		Properties: &armhealthcareapis.ServicesProperties{
			AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
				{
					ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
				},
				{
					ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
				}},
			AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
				Audience:          to.Ptr("https://azurehealthcareapis.com"),
				Authority:         to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
				SmartProxyEnabled: to.Ptr(true),
			},
			CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
				AllowCredentials: to.Ptr(false),
				Headers: []*string{
					to.Ptr("*")},
				MaxAge: to.Ptr[int32](1440),
				Methods: []*string{
					to.Ptr("DELETE"),
					to.Ptr("GET"),
					to.Ptr("OPTIONS"),
					to.Ptr("PATCH"),
					to.Ptr("POST"),
					to.Ptr("PUT")},
				Origins: []*string{
					to.Ptr("*")},
			},
			CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
				KeyVaultKeyURI:  to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
				OfferThroughput: to.Ptr[int32](1000),
			},
			ExportConfiguration: &armhealthcareapis.ServiceExportConfigurationInfo{
				StorageAccountName: to.Ptr("existingStorageAccount"),
			},
			PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{},
			PublicNetworkAccess:        to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServicesDescription = armhealthcareapis.ServicesDescription{
	// 	Name: to.Ptr("service1"),
	// 	Type: to.Ptr("Microsoft.HealthcareApis/services"),
	// 	Etag: to.Ptr("etagvalue"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/service1"),
	// 	Identity: &armhealthcareapis.ServicesResourceIdentity{
	// 		Type: to.Ptr(armhealthcareapis.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("03fe6ae0-952c-4e4b-954b-cc0364dd252e"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d8cd011db47"),
	// 	},
	// 	Kind: to.Ptr(armhealthcareapis.KindFhirR4),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armhealthcareapis.ServicesProperties{
	// 		AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
	// 			},
	// 			{
	// 				ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
	// 		}},
	// 		AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
	// 			Audience: to.Ptr("https://azurehealthcareapis.com"),
	// 			Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
	// 			SmartProxyEnabled: to.Ptr(true),
	// 		},
	// 		CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
	// 			AllowCredentials: to.Ptr(false),
	// 			Headers: []*string{
	// 				to.Ptr("*")},
	// 				MaxAge: to.Ptr[int32](1440),
	// 				Methods: []*string{
	// 					to.Ptr("DELETE"),
	// 					to.Ptr("GET"),
	// 					to.Ptr("OPTIONS"),
	// 					to.Ptr("PATCH"),
	// 					to.Ptr("POST"),
	// 					to.Ptr("PUT")},
	// 					Origins: []*string{
	// 						to.Ptr("*")},
	// 					},
	// 					CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
	// 						KeyVaultKeyURI: to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
	// 						OfferThroughput: to.Ptr[int32](1000),
	// 					},
	// 					ExportConfiguration: &armhealthcareapis.ServiceExportConfigurationInfo{
	// 						StorageAccountName: to.Ptr("existingStorageAccount"),
	// 					},
	// 					PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
	// 					},
	// 					ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceCreateMinimum.json
func ExampleServicesClient_BeginCreateOrUpdate_createOrUpdateAServiceWithMinimumParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginCreateOrUpdate(ctx, "rg1", "service2", armhealthcareapis.ServicesDescription{
		Kind:     to.Ptr(armhealthcareapis.KindFhirR4),
		Location: to.Ptr("westus2"),
		Tags:     map[string]*string{},
		Properties: &armhealthcareapis.ServicesProperties{
			AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
				{
					ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServicesDescription = armhealthcareapis.ServicesDescription{
	// 	Name: to.Ptr("service2"),
	// 	Type: to.Ptr("Microsoft.HealthcareApis/services"),
	// 	Etag: to.Ptr("etagvalue"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/service2"),
	// 	Kind: to.Ptr(armhealthcareapis.KindFhirR4),
	// 	Location: to.Ptr("westus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armhealthcareapis.ServicesProperties{
	// 		AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
	// 		}},
	// 		AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
	// 			Audience: to.Ptr("https://azurehealthcareapis.com"),
	// 			Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
	// 			SmartProxyEnabled: to.Ptr(false),
	// 		},
	// 		CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
	// 			AllowCredentials: to.Ptr(false),
	// 			Headers: []*string{
	// 			},
	// 			Methods: []*string{
	// 			},
	// 			Origins: []*string{
	// 			},
	// 		},
	// 		CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
	// 			OfferThroughput: to.Ptr[int32](1000),
	// 		},
	// 		PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServicePatch.json
func ExampleServicesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginUpdate(ctx, "rg1", "service1", armhealthcareapis.ServicesPatchDescription{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServicesDescription = armhealthcareapis.ServicesDescription{
	// 	Name: to.Ptr("service1"),
	// 	Type: to.Ptr("Microsoft.HealthcareApis/services"),
	// 	Etag: to.Ptr("etagvalue"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/service1"),
	// 	Kind: to.Ptr(armhealthcareapis.KindFhirR4),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armhealthcareapis.ServicesProperties{
	// 		AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
	// 			},
	// 			{
	// 				ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
	// 		}},
	// 		AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
	// 			Audience: to.Ptr("https://azurehealthcareapis.com"),
	// 			Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
	// 			SmartProxyEnabled: to.Ptr(true),
	// 		},
	// 		CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
	// 			AllowCredentials: to.Ptr(false),
	// 			Headers: []*string{
	// 				to.Ptr("*")},
	// 				MaxAge: to.Ptr[int32](1440),
	// 				Methods: []*string{
	// 					to.Ptr("DELETE"),
	// 					to.Ptr("GET"),
	// 					to.Ptr("OPTIONS"),
	// 					to.Ptr("PATCH"),
	// 					to.Ptr("POST"),
	// 					to.Ptr("PUT")},
	// 					Origins: []*string{
	// 						to.Ptr("*")},
	// 					},
	// 					CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
	// 						KeyVaultKeyURI: to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
	// 						OfferThroughput: to.Ptr[int32](1000),
	// 					},
	// 					PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
	// 					},
	// 					ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceDelete.json
func ExampleServicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginDelete(ctx, "rg1", "service1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceList.json
func ExampleServicesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServicesDescriptionListResult = armhealthcareapis.ServicesDescriptionListResult{
		// 	Value: []*armhealthcareapis.ServicesDescription{
		// 		{
		// 			Name: to.Ptr("service1"),
		// 			Type: to.Ptr("Microsoft.HealthcareApis/services"),
		// 			Etag: to.Ptr("etag"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/service1"),
		// 			Kind: to.Ptr(armhealthcareapis.KindFhirR4),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armhealthcareapis.ServicesProperties{
		// 				AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
		// 					{
		// 						ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
		// 					},
		// 					{
		// 						ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
		// 				}},
		// 				AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
		// 					Audience: to.Ptr("https://azurehealthcareapis.com"),
		// 					Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
		// 					SmartProxyEnabled: to.Ptr(true),
		// 				},
		// 				CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
		// 					AllowCredentials: to.Ptr(false),
		// 					Headers: []*string{
		// 						to.Ptr("*")},
		// 						MaxAge: to.Ptr[int32](1440),
		// 						Methods: []*string{
		// 							to.Ptr("DELETE"),
		// 							to.Ptr("GET"),
		// 							to.Ptr("OPTIONS"),
		// 							to.Ptr("PATCH"),
		// 							to.Ptr("POST"),
		// 							to.Ptr("PUT")},
		// 							Origins: []*string{
		// 								to.Ptr("*")},
		// 							},
		// 							CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
		// 								KeyVaultKeyURI: to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
		// 								OfferThroughput: to.Ptr[int32](1000),
		// 							},
		// 							PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
		// 							},
		// 							ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/legacy/ServiceListByResourceGroup.json
func ExampleServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListByResourceGroupPager("rgname", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServicesDescriptionListResult = armhealthcareapis.ServicesDescriptionListResult{
		// 	Value: []*armhealthcareapis.ServicesDescription{
		// 		{
		// 			Name: to.Ptr("service1"),
		// 			Type: to.Ptr("Microsoft.HealthcareApis/services"),
		// 			Etag: to.Ptr("etagvalue"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HealthcareApis/services/dddb8dcb-effb-4290-bb47-ce1e8440c729"),
		// 			Kind: to.Ptr(armhealthcareapis.KindFhirR4),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armhealthcareapis.ServicesProperties{
		// 				AccessPolicies: []*armhealthcareapis.ServiceAccessPolicyEntry{
		// 					{
		// 						ObjectID: to.Ptr("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
		// 					},
		// 					{
		// 						ObjectID: to.Ptr("5b307da8-43d4-492b-8b66-b0294ade872f"),
		// 				}},
		// 				AuthenticationConfiguration: &armhealthcareapis.ServiceAuthenticationConfigurationInfo{
		// 					Audience: to.Ptr("https://azurehealthcareapis.com"),
		// 					Authority: to.Ptr("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
		// 					SmartProxyEnabled: to.Ptr(true),
		// 				},
		// 				CorsConfiguration: &armhealthcareapis.ServiceCorsConfigurationInfo{
		// 					AllowCredentials: to.Ptr(false),
		// 					Headers: []*string{
		// 						to.Ptr("*")},
		// 						MaxAge: to.Ptr[int32](1440),
		// 						Methods: []*string{
		// 							to.Ptr("DELETE"),
		// 							to.Ptr("GET"),
		// 							to.Ptr("OPTIONS"),
		// 							to.Ptr("PATCH"),
		// 							to.Ptr("POST"),
		// 							to.Ptr("PUT")},
		// 							Origins: []*string{
		// 								to.Ptr("*")},
		// 							},
		// 							CosmosDbConfiguration: &armhealthcareapis.ServiceCosmosDbConfigurationInfo{
		// 								KeyVaultKeyURI: to.Ptr("https://my-vault.vault.azure.net/keys/my-key"),
		// 								OfferThroughput: to.Ptr[int32](1000),
		// 							},
		// 							PrivateEndpointConnections: []*armhealthcareapis.PrivateEndpointConnection{
		// 							},
		// 							ProvisioningState: to.Ptr(armhealthcareapis.ProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armhealthcareapis.PublicNetworkAccessDisabled),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2021-11-01/examples/CheckNameAvailabilityPost.json
func ExampleServicesClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhealthcareapis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckNameAvailability(ctx, armhealthcareapis.CheckNameAvailabilityParameters{
		Name: to.Ptr("serviceName"),
		Type: to.Ptr("Microsoft.HealthcareApis/services"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServicesNameAvailabilityInfo = armhealthcareapis.ServicesNameAvailabilityInfo{
	// 	Message: to.Ptr("Service name is not available."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr(armhealthcareapis.ServiceNameUnavailabilityReasonAlreadyExists),
	// }
}
