//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armintegrationspaces

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// InfrastructureResourcesClient contains the methods for the InfrastructureResources group.
// Don't use this type directly, use NewInfrastructureResourcesClient() instead.
type InfrastructureResourcesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewInfrastructureResourcesClient creates a new instance of InfrastructureResourcesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewInfrastructureResourcesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*InfrastructureResourcesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &InfrastructureResourcesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create a InfrastructureResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - infrastructureResourceName - The name of the infrastructure resource in the space.
//   - resource - Resource create parameters.
//   - options - InfrastructureResourcesClientCreateOrUpdateOptions contains the optional parameters for the InfrastructureResourcesClient.CreateOrUpdate
//     method.
func (client *InfrastructureResourcesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, resource InfrastructureResource, options *InfrastructureResourcesClientCreateOrUpdateOptions) (InfrastructureResourcesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "InfrastructureResourcesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, spaceName, infrastructureResourceName, resource, options)
	if err != nil {
		return InfrastructureResourcesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return InfrastructureResourcesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return InfrastructureResourcesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *InfrastructureResourcesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, resource InfrastructureResource, options *InfrastructureResourcesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if infrastructureResourceName == "" {
		return nil, errors.New("parameter infrastructureResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{infrastructureResourceName}", url.PathEscape(infrastructureResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *InfrastructureResourcesClient) createOrUpdateHandleResponse(resp *http.Response) (InfrastructureResourcesClientCreateOrUpdateResponse, error) {
	result := InfrastructureResourcesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InfrastructureResource); err != nil {
		return InfrastructureResourcesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a InfrastructureResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - infrastructureResourceName - The name of the infrastructure resource in the space.
//   - options - InfrastructureResourcesClientDeleteOptions contains the optional parameters for the InfrastructureResourcesClient.Delete
//     method.
func (client *InfrastructureResourcesClient) Delete(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, options *InfrastructureResourcesClientDeleteOptions) (InfrastructureResourcesClientDeleteResponse, error) {
	var err error
	const operationName = "InfrastructureResourcesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, spaceName, infrastructureResourceName, options)
	if err != nil {
		return InfrastructureResourcesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return InfrastructureResourcesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return InfrastructureResourcesClientDeleteResponse{}, err
	}
	return InfrastructureResourcesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *InfrastructureResourcesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, options *InfrastructureResourcesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if infrastructureResourceName == "" {
		return nil, errors.New("parameter infrastructureResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{infrastructureResourceName}", url.PathEscape(infrastructureResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a InfrastructureResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - infrastructureResourceName - The name of the infrastructure resource in the space.
//   - options - InfrastructureResourcesClientGetOptions contains the optional parameters for the InfrastructureResourcesClient.Get
//     method.
func (client *InfrastructureResourcesClient) Get(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, options *InfrastructureResourcesClientGetOptions) (InfrastructureResourcesClientGetResponse, error) {
	var err error
	const operationName = "InfrastructureResourcesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, spaceName, infrastructureResourceName, options)
	if err != nil {
		return InfrastructureResourcesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return InfrastructureResourcesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return InfrastructureResourcesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *InfrastructureResourcesClient) getCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, options *InfrastructureResourcesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if infrastructureResourceName == "" {
		return nil, errors.New("parameter infrastructureResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{infrastructureResourceName}", url.PathEscape(infrastructureResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *InfrastructureResourcesClient) getHandleResponse(resp *http.Response) (InfrastructureResourcesClientGetResponse, error) {
	result := InfrastructureResourcesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InfrastructureResource); err != nil {
		return InfrastructureResourcesClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySpacePager - List InfrastructureResource resources by Space
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - options - InfrastructureResourcesClientListBySpaceOptions contains the optional parameters for the InfrastructureResourcesClient.NewListBySpacePager
//     method.
func (client *InfrastructureResourcesClient) NewListBySpacePager(resourceGroupName string, spaceName string, options *InfrastructureResourcesClientListBySpaceOptions) *runtime.Pager[InfrastructureResourcesClientListBySpaceResponse] {
	return runtime.NewPager(runtime.PagingHandler[InfrastructureResourcesClientListBySpaceResponse]{
		More: func(page InfrastructureResourcesClientListBySpaceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *InfrastructureResourcesClientListBySpaceResponse) (InfrastructureResourcesClientListBySpaceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "InfrastructureResourcesClient.NewListBySpacePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySpaceCreateRequest(ctx, resourceGroupName, spaceName, options)
			}, nil)
			if err != nil {
				return InfrastructureResourcesClientListBySpaceResponse{}, err
			}
			return client.listBySpaceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySpaceCreateRequest creates the ListBySpace request.
func (client *InfrastructureResourcesClient) listBySpaceCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, options *InfrastructureResourcesClientListBySpaceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", strconv.FormatInt(int64(*options.Skip), 10))
	}
	if options != nil && options.Maxpagesize != nil {
		reqQP.Set("maxpagesize", strconv.FormatInt(int64(*options.Maxpagesize), 10))
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.Select != nil {
		for _, qv := range options.Select {
			reqQP.Add("select", qv)
		}
	}
	if options != nil && options.Expand != nil {
		for _, qv := range options.Expand {
			reqQP.Add("expand", qv)
		}
	}
	if options != nil && options.Orderby != nil {
		for _, qv := range options.Orderby {
			reqQP.Add("orderby", qv)
		}
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySpaceHandleResponse handles the ListBySpace response.
func (client *InfrastructureResourcesClient) listBySpaceHandleResponse(resp *http.Response) (InfrastructureResourcesClientListBySpaceResponse, error) {
	result := InfrastructureResourcesClientListBySpaceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InfrastructureResourceListResult); err != nil {
		return InfrastructureResourcesClientListBySpaceResponse{}, err
	}
	return result, nil
}

// Patch - Update a InfrastructureResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - infrastructureResourceName - The name of the infrastructure resource in the space.
//   - properties - The resource properties to be updated.
//   - options - InfrastructureResourcesClientPatchOptions contains the optional parameters for the InfrastructureResourcesClient.Patch
//     method.
func (client *InfrastructureResourcesClient) Patch(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, properties InfrastructureResourceUpdate, options *InfrastructureResourcesClientPatchOptions) (InfrastructureResourcesClientPatchResponse, error) {
	var err error
	const operationName = "InfrastructureResourcesClient.Patch"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchCreateRequest(ctx, resourceGroupName, spaceName, infrastructureResourceName, properties, options)
	if err != nil {
		return InfrastructureResourcesClientPatchResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return InfrastructureResourcesClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return InfrastructureResourcesClientPatchResponse{}, err
	}
	resp, err := client.patchHandleResponse(httpResp)
	return resp, err
}

// patchCreateRequest creates the Patch request.
func (client *InfrastructureResourcesClient) patchCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, infrastructureResourceName string, properties InfrastructureResourceUpdate, options *InfrastructureResourcesClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if infrastructureResourceName == "" {
		return nil, errors.New("parameter infrastructureResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{infrastructureResourceName}", url.PathEscape(infrastructureResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// patchHandleResponse handles the Patch response.
func (client *InfrastructureResourcesClient) patchHandleResponse(resp *http.Response) (InfrastructureResourcesClientPatchResponse, error) {
	result := InfrastructureResourcesClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InfrastructureResource); err != nil {
		return InfrastructureResourcesClientPatchResponse{}, err
	}
	return result, nil
}
