//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessControlList.
func (a AccessControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlList.
func (a *AccessControlList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListAction.
func (a AccessControlListAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "counterName", a.CounterName)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListAction.
func (a *AccessControlListAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "counterName":
			err = unpopulate(val, "CounterName", &a.CounterName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListMatchCondition.
func (a AccessControlListMatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dscpMarkings", a.DscpMarkings)
	populate(objectMap, "etherTypes", a.EtherTypes)
	populate(objectMap, "fragments", a.Fragments)
	populate(objectMap, "ipCondition", a.IPCondition)
	populate(objectMap, "ipLengths", a.IPLengths)
	populate(objectMap, "portCondition", a.PortCondition)
	populate(objectMap, "protocolTypes", a.ProtocolTypes)
	populate(objectMap, "ttlValues", a.TTLValues)
	populate(objectMap, "vlanMatchCondition", a.VlanMatchCondition)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListMatchCondition.
func (a *AccessControlListMatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dscpMarkings":
			err = unpopulate(val, "DscpMarkings", &a.DscpMarkings)
			delete(rawMsg, key)
		case "etherTypes":
			err = unpopulate(val, "EtherTypes", &a.EtherTypes)
			delete(rawMsg, key)
		case "fragments":
			err = unpopulate(val, "Fragments", &a.Fragments)
			delete(rawMsg, key)
		case "ipCondition":
			err = unpopulate(val, "IPCondition", &a.IPCondition)
			delete(rawMsg, key)
		case "ipLengths":
			err = unpopulate(val, "IPLengths", &a.IPLengths)
			delete(rawMsg, key)
		case "portCondition":
			err = unpopulate(val, "PortCondition", &a.PortCondition)
			delete(rawMsg, key)
		case "protocolTypes":
			err = unpopulate(val, "ProtocolTypes", &a.ProtocolTypes)
			delete(rawMsg, key)
		case "ttlValues":
			err = unpopulate(val, "TTLValues", &a.TTLValues)
			delete(rawMsg, key)
		case "vlanMatchCondition":
			err = unpopulate(val, "VlanMatchCondition", &a.VlanMatchCondition)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListMatchConfiguration.
func (a AccessControlListMatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "ipAddressType", a.IPAddressType)
	populate(objectMap, "matchConditions", a.MatchConditions)
	populate(objectMap, "matchConfigurationName", a.MatchConfigurationName)
	populate(objectMap, "sequenceNumber", a.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListMatchConfiguration.
func (a *AccessControlListMatchConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &a.Actions)
			delete(rawMsg, key)
		case "ipAddressType":
			err = unpopulate(val, "IPAddressType", &a.IPAddressType)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &a.MatchConditions)
			delete(rawMsg, key)
		case "matchConfigurationName":
			err = unpopulate(val, "MatchConfigurationName", &a.MatchConfigurationName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &a.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListPatch.
func (a AccessControlListPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListPatch.
func (a *AccessControlListPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListPatchProperties.
func (a AccessControlListPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aclsUrl", a.ACLsURL)
	populate(objectMap, "annotation", a.Annotation)
	populate(objectMap, "configurationType", a.ConfigurationType)
	populate(objectMap, "dynamicMatchConfigurations", a.DynamicMatchConfigurations)
	populate(objectMap, "matchConfigurations", a.MatchConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListPatchProperties.
func (a *AccessControlListPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aclsUrl":
			err = unpopulate(val, "ACLsURL", &a.ACLsURL)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &a.Annotation)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &a.ConfigurationType)
			delete(rawMsg, key)
		case "dynamicMatchConfigurations":
			err = unpopulate(val, "DynamicMatchConfigurations", &a.DynamicMatchConfigurations)
			delete(rawMsg, key)
		case "matchConfigurations":
			err = unpopulate(val, "MatchConfigurations", &a.MatchConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListPortCondition.
func (a AccessControlListPortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "flags", a.Flags)
	populate(objectMap, "layer4Protocol", a.Layer4Protocol)
	populate(objectMap, "portGroupNames", a.PortGroupNames)
	populate(objectMap, "portType", a.PortType)
	populate(objectMap, "ports", a.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListPortCondition.
func (a *AccessControlListPortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "flags":
			err = unpopulate(val, "Flags", &a.Flags)
			delete(rawMsg, key)
		case "layer4Protocol":
			err = unpopulate(val, "Layer4Protocol", &a.Layer4Protocol)
			delete(rawMsg, key)
		case "portGroupNames":
			err = unpopulate(val, "PortGroupNames", &a.PortGroupNames)
			delete(rawMsg, key)
		case "portType":
			err = unpopulate(val, "PortType", &a.PortType)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &a.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListProperties.
func (a AccessControlListProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aclsUrl", a.ACLsURL)
	populate(objectMap, "administrativeState", a.AdministrativeState)
	populate(objectMap, "annotation", a.Annotation)
	populate(objectMap, "configurationState", a.ConfigurationState)
	populate(objectMap, "configurationType", a.ConfigurationType)
	populate(objectMap, "dynamicMatchConfigurations", a.DynamicMatchConfigurations)
	populateDateTimeRFC3339(objectMap, "lastSyncedTime", a.LastSyncedTime)
	populate(objectMap, "matchConfigurations", a.MatchConfigurations)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListProperties.
func (a *AccessControlListProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aclsUrl":
			err = unpopulate(val, "ACLsURL", &a.ACLsURL)
			delete(rawMsg, key)
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &a.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &a.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &a.ConfigurationState)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &a.ConfigurationType)
			delete(rawMsg, key)
		case "dynamicMatchConfigurations":
			err = unpopulate(val, "DynamicMatchConfigurations", &a.DynamicMatchConfigurations)
			delete(rawMsg, key)
		case "lastSyncedTime":
			err = unpopulateDateTimeRFC3339(val, "LastSyncedTime", &a.LastSyncedTime)
			delete(rawMsg, key)
		case "matchConfigurations":
			err = unpopulate(val, "MatchConfigurations", &a.MatchConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlListsListResult.
func (a AccessControlListsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlListsListResult.
func (a *AccessControlListsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionIPCommunityProperties.
func (a ActionIPCommunityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "add", a.Add)
	populate(objectMap, "delete", a.Delete)
	populate(objectMap, "set", a.Set)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionIPCommunityProperties.
func (a *ActionIPCommunityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "add":
			err = unpopulate(val, "Add", &a.Add)
			delete(rawMsg, key)
		case "delete":
			err = unpopulate(val, "Delete", &a.Delete)
			delete(rawMsg, key)
		case "set":
			err = unpopulate(val, "Set", &a.Set)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionIPExtendedCommunityProperties.
func (a ActionIPExtendedCommunityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "add", a.Add)
	populate(objectMap, "delete", a.Delete)
	populate(objectMap, "set", a.Set)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionIPExtendedCommunityProperties.
func (a *ActionIPExtendedCommunityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "add":
			err = unpopulate(val, "Add", &a.Add)
			delete(rawMsg, key)
		case "delete":
			err = unpopulate(val, "Delete", &a.Delete)
			delete(rawMsg, key)
		case "set":
			err = unpopulate(val, "Set", &a.Set)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AggregateRoute.
func (a AggregateRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "prefix", a.Prefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AggregateRoute.
func (a *AggregateRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AggregateRouteConfiguration.
func (a AggregateRouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4Routes", a.IPv4Routes)
	populate(objectMap, "ipv6Routes", a.IPv6Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AggregateRouteConfiguration.
func (a *AggregateRouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4Routes":
			err = unpopulate(val, "IPv4Routes", &a.IPv4Routes)
			delete(rawMsg, key)
		case "ipv6Routes":
			err = unpopulate(val, "IPv6Routes", &a.IPv6Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BfdConfiguration.
func (b BfdConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", b.AdministrativeState)
	populate(objectMap, "intervalInMilliSeconds", b.IntervalInMilliSeconds)
	populate(objectMap, "multiplier", b.Multiplier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BfdConfiguration.
func (b *BfdConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &b.AdministrativeState)
			delete(rawMsg, key)
		case "intervalInMilliSeconds":
			err = unpopulate(val, "IntervalInMilliSeconds", &b.IntervalInMilliSeconds)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &b.Multiplier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpConfiguration.
func (b BgpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowAS", b.AllowAS)
	populate(objectMap, "allowASOverride", b.AllowASOverride)
	populate(objectMap, "annotation", b.Annotation)
	populate(objectMap, "bfdConfiguration", b.BfdConfiguration)
	populate(objectMap, "defaultRouteOriginate", b.DefaultRouteOriginate)
	populate(objectMap, "fabricASN", b.FabricASN)
	populate(objectMap, "ipv4ListenRangePrefixes", b.IPv4ListenRangePrefixes)
	populate(objectMap, "ipv4NeighborAddress", b.IPv4NeighborAddress)
	populate(objectMap, "ipv6ListenRangePrefixes", b.IPv6ListenRangePrefixes)
	populate(objectMap, "ipv6NeighborAddress", b.IPv6NeighborAddress)
	populate(objectMap, "peerASN", b.PeerASN)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpConfiguration.
func (b *BgpConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowAS":
			err = unpopulate(val, "AllowAS", &b.AllowAS)
			delete(rawMsg, key)
		case "allowASOverride":
			err = unpopulate(val, "AllowASOverride", &b.AllowASOverride)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &b.Annotation)
			delete(rawMsg, key)
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &b.BfdConfiguration)
			delete(rawMsg, key)
		case "defaultRouteOriginate":
			err = unpopulate(val, "DefaultRouteOriginate", &b.DefaultRouteOriginate)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &b.FabricASN)
			delete(rawMsg, key)
		case "ipv4ListenRangePrefixes":
			err = unpopulate(val, "IPv4ListenRangePrefixes", &b.IPv4ListenRangePrefixes)
			delete(rawMsg, key)
		case "ipv4NeighborAddress":
			err = unpopulate(val, "IPv4NeighborAddress", &b.IPv4NeighborAddress)
			delete(rawMsg, key)
		case "ipv6ListenRangePrefixes":
			err = unpopulate(val, "IPv6ListenRangePrefixes", &b.IPv6ListenRangePrefixes)
			delete(rawMsg, key)
		case "ipv6NeighborAddress":
			err = unpopulate(val, "IPv6NeighborAddress", &b.IPv6NeighborAddress)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &b.PeerASN)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDynamicMatchConfiguration.
func (c CommonDynamicMatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipGroups", c.IPGroups)
	populate(objectMap, "portGroups", c.PortGroups)
	populate(objectMap, "vlanGroups", c.VlanGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDynamicMatchConfiguration.
func (c *CommonDynamicMatchConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipGroups":
			err = unpopulate(val, "IPGroups", &c.IPGroups)
			delete(rawMsg, key)
		case "portGroups":
			err = unpopulate(val, "PortGroups", &c.PortGroups)
			delete(rawMsg, key)
		case "vlanGroups":
			err = unpopulate(val, "VlanGroups", &c.VlanGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonPostActionResponseForDeviceUpdate.
func (c CommonPostActionResponseForDeviceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationState", c.ConfigurationState)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "failedDevices", c.FailedDevices)
	populate(objectMap, "successfulDevices", c.SuccessfulDevices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonPostActionResponseForDeviceUpdate.
func (c *CommonPostActionResponseForDeviceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &c.ConfigurationState)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "failedDevices":
			err = unpopulate(val, "FailedDevices", &c.FailedDevices)
			delete(rawMsg, key)
		case "successfulDevices":
			err = unpopulate(val, "SuccessfulDevices", &c.SuccessfulDevices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonPostActionResponseForStateUpdate.
func (c CommonPostActionResponseForStateUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationState", c.ConfigurationState)
	populate(objectMap, "error", c.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonPostActionResponseForStateUpdate.
func (c *CommonPostActionResponseForStateUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &c.ConfigurationState)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedSubnet.
func (c ConnectedSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", c.Annotation)
	populate(objectMap, "prefix", c.Prefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedSubnet.
func (c *ConnectedSubnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &c.Annotation)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &c.Prefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedSubnetRoutePolicy.
func (c ConnectedSubnetRoutePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportRoutePolicy", c.ExportRoutePolicy)
	populate(objectMap, "exportRoutePolicyId", c.ExportRoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedSubnetRoutePolicy.
func (c *ConnectedSubnetRoutePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &c.ExportRoutePolicy)
			delete(rawMsg, key)
		case "exportRoutePolicyId":
			err = unpopulate(val, "ExportRoutePolicyID", &c.ExportRoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControllerServices.
func (c ControllerServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4AddressSpaces", c.IPv4AddressSpaces)
	populate(objectMap, "ipv6AddressSpaces", c.IPv6AddressSpaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControllerServices.
func (c *ControllerServices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4AddressSpaces":
			err = unpopulate(val, "IPv4AddressSpaces", &c.IPv4AddressSpaces)
			delete(rawMsg, key)
		case "ipv6AddressSpaces":
			err = unpopulate(val, "IPv6AddressSpaces", &c.IPv6AddressSpaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceInterfaceProperties.
func (d DeviceInterfaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", d.Identifier)
	populate(objectMap, "interfaceType", d.InterfaceType)
	populate(objectMap, "supportedConnectorTypes", d.SupportedConnectorTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceInterfaceProperties.
func (d *DeviceInterfaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &d.Identifier)
			delete(rawMsg, key)
		case "interfaceType":
			err = unpopulate(val, "InterfaceType", &d.InterfaceType)
			delete(rawMsg, key)
		case "supportedConnectorTypes":
			err = unpopulate(val, "SupportedConnectorTypes", &d.SupportedConnectorTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRoutePolicy.
func (e ExportRoutePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportIpv4RoutePolicyId", e.ExportIPv4RoutePolicyID)
	populate(objectMap, "exportIpv6RoutePolicyId", e.ExportIPv6RoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRoutePolicy.
func (e *ExportRoutePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportIpv4RoutePolicyId":
			err = unpopulate(val, "ExportIPv4RoutePolicyID", &e.ExportIPv4RoutePolicyID)
			delete(rawMsg, key)
		case "exportIpv6RoutePolicyId":
			err = unpopulate(val, "ExportIPv6RoutePolicyID", &e.ExportIPv6RoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRoutePolicyInformation.
func (e ExportRoutePolicyInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportIpv4RoutePolicyId", e.ExportIPv4RoutePolicyID)
	populate(objectMap, "exportIpv6RoutePolicyId", e.ExportIPv6RoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRoutePolicyInformation.
func (e *ExportRoutePolicyInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportIpv4RoutePolicyId":
			err = unpopulate(val, "ExportIPv4RoutePolicyID", &e.ExportIPv4RoutePolicyID)
			delete(rawMsg, key)
		case "exportIpv6RoutePolicyId":
			err = unpopulate(val, "ExportIPv6RoutePolicyID", &e.ExportIPv6RoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteConnectionInformation.
func (e ExpressRouteConnectionInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expressRouteAuthorizationKey", e.ExpressRouteAuthorizationKey)
	populate(objectMap, "expressRouteCircuitId", e.ExpressRouteCircuitID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteConnectionInformation.
func (e *ExpressRouteConnectionInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expressRouteAuthorizationKey":
			err = unpopulate(val, "ExpressRouteAuthorizationKey", &e.ExpressRouteAuthorizationKey)
			delete(rawMsg, key)
		case "expressRouteCircuitId":
			err = unpopulate(val, "ExpressRouteCircuitID", &e.ExpressRouteCircuitID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetwork.
func (e ExternalNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetwork.
func (e *ExternalNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworkPatch.
func (e ExternalNetworkPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworkPatch.
func (e *ExternalNetworkPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworkPatchProperties.
func (e ExternalNetworkPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", e.Annotation)
	populate(objectMap, "exportRoutePolicy", e.ExportRoutePolicy)
	populate(objectMap, "exportRoutePolicyId", e.ExportRoutePolicyID)
	populate(objectMap, "importRoutePolicy", e.ImportRoutePolicy)
	populate(objectMap, "importRoutePolicyId", e.ImportRoutePolicyID)
	populate(objectMap, "optionAProperties", e.OptionAProperties)
	populate(objectMap, "optionBProperties", e.OptionBProperties)
	populate(objectMap, "peeringOption", e.PeeringOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworkPatchProperties.
func (e *ExternalNetworkPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &e.Annotation)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &e.ExportRoutePolicy)
			delete(rawMsg, key)
		case "exportRoutePolicyId":
			err = unpopulate(val, "ExportRoutePolicyID", &e.ExportRoutePolicyID)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &e.ImportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicyId":
			err = unpopulate(val, "ImportRoutePolicyID", &e.ImportRoutePolicyID)
			delete(rawMsg, key)
		case "optionAProperties":
			err = unpopulate(val, "OptionAProperties", &e.OptionAProperties)
			delete(rawMsg, key)
		case "optionBProperties":
			err = unpopulate(val, "OptionBProperties", &e.OptionBProperties)
			delete(rawMsg, key)
		case "peeringOption":
			err = unpopulate(val, "PeeringOption", &e.PeeringOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworkPatchPropertiesOptionAProperties.
func (e ExternalNetworkPatchPropertiesOptionAProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", e.BfdConfiguration)
	populate(objectMap, "egressAclId", e.EgressACLID)
	populate(objectMap, "fabricASN", e.FabricASN)
	populate(objectMap, "ingressAclId", e.IngressACLID)
	populate(objectMap, "mtu", e.Mtu)
	populate(objectMap, "peerASN", e.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", e.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", e.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", e.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", e.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", e.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworkPatchPropertiesOptionAProperties.
func (e *ExternalNetworkPatchPropertiesOptionAProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &e.BfdConfiguration)
			delete(rawMsg, key)
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &e.EgressACLID)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &e.FabricASN)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &e.IngressACLID)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &e.Mtu)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &e.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &e.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &e.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &e.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &e.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &e.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworkProperties.
func (e ExternalNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", e.AdministrativeState)
	populate(objectMap, "annotation", e.Annotation)
	populate(objectMap, "configurationState", e.ConfigurationState)
	populate(objectMap, "exportRoutePolicy", e.ExportRoutePolicy)
	populate(objectMap, "exportRoutePolicyId", e.ExportRoutePolicyID)
	populate(objectMap, "importRoutePolicy", e.ImportRoutePolicy)
	populate(objectMap, "importRoutePolicyId", e.ImportRoutePolicyID)
	populate(objectMap, "networkToNetworkInterconnectId", e.NetworkToNetworkInterconnectID)
	populate(objectMap, "optionAProperties", e.OptionAProperties)
	populate(objectMap, "optionBProperties", e.OptionBProperties)
	populate(objectMap, "peeringOption", e.PeeringOption)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworkProperties.
func (e *ExternalNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &e.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &e.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &e.ConfigurationState)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &e.ExportRoutePolicy)
			delete(rawMsg, key)
		case "exportRoutePolicyId":
			err = unpopulate(val, "ExportRoutePolicyID", &e.ExportRoutePolicyID)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &e.ImportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicyId":
			err = unpopulate(val, "ImportRoutePolicyID", &e.ImportRoutePolicyID)
			delete(rawMsg, key)
		case "networkToNetworkInterconnectId":
			err = unpopulate(val, "NetworkToNetworkInterconnectID", &e.NetworkToNetworkInterconnectID)
			delete(rawMsg, key)
		case "optionAProperties":
			err = unpopulate(val, "OptionAProperties", &e.OptionAProperties)
			delete(rawMsg, key)
		case "optionBProperties":
			err = unpopulate(val, "OptionBProperties", &e.OptionBProperties)
			delete(rawMsg, key)
		case "peeringOption":
			err = unpopulate(val, "PeeringOption", &e.PeeringOption)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworkPropertiesOptionAProperties.
func (e ExternalNetworkPropertiesOptionAProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", e.BfdConfiguration)
	populate(objectMap, "egressAclId", e.EgressACLID)
	populate(objectMap, "fabricASN", e.FabricASN)
	populate(objectMap, "ingressAclId", e.IngressACLID)
	populate(objectMap, "mtu", e.Mtu)
	populate(objectMap, "peerASN", e.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", e.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", e.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", e.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", e.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", e.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworkPropertiesOptionAProperties.
func (e *ExternalNetworkPropertiesOptionAProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &e.BfdConfiguration)
			delete(rawMsg, key)
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &e.EgressACLID)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &e.FabricASN)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &e.IngressACLID)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &e.Mtu)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &e.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &e.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &e.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &e.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &e.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &e.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalNetworksList.
func (e ExternalNetworksList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalNetworksList.
func (e *ExternalNetworksList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunitiesListResult.
func (i IPCommunitiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunitiesListResult.
func (i *IPCommunitiesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunity.
func (i IPCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunity.
func (i *IPCommunity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunityIDList.
func (i IPCommunityIDList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipCommunityIds", i.IPCommunityIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunityIDList.
func (i *IPCommunityIDList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipCommunityIds":
			err = unpopulate(val, "IPCommunityIDs", &i.IPCommunityIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunityPatch.
func (i IPCommunityPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunityPatch.
func (i *IPCommunityPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunityPatchableProperties.
func (i IPCommunityPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipCommunityRules", i.IPCommunityRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunityPatchableProperties.
func (i *IPCommunityPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipCommunityRules":
			err = unpopulate(val, "IPCommunityRules", &i.IPCommunityRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunityProperties.
func (i IPCommunityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", i.AdministrativeState)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "configurationState", i.ConfigurationState)
	populate(objectMap, "ipCommunityRules", i.IPCommunityRules)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunityProperties.
func (i *IPCommunityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &i.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &i.ConfigurationState)
			delete(rawMsg, key)
		case "ipCommunityRules":
			err = unpopulate(val, "IPCommunityRules", &i.IPCommunityRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPCommunityRule.
func (i IPCommunityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "communityMembers", i.CommunityMembers)
	populate(objectMap, "sequenceNumber", i.SequenceNumber)
	populate(objectMap, "wellKnownCommunities", i.WellKnownCommunities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPCommunityRule.
func (i *IPCommunityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "communityMembers":
			err = unpopulate(val, "CommunityMembers", &i.CommunityMembers)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &i.SequenceNumber)
			delete(rawMsg, key)
		case "wellKnownCommunities":
			err = unpopulate(val, "WellKnownCommunities", &i.WellKnownCommunities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunity.
func (i IPExtendedCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunity.
func (i *IPExtendedCommunity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityIDList.
func (i IPExtendedCommunityIDList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipExtendedCommunityIds", i.IPExtendedCommunityIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityIDList.
func (i *IPExtendedCommunityIDList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipExtendedCommunityIds":
			err = unpopulate(val, "IPExtendedCommunityIDs", &i.IPExtendedCommunityIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityListResult.
func (i IPExtendedCommunityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityListResult.
func (i *IPExtendedCommunityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityPatch.
func (i IPExtendedCommunityPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityPatch.
func (i *IPExtendedCommunityPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityPatchProperties.
func (i IPExtendedCommunityPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "ipExtendedCommunityRules", i.IPExtendedCommunityRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityPatchProperties.
func (i *IPExtendedCommunityPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "ipExtendedCommunityRules":
			err = unpopulate(val, "IPExtendedCommunityRules", &i.IPExtendedCommunityRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityProperties.
func (i IPExtendedCommunityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", i.AdministrativeState)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "configurationState", i.ConfigurationState)
	populate(objectMap, "ipExtendedCommunityRules", i.IPExtendedCommunityRules)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityProperties.
func (i *IPExtendedCommunityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &i.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &i.ConfigurationState)
			delete(rawMsg, key)
		case "ipExtendedCommunityRules":
			err = unpopulate(val, "IPExtendedCommunityRules", &i.IPExtendedCommunityRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPExtendedCommunityRule.
func (i IPExtendedCommunityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "routeTargets", i.RouteTargets)
	populate(objectMap, "sequenceNumber", i.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPExtendedCommunityRule.
func (i *IPExtendedCommunityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "routeTargets":
			err = unpopulate(val, "RouteTargets", &i.RouteTargets)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &i.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPGroupProperties.
func (i IPGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddressType", i.IPAddressType)
	populate(objectMap, "ipPrefixes", i.IPPrefixes)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPGroupProperties.
func (i *IPGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddressType":
			err = unpopulate(val, "IPAddressType", &i.IPAddressType)
			delete(rawMsg, key)
		case "ipPrefixes":
			err = unpopulate(val, "IPPrefixes", &i.IPPrefixes)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPMatchCondition.
func (i IPMatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipGroupNames", i.IPGroupNames)
	populate(objectMap, "ipPrefixValues", i.IPPrefixValues)
	populate(objectMap, "prefixType", i.PrefixType)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPMatchCondition.
func (i *IPMatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipGroupNames":
			err = unpopulate(val, "IPGroupNames", &i.IPGroupNames)
			delete(rawMsg, key)
		case "ipPrefixValues":
			err = unpopulate(val, "IPPrefixValues", &i.IPPrefixValues)
			delete(rawMsg, key)
		case "prefixType":
			err = unpopulate(val, "PrefixType", &i.PrefixType)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefix.
func (i IPPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefix.
func (i *IPPrefix) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixPatch.
func (i IPPrefixPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixPatch.
func (i *IPPrefixPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixPatchProperties.
func (i IPPrefixPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "ipPrefixRules", i.IPPrefixRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixPatchProperties.
func (i *IPPrefixPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "ipPrefixRules":
			err = unpopulate(val, "IPPrefixRules", &i.IPPrefixRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixProperties.
func (i IPPrefixProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", i.AdministrativeState)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "configurationState", i.ConfigurationState)
	populate(objectMap, "ipPrefixRules", i.IPPrefixRules)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixProperties.
func (i *IPPrefixProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &i.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &i.ConfigurationState)
			delete(rawMsg, key)
		case "ipPrefixRules":
			err = unpopulate(val, "IPPrefixRules", &i.IPPrefixRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixRule.
func (i IPPrefixRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "condition", i.Condition)
	populate(objectMap, "networkPrefix", i.NetworkPrefix)
	populate(objectMap, "sequenceNumber", i.SequenceNumber)
	populate(objectMap, "subnetMaskLength", i.SubnetMaskLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixRule.
func (i *IPPrefixRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &i.Condition)
			delete(rawMsg, key)
		case "networkPrefix":
			err = unpopulate(val, "NetworkPrefix", &i.NetworkPrefix)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &i.SequenceNumber)
			delete(rawMsg, key)
		case "subnetMaskLength":
			err = unpopulate(val, "SubnetMaskLength", &i.SubnetMaskLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixesListResult.
func (i IPPrefixesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixesListResult.
func (i *IPPrefixesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportRoutePolicy.
func (i ImportRoutePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "importIpv4RoutePolicyId", i.ImportIPv4RoutePolicyID)
	populate(objectMap, "importIpv6RoutePolicyId", i.ImportIPv6RoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportRoutePolicy.
func (i *ImportRoutePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "importIpv4RoutePolicyId":
			err = unpopulate(val, "ImportIPv4RoutePolicyID", &i.ImportIPv4RoutePolicyID)
			delete(rawMsg, key)
		case "importIpv6RoutePolicyId":
			err = unpopulate(val, "ImportIPv6RoutePolicyID", &i.ImportIPv6RoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportRoutePolicyInformation.
func (i ImportRoutePolicyInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "importIpv4RoutePolicyId", i.ImportIPv4RoutePolicyID)
	populate(objectMap, "importIpv6RoutePolicyId", i.ImportIPv6RoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportRoutePolicyInformation.
func (i *ImportRoutePolicyInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "importIpv4RoutePolicyId":
			err = unpopulate(val, "ImportIPv4RoutePolicyID", &i.ImportIPv4RoutePolicyID)
			delete(rawMsg, key)
		case "importIpv6RoutePolicyId":
			err = unpopulate(val, "ImportIPv6RoutePolicyID", &i.ImportIPv6RoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetwork.
func (i InternalNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetwork.
func (i *InternalNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworkPatch.
func (i InternalNetworkPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworkPatch.
func (i *InternalNetworkPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworkPatchProperties.
func (i InternalNetworkPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "bgpConfiguration", i.BgpConfiguration)
	populate(objectMap, "connectedIPv4Subnets", i.ConnectedIPv4Subnets)
	populate(objectMap, "connectedIPv6Subnets", i.ConnectedIPv6Subnets)
	populate(objectMap, "egressAclId", i.EgressACLID)
	populate(objectMap, "exportRoutePolicy", i.ExportRoutePolicy)
	populate(objectMap, "exportRoutePolicyId", i.ExportRoutePolicyID)
	populate(objectMap, "importRoutePolicy", i.ImportRoutePolicy)
	populate(objectMap, "importRoutePolicyId", i.ImportRoutePolicyID)
	populate(objectMap, "ingressAclId", i.IngressACLID)
	populate(objectMap, "isMonitoringEnabled", i.IsMonitoringEnabled)
	populate(objectMap, "mtu", i.Mtu)
	populate(objectMap, "staticRouteConfiguration", i.StaticRouteConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworkPatchProperties.
func (i *InternalNetworkPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "bgpConfiguration":
			err = unpopulate(val, "BgpConfiguration", &i.BgpConfiguration)
			delete(rawMsg, key)
		case "connectedIPv4Subnets":
			err = unpopulate(val, "ConnectedIPv4Subnets", &i.ConnectedIPv4Subnets)
			delete(rawMsg, key)
		case "connectedIPv6Subnets":
			err = unpopulate(val, "ConnectedIPv6Subnets", &i.ConnectedIPv6Subnets)
			delete(rawMsg, key)
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &i.EgressACLID)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &i.ExportRoutePolicy)
			delete(rawMsg, key)
		case "exportRoutePolicyId":
			err = unpopulate(val, "ExportRoutePolicyID", &i.ExportRoutePolicyID)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &i.ImportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicyId":
			err = unpopulate(val, "ImportRoutePolicyID", &i.ImportRoutePolicyID)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &i.IngressACLID)
			delete(rawMsg, key)
		case "isMonitoringEnabled":
			err = unpopulate(val, "IsMonitoringEnabled", &i.IsMonitoringEnabled)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &i.Mtu)
			delete(rawMsg, key)
		case "staticRouteConfiguration":
			err = unpopulate(val, "StaticRouteConfiguration", &i.StaticRouteConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworkProperties.
func (i InternalNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", i.AdministrativeState)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "bgpConfiguration", i.BgpConfiguration)
	populate(objectMap, "configurationState", i.ConfigurationState)
	populate(objectMap, "connectedIPv4Subnets", i.ConnectedIPv4Subnets)
	populate(objectMap, "connectedIPv6Subnets", i.ConnectedIPv6Subnets)
	populate(objectMap, "egressAclId", i.EgressACLID)
	populate(objectMap, "exportRoutePolicy", i.ExportRoutePolicy)
	populate(objectMap, "exportRoutePolicyId", i.ExportRoutePolicyID)
	populate(objectMap, "extension", i.Extension)
	populate(objectMap, "importRoutePolicy", i.ImportRoutePolicy)
	populate(objectMap, "importRoutePolicyId", i.ImportRoutePolicyID)
	populate(objectMap, "ingressAclId", i.IngressACLID)
	populate(objectMap, "isMonitoringEnabled", i.IsMonitoringEnabled)
	populate(objectMap, "mtu", i.Mtu)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "staticRouteConfiguration", i.StaticRouteConfiguration)
	populate(objectMap, "vlanId", i.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworkProperties.
func (i *InternalNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &i.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "bgpConfiguration":
			err = unpopulate(val, "BgpConfiguration", &i.BgpConfiguration)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &i.ConfigurationState)
			delete(rawMsg, key)
		case "connectedIPv4Subnets":
			err = unpopulate(val, "ConnectedIPv4Subnets", &i.ConnectedIPv4Subnets)
			delete(rawMsg, key)
		case "connectedIPv6Subnets":
			err = unpopulate(val, "ConnectedIPv6Subnets", &i.ConnectedIPv6Subnets)
			delete(rawMsg, key)
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &i.EgressACLID)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &i.ExportRoutePolicy)
			delete(rawMsg, key)
		case "exportRoutePolicyId":
			err = unpopulate(val, "ExportRoutePolicyID", &i.ExportRoutePolicyID)
			delete(rawMsg, key)
		case "extension":
			err = unpopulate(val, "Extension", &i.Extension)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &i.ImportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicyId":
			err = unpopulate(val, "ImportRoutePolicyID", &i.ImportRoutePolicyID)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &i.IngressACLID)
			delete(rawMsg, key)
		case "isMonitoringEnabled":
			err = unpopulate(val, "IsMonitoringEnabled", &i.IsMonitoringEnabled)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &i.Mtu)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "staticRouteConfiguration":
			err = unpopulate(val, "StaticRouteConfiguration", &i.StaticRouteConfiguration)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &i.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworkPropertiesBgpConfiguration.
func (i InternalNetworkPropertiesBgpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowAS", i.AllowAS)
	populate(objectMap, "allowASOverride", i.AllowASOverride)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "bfdConfiguration", i.BfdConfiguration)
	populate(objectMap, "defaultRouteOriginate", i.DefaultRouteOriginate)
	populate(objectMap, "fabricASN", i.FabricASN)
	populate(objectMap, "ipv4ListenRangePrefixes", i.IPv4ListenRangePrefixes)
	populate(objectMap, "ipv4NeighborAddress", i.IPv4NeighborAddress)
	populate(objectMap, "ipv6ListenRangePrefixes", i.IPv6ListenRangePrefixes)
	populate(objectMap, "ipv6NeighborAddress", i.IPv6NeighborAddress)
	populate(objectMap, "peerASN", i.PeerASN)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworkPropertiesBgpConfiguration.
func (i *InternalNetworkPropertiesBgpConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowAS":
			err = unpopulate(val, "AllowAS", &i.AllowAS)
			delete(rawMsg, key)
		case "allowASOverride":
			err = unpopulate(val, "AllowASOverride", &i.AllowASOverride)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &i.BfdConfiguration)
			delete(rawMsg, key)
		case "defaultRouteOriginate":
			err = unpopulate(val, "DefaultRouteOriginate", &i.DefaultRouteOriginate)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &i.FabricASN)
			delete(rawMsg, key)
		case "ipv4ListenRangePrefixes":
			err = unpopulate(val, "IPv4ListenRangePrefixes", &i.IPv4ListenRangePrefixes)
			delete(rawMsg, key)
		case "ipv4NeighborAddress":
			err = unpopulate(val, "IPv4NeighborAddress", &i.IPv4NeighborAddress)
			delete(rawMsg, key)
		case "ipv6ListenRangePrefixes":
			err = unpopulate(val, "IPv6ListenRangePrefixes", &i.IPv6ListenRangePrefixes)
			delete(rawMsg, key)
		case "ipv6NeighborAddress":
			err = unpopulate(val, "IPv6NeighborAddress", &i.IPv6NeighborAddress)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &i.PeerASN)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworkPropertiesStaticRouteConfiguration.
func (i InternalNetworkPropertiesStaticRouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", i.BfdConfiguration)
	populate(objectMap, "extension", i.Extension)
	populate(objectMap, "ipv4Routes", i.IPv4Routes)
	populate(objectMap, "ipv6Routes", i.IPv6Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworkPropertiesStaticRouteConfiguration.
func (i *InternalNetworkPropertiesStaticRouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &i.BfdConfiguration)
			delete(rawMsg, key)
		case "extension":
			err = unpopulate(val, "Extension", &i.Extension)
			delete(rawMsg, key)
		case "ipv4Routes":
			err = unpopulate(val, "IPv4Routes", &i.IPv4Routes)
			delete(rawMsg, key)
		case "ipv6Routes":
			err = unpopulate(val, "IPv6Routes", &i.IPv6Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternalNetworksList.
func (i InternalNetworksList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternalNetworksList.
func (i *InternalNetworksList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGateway.
func (i InternetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGateway.
func (i *InternetGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayPatch.
func (i InternetGatewayPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayPatch.
func (i *InternetGatewayPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayPatchableProperties.
func (i InternetGatewayPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "internetGatewayRuleId", i.InternetGatewayRuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayPatchableProperties.
func (i *InternetGatewayPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "internetGatewayRuleId":
			err = unpopulate(val, "InternetGatewayRuleID", &i.InternetGatewayRuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayProperties.
func (i InternetGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "ipv4Address", i.IPv4Address)
	populate(objectMap, "internetGatewayRuleId", i.InternetGatewayRuleID)
	populate(objectMap, "networkFabricControllerId", i.NetworkFabricControllerID)
	populate(objectMap, "port", i.Port)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayProperties.
func (i *InternetGatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &i.IPv4Address)
			delete(rawMsg, key)
		case "internetGatewayRuleId":
			err = unpopulate(val, "InternetGatewayRuleID", &i.InternetGatewayRuleID)
			delete(rawMsg, key)
		case "networkFabricControllerId":
			err = unpopulate(val, "NetworkFabricControllerID", &i.NetworkFabricControllerID)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &i.Port)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayRule.
func (i InternetGatewayRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayRule.
func (i *InternetGatewayRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayRulePatch.
func (i InternetGatewayRulePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayRulePatch.
func (i *InternetGatewayRulePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayRuleProperties.
func (i InternetGatewayRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", i.Annotation)
	populate(objectMap, "internetGatewayIds", i.InternetGatewayIDs)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "ruleProperties", i.RuleProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayRuleProperties.
func (i *InternetGatewayRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &i.Annotation)
			delete(rawMsg, key)
		case "internetGatewayIds":
			err = unpopulate(val, "InternetGatewayIDs", &i.InternetGatewayIDs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "ruleProperties":
			err = unpopulate(val, "RuleProperties", &i.RuleProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewayRulesListResult.
func (i InternetGatewayRulesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewayRulesListResult.
func (i *InternetGatewayRulesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InternetGatewaysListResult.
func (i InternetGatewaysListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InternetGatewaysListResult.
func (i *InternetGatewaysListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IsolationDomainProperties.
func (i IsolationDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encapsulation", i.Encapsulation)
	populate(objectMap, "neighborGroupIds", i.NeighborGroupIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IsolationDomainProperties.
func (i *IsolationDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encapsulation":
			err = unpopulate(val, "Encapsulation", &i.Encapsulation)
			delete(rawMsg, key)
		case "neighborGroupIds":
			err = unpopulate(val, "NeighborGroupIDs", &i.NeighborGroupIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2IsolationDomain.
func (l L2IsolationDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2IsolationDomain.
func (l *L2IsolationDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2IsolationDomainPatch.
func (l L2IsolationDomainPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2IsolationDomainPatch.
func (l *L2IsolationDomainPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2IsolationDomainPatchProperties.
func (l L2IsolationDomainPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", l.Annotation)
	populate(objectMap, "mtu", l.Mtu)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2IsolationDomainPatchProperties.
func (l *L2IsolationDomainPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &l.Annotation)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &l.Mtu)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2IsolationDomainProperties.
func (l L2IsolationDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", l.AdministrativeState)
	populate(objectMap, "annotation", l.Annotation)
	populate(objectMap, "configurationState", l.ConfigurationState)
	populate(objectMap, "mtu", l.Mtu)
	populate(objectMap, "networkFabricId", l.NetworkFabricID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "vlanId", l.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2IsolationDomainProperties.
func (l *L2IsolationDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &l.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &l.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &l.ConfigurationState)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &l.Mtu)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &l.NetworkFabricID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &l.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2IsolationDomainsListResult.
func (l L2IsolationDomainsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2IsolationDomainsListResult.
func (l *L2IsolationDomainsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3ExportRoutePolicy.
func (l L3ExportRoutePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportIpv4RoutePolicyId", l.ExportIPv4RoutePolicyID)
	populate(objectMap, "exportIpv6RoutePolicyId", l.ExportIPv6RoutePolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3ExportRoutePolicy.
func (l *L3ExportRoutePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportIpv4RoutePolicyId":
			err = unpopulate(val, "ExportIPv4RoutePolicyID", &l.ExportIPv4RoutePolicyID)
			delete(rawMsg, key)
		case "exportIpv6RoutePolicyId":
			err = unpopulate(val, "ExportIPv6RoutePolicyID", &l.ExportIPv6RoutePolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3IsolationDomain.
func (l L3IsolationDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3IsolationDomain.
func (l *L3IsolationDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3IsolationDomainPatch.
func (l L3IsolationDomainPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3IsolationDomainPatch.
func (l *L3IsolationDomainPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3IsolationDomainPatchProperties.
func (l L3IsolationDomainPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregateRouteConfiguration", l.AggregateRouteConfiguration)
	populate(objectMap, "annotation", l.Annotation)
	populate(objectMap, "connectedSubnetRoutePolicy", l.ConnectedSubnetRoutePolicy)
	populate(objectMap, "redistributeConnectedSubnets", l.RedistributeConnectedSubnets)
	populate(objectMap, "redistributeStaticRoutes", l.RedistributeStaticRoutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3IsolationDomainPatchProperties.
func (l *L3IsolationDomainPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregateRouteConfiguration":
			err = unpopulate(val, "AggregateRouteConfiguration", &l.AggregateRouteConfiguration)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &l.Annotation)
			delete(rawMsg, key)
		case "connectedSubnetRoutePolicy":
			err = unpopulate(val, "ConnectedSubnetRoutePolicy", &l.ConnectedSubnetRoutePolicy)
			delete(rawMsg, key)
		case "redistributeConnectedSubnets":
			err = unpopulate(val, "RedistributeConnectedSubnets", &l.RedistributeConnectedSubnets)
			delete(rawMsg, key)
		case "redistributeStaticRoutes":
			err = unpopulate(val, "RedistributeStaticRoutes", &l.RedistributeStaticRoutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3IsolationDomainProperties.
func (l L3IsolationDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", l.AdministrativeState)
	populate(objectMap, "aggregateRouteConfiguration", l.AggregateRouteConfiguration)
	populate(objectMap, "annotation", l.Annotation)
	populate(objectMap, "configurationState", l.ConfigurationState)
	populate(objectMap, "connectedSubnetRoutePolicy", l.ConnectedSubnetRoutePolicy)
	populate(objectMap, "networkFabricId", l.NetworkFabricID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "redistributeConnectedSubnets", l.RedistributeConnectedSubnets)
	populate(objectMap, "redistributeStaticRoutes", l.RedistributeStaticRoutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3IsolationDomainProperties.
func (l *L3IsolationDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &l.AdministrativeState)
			delete(rawMsg, key)
		case "aggregateRouteConfiguration":
			err = unpopulate(val, "AggregateRouteConfiguration", &l.AggregateRouteConfiguration)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &l.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &l.ConfigurationState)
			delete(rawMsg, key)
		case "connectedSubnetRoutePolicy":
			err = unpopulate(val, "ConnectedSubnetRoutePolicy", &l.ConnectedSubnetRoutePolicy)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &l.NetworkFabricID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "redistributeConnectedSubnets":
			err = unpopulate(val, "RedistributeConnectedSubnets", &l.RedistributeConnectedSubnets)
			delete(rawMsg, key)
		case "redistributeStaticRoutes":
			err = unpopulate(val, "RedistributeStaticRoutes", &l.RedistributeStaticRoutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3IsolationDomainsListResult.
func (l L3IsolationDomainsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3IsolationDomainsListResult.
func (l *L3IsolationDomainsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3OptionBProperties.
func (l L3OptionBProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportRouteTargets", l.ExportRouteTargets)
	populate(objectMap, "importRouteTargets", l.ImportRouteTargets)
	populate(objectMap, "routeTargets", l.RouteTargets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3OptionBProperties.
func (l *L3OptionBProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportRouteTargets":
			err = unpopulate(val, "ExportRouteTargets", &l.ExportRouteTargets)
			delete(rawMsg, key)
		case "importRouteTargets":
			err = unpopulate(val, "ImportRouteTargets", &l.ImportRouteTargets)
			delete(rawMsg, key)
		case "routeTargets":
			err = unpopulate(val, "RouteTargets", &l.RouteTargets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Layer2Configuration.
func (l Layer2Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interfaces", l.Interfaces)
	populate(objectMap, "mtu", l.Mtu)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Layer2Configuration.
func (l *Layer2Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interfaces":
			err = unpopulate(val, "Interfaces", &l.Interfaces)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &l.Mtu)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedResourceGroupConfiguration.
func (m ManagedResourceGroupConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedResourceGroupConfiguration.
func (m *ManagedResourceGroupConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementNetworkConfigurationPatchableProperties.
func (m ManagementNetworkConfigurationPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "infrastructureVpnConfiguration", m.InfrastructureVPNConfiguration)
	populate(objectMap, "workloadVpnConfiguration", m.WorkloadVPNConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementNetworkConfigurationPatchableProperties.
func (m *ManagementNetworkConfigurationPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infrastructureVpnConfiguration":
			err = unpopulate(val, "InfrastructureVPNConfiguration", &m.InfrastructureVPNConfiguration)
			delete(rawMsg, key)
		case "workloadVpnConfiguration":
			err = unpopulate(val, "WorkloadVPNConfiguration", &m.WorkloadVPNConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementNetworkConfigurationProperties.
func (m ManagementNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "infrastructureVpnConfiguration", m.InfrastructureVPNConfiguration)
	populate(objectMap, "workloadVpnConfiguration", m.WorkloadVPNConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementNetworkConfigurationProperties.
func (m *ManagementNetworkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infrastructureVpnConfiguration":
			err = unpopulate(val, "InfrastructureVPNConfiguration", &m.InfrastructureVPNConfiguration)
			delete(rawMsg, key)
		case "workloadVpnConfiguration":
			err = unpopulate(val, "WorkloadVPNConfiguration", &m.WorkloadVPNConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborAddress.
func (n NeighborAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", n.Address)
	populate(objectMap, "configurationState", n.ConfigurationState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborAddress.
func (n *NeighborAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &n.Address)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroup.
func (n NeighborGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroup.
func (n *NeighborGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroupDestination.
func (n NeighborGroupDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4Addresses", n.IPv4Addresses)
	populate(objectMap, "ipv6Addresses", n.IPv6Addresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroupDestination.
func (n *NeighborGroupDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4Addresses":
			err = unpopulate(val, "IPv4Addresses", &n.IPv4Addresses)
			delete(rawMsg, key)
		case "ipv6Addresses":
			err = unpopulate(val, "IPv6Addresses", &n.IPv6Addresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroupPatch.
func (n NeighborGroupPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroupPatch.
func (n *NeighborGroupPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroupPatchProperties.
func (n NeighborGroupPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "destination", n.Destination)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroupPatchProperties.
func (n *NeighborGroupPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &n.Destination)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroupProperties.
func (n NeighborGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "destination", n.Destination)
	populate(objectMap, "networkTapIds", n.NetworkTapIDs)
	populate(objectMap, "networkTapRuleIds", n.NetworkTapRuleIDs)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroupProperties.
func (n *NeighborGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &n.Destination)
			delete(rawMsg, key)
		case "networkTapIds":
			err = unpopulate(val, "NetworkTapIDs", &n.NetworkTapIDs)
			delete(rawMsg, key)
		case "networkTapRuleIds":
			err = unpopulate(val, "NetworkTapRuleIDs", &n.NetworkTapRuleIDs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NeighborGroupsListResult.
func (n NeighborGroupsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NeighborGroupsListResult.
func (n *NeighborGroupsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDevice.
func (n NetworkDevice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDevice.
func (n *NetworkDevice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDevicePatchParameters.
func (n NetworkDevicePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDevicePatchParameters.
func (n *NetworkDevicePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDevicePatchParametersProperties.
func (n NetworkDevicePatchParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "hostName", n.HostName)
	populate(objectMap, "serialNumber", n.SerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDevicePatchParametersProperties.
func (n *NetworkDevicePatchParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &n.HostName)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &n.SerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDeviceProperties.
func (n NetworkDeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "configurationState", n.ConfigurationState)
	populate(objectMap, "hostName", n.HostName)
	populate(objectMap, "managementIpv4Address", n.ManagementIPv4Address)
	populate(objectMap, "managementIpv6Address", n.ManagementIPv6Address)
	populate(objectMap, "networkDeviceRole", n.NetworkDeviceRole)
	populate(objectMap, "networkDeviceSku", n.NetworkDeviceSKU)
	populate(objectMap, "networkRackId", n.NetworkRackID)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "serialNumber", n.SerialNumber)
	populate(objectMap, "version", n.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDeviceProperties.
func (n *NetworkDeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &n.HostName)
			delete(rawMsg, key)
		case "managementIpv4Address":
			err = unpopulate(val, "ManagementIPv4Address", &n.ManagementIPv4Address)
			delete(rawMsg, key)
		case "managementIpv6Address":
			err = unpopulate(val, "ManagementIPv6Address", &n.ManagementIPv6Address)
			delete(rawMsg, key)
		case "networkDeviceRole":
			err = unpopulate(val, "NetworkDeviceRole", &n.NetworkDeviceRole)
			delete(rawMsg, key)
		case "networkDeviceSku":
			err = unpopulate(val, "NetworkDeviceSKU", &n.NetworkDeviceSKU)
			delete(rawMsg, key)
		case "networkRackId":
			err = unpopulate(val, "NetworkRackID", &n.NetworkRackID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &n.SerialNumber)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &n.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDeviceSKU.
func (n NetworkDeviceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDeviceSKU.
func (n *NetworkDeviceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDeviceSKUProperties.
func (n NetworkDeviceSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interfaces", n.Interfaces)
	populate(objectMap, "manufacturer", n.Manufacturer)
	populate(objectMap, "model", n.Model)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "supportedRoleTypes", n.SupportedRoleTypes)
	populate(objectMap, "supportedVersions", n.SupportedVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDeviceSKUProperties.
func (n *NetworkDeviceSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interfaces":
			err = unpopulate(val, "Interfaces", &n.Interfaces)
			delete(rawMsg, key)
		case "manufacturer":
			err = unpopulate(val, "Manufacturer", &n.Manufacturer)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &n.Model)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "supportedRoleTypes":
			err = unpopulate(val, "SupportedRoleTypes", &n.SupportedRoleTypes)
			delete(rawMsg, key)
		case "supportedVersions":
			err = unpopulate(val, "SupportedVersions", &n.SupportedVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDeviceSKUsListResult.
func (n NetworkDeviceSKUsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDeviceSKUsListResult.
func (n *NetworkDeviceSKUsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkDevicesListResult.
func (n NetworkDevicesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkDevicesListResult.
func (n *NetworkDevicesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabric.
func (n NetworkFabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabric.
func (n *NetworkFabric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricController.
func (n NetworkFabricController) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricController.
func (n *NetworkFabricController) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricControllerPatch.
func (n NetworkFabricControllerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricControllerPatch.
func (n *NetworkFabricControllerPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricControllerPatchableProperties.
func (n NetworkFabricControllerPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "infrastructureExpressRouteConnections", n.InfrastructureExpressRouteConnections)
	populate(objectMap, "workloadExpressRouteConnections", n.WorkloadExpressRouteConnections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricControllerPatchableProperties.
func (n *NetworkFabricControllerPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infrastructureExpressRouteConnections":
			err = unpopulate(val, "InfrastructureExpressRouteConnections", &n.InfrastructureExpressRouteConnections)
			delete(rawMsg, key)
		case "workloadExpressRouteConnections":
			err = unpopulate(val, "WorkloadExpressRouteConnections", &n.WorkloadExpressRouteConnections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricControllerProperties.
func (n NetworkFabricControllerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "ipv4AddressSpace", n.IPv4AddressSpace)
	populate(objectMap, "ipv6AddressSpace", n.IPv6AddressSpace)
	populate(objectMap, "infrastructureExpressRouteConnections", n.InfrastructureExpressRouteConnections)
	populate(objectMap, "infrastructureServices", n.InfrastructureServices)
	populate(objectMap, "isWorkloadManagementNetworkEnabled", n.IsWorkloadManagementNetworkEnabled)
	populate(objectMap, "managedResourceGroupConfiguration", n.ManagedResourceGroupConfiguration)
	populate(objectMap, "networkFabricIds", n.NetworkFabricIDs)
	populate(objectMap, "nfcSku", n.NfcSKU)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "tenantInternetGatewayIds", n.TenantInternetGatewayIDs)
	populate(objectMap, "workloadExpressRouteConnections", n.WorkloadExpressRouteConnections)
	populate(objectMap, "workloadManagementNetwork", n.WorkloadManagementNetwork)
	populate(objectMap, "workloadServices", n.WorkloadServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricControllerProperties.
func (n *NetworkFabricControllerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "ipv4AddressSpace":
			err = unpopulate(val, "IPv4AddressSpace", &n.IPv4AddressSpace)
			delete(rawMsg, key)
		case "ipv6AddressSpace":
			err = unpopulate(val, "IPv6AddressSpace", &n.IPv6AddressSpace)
			delete(rawMsg, key)
		case "infrastructureExpressRouteConnections":
			err = unpopulate(val, "InfrastructureExpressRouteConnections", &n.InfrastructureExpressRouteConnections)
			delete(rawMsg, key)
		case "infrastructureServices":
			err = unpopulate(val, "InfrastructureServices", &n.InfrastructureServices)
			delete(rawMsg, key)
		case "isWorkloadManagementNetworkEnabled":
			err = unpopulate(val, "IsWorkloadManagementNetworkEnabled", &n.IsWorkloadManagementNetworkEnabled)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &n.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "networkFabricIds":
			err = unpopulate(val, "NetworkFabricIDs", &n.NetworkFabricIDs)
			delete(rawMsg, key)
		case "nfcSku":
			err = unpopulate(val, "NfcSKU", &n.NfcSKU)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "tenantInternetGatewayIds":
			err = unpopulate(val, "TenantInternetGatewayIDs", &n.TenantInternetGatewayIDs)
			delete(rawMsg, key)
		case "workloadExpressRouteConnections":
			err = unpopulate(val, "WorkloadExpressRouteConnections", &n.WorkloadExpressRouteConnections)
			delete(rawMsg, key)
		case "workloadManagementNetwork":
			err = unpopulate(val, "WorkloadManagementNetwork", &n.WorkloadManagementNetwork)
			delete(rawMsg, key)
		case "workloadServices":
			err = unpopulate(val, "WorkloadServices", &n.WorkloadServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricControllersListResult.
func (n NetworkFabricControllersListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricControllersListResult.
func (n *NetworkFabricControllersListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricPatch.
func (n NetworkFabricPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricPatch.
func (n *NetworkFabricPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricPatchProperties.
func (n NetworkFabricPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "fabricASN", n.FabricASN)
	populate(objectMap, "ipv4Prefix", n.IPv4Prefix)
	populate(objectMap, "ipv6Prefix", n.IPv6Prefix)
	populate(objectMap, "managementNetworkConfiguration", n.ManagementNetworkConfiguration)
	populate(objectMap, "rackCount", n.RackCount)
	populate(objectMap, "serverCountPerRack", n.ServerCountPerRack)
	populate(objectMap, "terminalServerConfiguration", n.TerminalServerConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricPatchProperties.
func (n *NetworkFabricPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &n.FabricASN)
			delete(rawMsg, key)
		case "ipv4Prefix":
			err = unpopulate(val, "IPv4Prefix", &n.IPv4Prefix)
			delete(rawMsg, key)
		case "ipv6Prefix":
			err = unpopulate(val, "IPv6Prefix", &n.IPv6Prefix)
			delete(rawMsg, key)
		case "managementNetworkConfiguration":
			err = unpopulate(val, "ManagementNetworkConfiguration", &n.ManagementNetworkConfiguration)
			delete(rawMsg, key)
		case "rackCount":
			err = unpopulate(val, "RackCount", &n.RackCount)
			delete(rawMsg, key)
		case "serverCountPerRack":
			err = unpopulate(val, "ServerCountPerRack", &n.ServerCountPerRack)
			delete(rawMsg, key)
		case "terminalServerConfiguration":
			err = unpopulate(val, "TerminalServerConfiguration", &n.TerminalServerConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricPatchablePropertiesTerminalServerConfiguration.
func (n NetworkFabricPatchablePropertiesTerminalServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", n.Password)
	populate(objectMap, "primaryIpv4Prefix", n.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", n.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", n.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", n.SecondaryIPv6Prefix)
	populate(objectMap, "serialNumber", n.SerialNumber)
	populate(objectMap, "username", n.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricPatchablePropertiesTerminalServerConfiguration.
func (n *NetworkFabricPatchablePropertiesTerminalServerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &n.Password)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &n.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &n.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &n.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &n.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &n.SerialNumber)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &n.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricProperties.
func (n NetworkFabricProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "configurationState", n.ConfigurationState)
	populate(objectMap, "fabricASN", n.FabricASN)
	populate(objectMap, "fabricVersion", n.FabricVersion)
	populate(objectMap, "ipv4Prefix", n.IPv4Prefix)
	populate(objectMap, "ipv6Prefix", n.IPv6Prefix)
	populate(objectMap, "l2IsolationDomains", n.L2IsolationDomains)
	populate(objectMap, "l3IsolationDomains", n.L3IsolationDomains)
	populate(objectMap, "managementNetworkConfiguration", n.ManagementNetworkConfiguration)
	populate(objectMap, "networkFabricControllerId", n.NetworkFabricControllerID)
	populate(objectMap, "networkFabricSku", n.NetworkFabricSKU)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "rackCount", n.RackCount)
	populate(objectMap, "racks", n.Racks)
	populate(objectMap, "routerIds", n.RouterIDs)
	populate(objectMap, "serverCountPerRack", n.ServerCountPerRack)
	populate(objectMap, "terminalServerConfiguration", n.TerminalServerConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricProperties.
func (n *NetworkFabricProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &n.FabricASN)
			delete(rawMsg, key)
		case "fabricVersion":
			err = unpopulate(val, "FabricVersion", &n.FabricVersion)
			delete(rawMsg, key)
		case "ipv4Prefix":
			err = unpopulate(val, "IPv4Prefix", &n.IPv4Prefix)
			delete(rawMsg, key)
		case "ipv6Prefix":
			err = unpopulate(val, "IPv6Prefix", &n.IPv6Prefix)
			delete(rawMsg, key)
		case "l2IsolationDomains":
			err = unpopulate(val, "L2IsolationDomains", &n.L2IsolationDomains)
			delete(rawMsg, key)
		case "l3IsolationDomains":
			err = unpopulate(val, "L3IsolationDomains", &n.L3IsolationDomains)
			delete(rawMsg, key)
		case "managementNetworkConfiguration":
			err = unpopulate(val, "ManagementNetworkConfiguration", &n.ManagementNetworkConfiguration)
			delete(rawMsg, key)
		case "networkFabricControllerId":
			err = unpopulate(val, "NetworkFabricControllerID", &n.NetworkFabricControllerID)
			delete(rawMsg, key)
		case "networkFabricSku":
			err = unpopulate(val, "NetworkFabricSKU", &n.NetworkFabricSKU)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "rackCount":
			err = unpopulate(val, "RackCount", &n.RackCount)
			delete(rawMsg, key)
		case "racks":
			err = unpopulate(val, "Racks", &n.Racks)
			delete(rawMsg, key)
		case "routerIds":
			err = unpopulate(val, "RouterIDs", &n.RouterIDs)
			delete(rawMsg, key)
		case "serverCountPerRack":
			err = unpopulate(val, "ServerCountPerRack", &n.ServerCountPerRack)
			delete(rawMsg, key)
		case "terminalServerConfiguration":
			err = unpopulate(val, "TerminalServerConfiguration", &n.TerminalServerConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricSKU.
func (n NetworkFabricSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricSKU.
func (n *NetworkFabricSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricSKUProperties.
func (n NetworkFabricSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", n.Details)
	populate(objectMap, "maxComputeRacks", n.MaxComputeRacks)
	populate(objectMap, "maximumServerCount", n.MaximumServerCount)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "supportedVersions", n.SupportedVersions)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricSKUProperties.
func (n *NetworkFabricSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &n.Details)
			delete(rawMsg, key)
		case "maxComputeRacks":
			err = unpopulate(val, "MaxComputeRacks", &n.MaxComputeRacks)
			delete(rawMsg, key)
		case "maximumServerCount":
			err = unpopulate(val, "MaximumServerCount", &n.MaximumServerCount)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "supportedVersions":
			err = unpopulate(val, "SupportedVersions", &n.SupportedVersions)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricSKUsListResult.
func (n NetworkFabricSKUsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricSKUsListResult.
func (n *NetworkFabricSKUsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFabricsListResult.
func (n NetworkFabricsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFabricsListResult.
func (n *NetworkFabricsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterface.
func (n NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterface.
func (n *NetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfacePatch.
func (n NetworkInterfacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfacePatch.
func (n *NetworkInterfacePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfacePatchProperties.
func (n NetworkInterfacePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfacePatchProperties.
func (n *NetworkInterfacePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceProperties.
func (n NetworkInterfaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "connectedTo", n.ConnectedTo)
	populate(objectMap, "ipv4Address", n.IPv4Address)
	populate(objectMap, "ipv6Address", n.IPv6Address)
	populate(objectMap, "interfaceType", n.InterfaceType)
	populate(objectMap, "physicalIdentifier", n.PhysicalIdentifier)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceProperties.
func (n *NetworkInterfaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "connectedTo":
			err = unpopulate(val, "ConnectedTo", &n.ConnectedTo)
			delete(rawMsg, key)
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &n.IPv4Address)
			delete(rawMsg, key)
		case "ipv6Address":
			err = unpopulate(val, "IPv6Address", &n.IPv6Address)
			delete(rawMsg, key)
		case "interfaceType":
			err = unpopulate(val, "InterfaceType", &n.InterfaceType)
			delete(rawMsg, key)
		case "physicalIdentifier":
			err = unpopulate(val, "PhysicalIdentifier", &n.PhysicalIdentifier)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfacesList.
func (n NetworkInterfacesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfacesList.
func (n *NetworkInterfacesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkPacketBroker.
func (n NetworkPacketBroker) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkPacketBroker.
func (n *NetworkPacketBroker) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkPacketBrokerPatch.
func (n NetworkPacketBrokerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkPacketBrokerPatch.
func (n *NetworkPacketBrokerPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkPacketBrokerProperties.
func (n NetworkPacketBrokerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "neighborGroupIds", n.NeighborGroupIDs)
	populate(objectMap, "networkDeviceIds", n.NetworkDeviceIDs)
	populate(objectMap, "networkFabricId", n.NetworkFabricID)
	populate(objectMap, "networkTapIds", n.NetworkTapIDs)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "sourceInterfaceIds", n.SourceInterfaceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkPacketBrokerProperties.
func (n *NetworkPacketBrokerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "neighborGroupIds":
			err = unpopulate(val, "NeighborGroupIDs", &n.NeighborGroupIDs)
			delete(rawMsg, key)
		case "networkDeviceIds":
			err = unpopulate(val, "NetworkDeviceIDs", &n.NetworkDeviceIDs)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &n.NetworkFabricID)
			delete(rawMsg, key)
		case "networkTapIds":
			err = unpopulate(val, "NetworkTapIDs", &n.NetworkTapIDs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "sourceInterfaceIds":
			err = unpopulate(val, "SourceInterfaceIDs", &n.SourceInterfaceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkPacketBrokersListResult.
func (n NetworkPacketBrokersListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkPacketBrokersListResult.
func (n *NetworkPacketBrokersListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRack.
func (n NetworkRack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkRack.
func (n *NetworkRack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRackProperties.
func (n NetworkRackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "networkDevices", n.NetworkDevices)
	populate(objectMap, "networkFabricId", n.NetworkFabricID)
	populate(objectMap, "networkRackType", n.NetworkRackType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkRackProperties.
func (n *NetworkRackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "networkDevices":
			err = unpopulate(val, "NetworkDevices", &n.NetworkDevices)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &n.NetworkFabricID)
			delete(rawMsg, key)
		case "networkRackType":
			err = unpopulate(val, "NetworkRackType", &n.NetworkRackType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRacksListResult.
func (n NetworkRacksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkRacksListResult.
func (n *NetworkRacksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTap.
func (n NetworkTap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTap.
func (n *NetworkTap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapPatch.
func (n NetworkTapPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapPatch.
func (n *NetworkTapPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapPatchableParameters.
func (n NetworkTapPatchableParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "destinations", n.Destinations)
	populate(objectMap, "pollingType", n.PollingType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapPatchableParameters.
func (n *NetworkTapPatchableParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &n.Destinations)
			delete(rawMsg, key)
		case "pollingType":
			err = unpopulate(val, "PollingType", &n.PollingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapPatchableParametersDestinationsItem.
func (n NetworkTapPatchableParametersDestinationsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationId", n.DestinationID)
	populate(objectMap, "destinationTapRuleId", n.DestinationTapRuleID)
	populate(objectMap, "destinationType", n.DestinationType)
	populate(objectMap, "isolationDomainProperties", n.IsolationDomainProperties)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapPatchableParametersDestinationsItem.
func (n *NetworkTapPatchableParametersDestinationsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationId":
			err = unpopulate(val, "DestinationID", &n.DestinationID)
			delete(rawMsg, key)
		case "destinationTapRuleId":
			err = unpopulate(val, "DestinationTapRuleID", &n.DestinationTapRuleID)
			delete(rawMsg, key)
		case "destinationType":
			err = unpopulate(val, "DestinationType", &n.DestinationType)
			delete(rawMsg, key)
		case "isolationDomainProperties":
			err = unpopulate(val, "IsolationDomainProperties", &n.IsolationDomainProperties)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapProperties.
func (n NetworkTapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "configurationState", n.ConfigurationState)
	populate(objectMap, "destinations", n.Destinations)
	populate(objectMap, "networkPacketBrokerId", n.NetworkPacketBrokerID)
	populate(objectMap, "pollingType", n.PollingType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "sourceTapRuleId", n.SourceTapRuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapProperties.
func (n *NetworkTapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &n.Destinations)
			delete(rawMsg, key)
		case "networkPacketBrokerId":
			err = unpopulate(val, "NetworkPacketBrokerID", &n.NetworkPacketBrokerID)
			delete(rawMsg, key)
		case "pollingType":
			err = unpopulate(val, "PollingType", &n.PollingType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "sourceTapRuleId":
			err = unpopulate(val, "SourceTapRuleID", &n.SourceTapRuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapPropertiesDestinationsItem.
func (n NetworkTapPropertiesDestinationsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationId", n.DestinationID)
	populate(objectMap, "destinationTapRuleId", n.DestinationTapRuleID)
	populate(objectMap, "destinationType", n.DestinationType)
	populate(objectMap, "isolationDomainProperties", n.IsolationDomainProperties)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapPropertiesDestinationsItem.
func (n *NetworkTapPropertiesDestinationsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationId":
			err = unpopulate(val, "DestinationID", &n.DestinationID)
			delete(rawMsg, key)
		case "destinationTapRuleId":
			err = unpopulate(val, "DestinationTapRuleID", &n.DestinationTapRuleID)
			delete(rawMsg, key)
		case "destinationType":
			err = unpopulate(val, "DestinationType", &n.DestinationType)
			delete(rawMsg, key)
		case "isolationDomainProperties":
			err = unpopulate(val, "IsolationDomainProperties", &n.IsolationDomainProperties)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRule.
func (n NetworkTapRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRule.
func (n *NetworkTapRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRuleAction.
func (n NetworkTapRuleAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationId", n.DestinationID)
	populate(objectMap, "isTimestampEnabled", n.IsTimestampEnabled)
	populate(objectMap, "matchConfigurationName", n.MatchConfigurationName)
	populate(objectMap, "truncate", n.Truncate)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRuleAction.
func (n *NetworkTapRuleAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationId":
			err = unpopulate(val, "DestinationID", &n.DestinationID)
			delete(rawMsg, key)
		case "isTimestampEnabled":
			err = unpopulate(val, "IsTimestampEnabled", &n.IsTimestampEnabled)
			delete(rawMsg, key)
		case "matchConfigurationName":
			err = unpopulate(val, "MatchConfigurationName", &n.MatchConfigurationName)
			delete(rawMsg, key)
		case "truncate":
			err = unpopulate(val, "Truncate", &n.Truncate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRuleMatchCondition.
func (n NetworkTapRuleMatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encapsulationType", n.EncapsulationType)
	populate(objectMap, "ipCondition", n.IPCondition)
	populate(objectMap, "portCondition", n.PortCondition)
	populate(objectMap, "protocolTypes", n.ProtocolTypes)
	populate(objectMap, "vlanMatchCondition", n.VlanMatchCondition)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRuleMatchCondition.
func (n *NetworkTapRuleMatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encapsulationType":
			err = unpopulate(val, "EncapsulationType", &n.EncapsulationType)
			delete(rawMsg, key)
		case "ipCondition":
			err = unpopulate(val, "IPCondition", &n.IPCondition)
			delete(rawMsg, key)
		case "portCondition":
			err = unpopulate(val, "PortCondition", &n.PortCondition)
			delete(rawMsg, key)
		case "protocolTypes":
			err = unpopulate(val, "ProtocolTypes", &n.ProtocolTypes)
			delete(rawMsg, key)
		case "vlanMatchCondition":
			err = unpopulate(val, "VlanMatchCondition", &n.VlanMatchCondition)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRuleMatchConfiguration.
func (n NetworkTapRuleMatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", n.Actions)
	populate(objectMap, "ipAddressType", n.IPAddressType)
	populate(objectMap, "matchConditions", n.MatchConditions)
	populate(objectMap, "matchConfigurationName", n.MatchConfigurationName)
	populate(objectMap, "sequenceNumber", n.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRuleMatchConfiguration.
func (n *NetworkTapRuleMatchConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &n.Actions)
			delete(rawMsg, key)
		case "ipAddressType":
			err = unpopulate(val, "IPAddressType", &n.IPAddressType)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &n.MatchConditions)
			delete(rawMsg, key)
		case "matchConfigurationName":
			err = unpopulate(val, "MatchConfigurationName", &n.MatchConfigurationName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &n.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRulePatch.
func (n NetworkTapRulePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRulePatch.
func (n *NetworkTapRulePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRulePatchProperties.
func (n NetworkTapRulePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "configurationType", n.ConfigurationType)
	populate(objectMap, "dynamicMatchConfigurations", n.DynamicMatchConfigurations)
	populate(objectMap, "matchConfigurations", n.MatchConfigurations)
	populate(objectMap, "tapRulesUrl", n.TapRulesURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRulePatchProperties.
func (n *NetworkTapRulePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &n.ConfigurationType)
			delete(rawMsg, key)
		case "dynamicMatchConfigurations":
			err = unpopulate(val, "DynamicMatchConfigurations", &n.DynamicMatchConfigurations)
			delete(rawMsg, key)
		case "matchConfigurations":
			err = unpopulate(val, "MatchConfigurations", &n.MatchConfigurations)
			delete(rawMsg, key)
		case "tapRulesUrl":
			err = unpopulate(val, "TapRulesURL", &n.TapRulesURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRuleProperties.
func (n NetworkTapRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "annotation", n.Annotation)
	populate(objectMap, "configurationState", n.ConfigurationState)
	populate(objectMap, "configurationType", n.ConfigurationType)
	populate(objectMap, "dynamicMatchConfigurations", n.DynamicMatchConfigurations)
	populateDateTimeRFC3339(objectMap, "lastSyncedTime", n.LastSyncedTime)
	populate(objectMap, "matchConfigurations", n.MatchConfigurations)
	populate(objectMap, "networkTapId", n.NetworkTapID)
	populate(objectMap, "pollingIntervalInSeconds", n.PollingIntervalInSeconds)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "tapRulesUrl", n.TapRulesURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRuleProperties.
func (n *NetworkTapRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &n.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &n.ConfigurationType)
			delete(rawMsg, key)
		case "dynamicMatchConfigurations":
			err = unpopulate(val, "DynamicMatchConfigurations", &n.DynamicMatchConfigurations)
			delete(rawMsg, key)
		case "lastSyncedTime":
			err = unpopulateDateTimeRFC3339(val, "LastSyncedTime", &n.LastSyncedTime)
			delete(rawMsg, key)
		case "matchConfigurations":
			err = unpopulate(val, "MatchConfigurations", &n.MatchConfigurations)
			delete(rawMsg, key)
		case "networkTapId":
			err = unpopulate(val, "NetworkTapID", &n.NetworkTapID)
			delete(rawMsg, key)
		case "pollingIntervalInSeconds":
			err = unpopulate(val, "PollingIntervalInSeconds", &n.PollingIntervalInSeconds)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "tapRulesUrl":
			err = unpopulate(val, "TapRulesURL", &n.TapRulesURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapRulesListResult.
func (n NetworkTapRulesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapRulesListResult.
func (n *NetworkTapRulesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTapsListResult.
func (n NetworkTapsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTapsListResult.
func (n *NetworkTapsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnect.
func (n NetworkToNetworkInterconnect) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnect.
func (n *NetworkToNetworkInterconnect) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnectPatch.
func (n NetworkToNetworkInterconnectPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnectPatch.
func (n *NetworkToNetworkInterconnectPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnectPatchableProperties.
func (n NetworkToNetworkInterconnectPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "egressAclId", n.EgressACLID)
	populate(objectMap, "exportRoutePolicy", n.ExportRoutePolicy)
	populate(objectMap, "importRoutePolicy", n.ImportRoutePolicy)
	populate(objectMap, "ingressAclId", n.IngressACLID)
	populate(objectMap, "layer2Configuration", n.Layer2Configuration)
	populate(objectMap, "npbStaticRouteConfiguration", n.NpbStaticRouteConfiguration)
	populate(objectMap, "optionBLayer3Configuration", n.OptionBLayer3Configuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnectPatchableProperties.
func (n *NetworkToNetworkInterconnectPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &n.EgressACLID)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &n.ExportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &n.ImportRoutePolicy)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &n.IngressACLID)
			delete(rawMsg, key)
		case "layer2Configuration":
			err = unpopulate(val, "Layer2Configuration", &n.Layer2Configuration)
			delete(rawMsg, key)
		case "npbStaticRouteConfiguration":
			err = unpopulate(val, "NpbStaticRouteConfiguration", &n.NpbStaticRouteConfiguration)
			delete(rawMsg, key)
		case "optionBLayer3Configuration":
			err = unpopulate(val, "OptionBLayer3Configuration", &n.OptionBLayer3Configuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnectProperties.
func (n NetworkToNetworkInterconnectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", n.AdministrativeState)
	populate(objectMap, "configurationState", n.ConfigurationState)
	populate(objectMap, "egressAclId", n.EgressACLID)
	populate(objectMap, "exportRoutePolicy", n.ExportRoutePolicy)
	populate(objectMap, "importRoutePolicy", n.ImportRoutePolicy)
	populate(objectMap, "ingressAclId", n.IngressACLID)
	populate(objectMap, "isManagementType", n.IsManagementType)
	populate(objectMap, "layer2Configuration", n.Layer2Configuration)
	populate(objectMap, "nniType", n.NniType)
	populate(objectMap, "npbStaticRouteConfiguration", n.NpbStaticRouteConfiguration)
	populate(objectMap, "optionBLayer3Configuration", n.OptionBLayer3Configuration)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "useOptionB", n.UseOptionB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnectProperties.
func (n *NetworkToNetworkInterconnectProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &n.AdministrativeState)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &n.ConfigurationState)
			delete(rawMsg, key)
		case "egressAclId":
			err = unpopulate(val, "EgressACLID", &n.EgressACLID)
			delete(rawMsg, key)
		case "exportRoutePolicy":
			err = unpopulate(val, "ExportRoutePolicy", &n.ExportRoutePolicy)
			delete(rawMsg, key)
		case "importRoutePolicy":
			err = unpopulate(val, "ImportRoutePolicy", &n.ImportRoutePolicy)
			delete(rawMsg, key)
		case "ingressAclId":
			err = unpopulate(val, "IngressACLID", &n.IngressACLID)
			delete(rawMsg, key)
		case "isManagementType":
			err = unpopulate(val, "IsManagementType", &n.IsManagementType)
			delete(rawMsg, key)
		case "layer2Configuration":
			err = unpopulate(val, "Layer2Configuration", &n.Layer2Configuration)
			delete(rawMsg, key)
		case "nniType":
			err = unpopulate(val, "NniType", &n.NniType)
			delete(rawMsg, key)
		case "npbStaticRouteConfiguration":
			err = unpopulate(val, "NpbStaticRouteConfiguration", &n.NpbStaticRouteConfiguration)
			delete(rawMsg, key)
		case "optionBLayer3Configuration":
			err = unpopulate(val, "OptionBLayer3Configuration", &n.OptionBLayer3Configuration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "useOptionB":
			err = unpopulate(val, "UseOptionB", &n.UseOptionB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration.
func (n NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricASN", n.FabricASN)
	populate(objectMap, "peerASN", n.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", n.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", n.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", n.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", n.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", n.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration.
func (n *NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &n.FabricASN)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &n.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &n.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &n.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &n.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &n.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &n.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkToNetworkInterconnectsList.
func (n NetworkToNetworkInterconnectsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkToNetworkInterconnectsList.
func (n *NetworkToNetworkInterconnectsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NpbStaticRouteConfiguration.
func (n NpbStaticRouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", n.BfdConfiguration)
	populate(objectMap, "ipv4Routes", n.IPv4Routes)
	populate(objectMap, "ipv6Routes", n.IPv6Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NpbStaticRouteConfiguration.
func (n *NpbStaticRouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &n.BfdConfiguration)
			delete(rawMsg, key)
		case "ipv4Routes":
			err = unpopulate(val, "IPv4Routes", &n.IPv4Routes)
			delete(rawMsg, key)
		case "ipv6Routes":
			err = unpopulate(val, "IPv6Routes", &n.IPv6Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OptionBLayer3Configuration.
func (o OptionBLayer3Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricASN", o.FabricASN)
	populate(objectMap, "peerASN", o.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", o.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", o.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", o.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", o.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", o.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OptionBLayer3Configuration.
func (o *OptionBLayer3Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricASN":
			err = unpopulate(val, "FabricASN", &o.FabricASN)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &o.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &o.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &o.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &o.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &o.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &o.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OptionBProperties.
func (o OptionBProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportRouteTargets", o.ExportRouteTargets)
	populate(objectMap, "importRouteTargets", o.ImportRouteTargets)
	populate(objectMap, "routeTargets", o.RouteTargets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OptionBProperties.
func (o *OptionBProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportRouteTargets":
			err = unpopulate(val, "ExportRouteTargets", &o.ExportRouteTargets)
			delete(rawMsg, key)
		case "importRouteTargets":
			err = unpopulate(val, "ImportRouteTargets", &o.ImportRouteTargets)
			delete(rawMsg, key)
		case "routeTargets":
			err = unpopulate(val, "RouteTargets", &o.RouteTargets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortCondition.
func (p PortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "layer4Protocol", p.Layer4Protocol)
	populate(objectMap, "portGroupNames", p.PortGroupNames)
	populate(objectMap, "portType", p.PortType)
	populate(objectMap, "ports", p.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortCondition.
func (p *PortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "layer4Protocol":
			err = unpopulate(val, "Layer4Protocol", &p.Layer4Protocol)
			delete(rawMsg, key)
		case "portGroupNames":
			err = unpopulate(val, "PortGroupNames", &p.PortGroupNames)
			delete(rawMsg, key)
		case "portType":
			err = unpopulate(val, "PortType", &p.PortType)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &p.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortGroupProperties.
func (p PortGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "ports", p.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortGroupProperties.
func (p *PortGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &p.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RebootProperties.
func (r RebootProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rebootType", r.RebootType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RebootProperties.
func (r *RebootProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rebootType":
			err = unpopulate(val, "RebootType", &r.RebootType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePoliciesListResult.
func (r RoutePoliciesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePoliciesListResult.
func (r *RoutePoliciesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePolicy.
func (r RoutePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePolicy.
func (r *RoutePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePolicyPatch.
func (r RoutePolicyPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePolicyPatch.
func (r *RoutePolicyPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePolicyPatchableProperties.
func (r RoutePolicyPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statements", r.Statements)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePolicyPatchableProperties.
func (r *RoutePolicyPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statements":
			err = unpopulate(val, "Statements", &r.Statements)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePolicyProperties.
func (r RoutePolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressFamilyType", r.AddressFamilyType)
	populate(objectMap, "administrativeState", r.AdministrativeState)
	populate(objectMap, "annotation", r.Annotation)
	populate(objectMap, "configurationState", r.ConfigurationState)
	populate(objectMap, "networkFabricId", r.NetworkFabricID)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "statements", r.Statements)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePolicyProperties.
func (r *RoutePolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressFamilyType":
			err = unpopulate(val, "AddressFamilyType", &r.AddressFamilyType)
			delete(rawMsg, key)
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &r.AdministrativeState)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &r.Annotation)
			delete(rawMsg, key)
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &r.ConfigurationState)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &r.NetworkFabricID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "statements":
			err = unpopulate(val, "Statements", &r.Statements)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePolicyStatementProperties.
func (r RoutePolicyStatementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "annotation", r.Annotation)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "sequenceNumber", r.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePolicyStatementProperties.
func (r *RoutePolicyStatementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &r.Annotation)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &r.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTargetInformation.
func (r RouteTargetInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportIpv4RouteTargets", r.ExportIPv4RouteTargets)
	populate(objectMap, "exportIpv6RouteTargets", r.ExportIPv6RouteTargets)
	populate(objectMap, "importIpv4RouteTargets", r.ImportIPv4RouteTargets)
	populate(objectMap, "importIpv6RouteTargets", r.ImportIPv6RouteTargets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTargetInformation.
func (r *RouteTargetInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportIpv4RouteTargets":
			err = unpopulate(val, "ExportIPv4RouteTargets", &r.ExportIPv4RouteTargets)
			delete(rawMsg, key)
		case "exportIpv6RouteTargets":
			err = unpopulate(val, "ExportIPv6RouteTargets", &r.ExportIPv6RouteTargets)
			delete(rawMsg, key)
		case "importIpv4RouteTargets":
			err = unpopulate(val, "ImportIPv4RouteTargets", &r.ImportIPv4RouteTargets)
			delete(rawMsg, key)
		case "importIpv6RouteTargets":
			err = unpopulate(val, "ImportIPv6RouteTargets", &r.ImportIPv6RouteTargets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleProperties.
func (r RuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "addressList", r.AddressList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleProperties.
func (r *RuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "addressList":
			err = unpopulate(val, "AddressList", &r.AddressList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatementActionProperties.
func (s StatementActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", s.ActionType)
	populate(objectMap, "ipCommunityProperties", s.IPCommunityProperties)
	populate(objectMap, "ipExtendedCommunityProperties", s.IPExtendedCommunityProperties)
	populate(objectMap, "localPreference", s.LocalPreference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatementActionProperties.
func (s *StatementActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &s.ActionType)
			delete(rawMsg, key)
		case "ipCommunityProperties":
			err = unpopulate(val, "IPCommunityProperties", &s.IPCommunityProperties)
			delete(rawMsg, key)
		case "ipExtendedCommunityProperties":
			err = unpopulate(val, "IPExtendedCommunityProperties", &s.IPExtendedCommunityProperties)
			delete(rawMsg, key)
		case "localPreference":
			err = unpopulate(val, "LocalPreference", &s.LocalPreference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatementConditionProperties.
func (s StatementConditionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipCommunityIds", s.IPCommunityIDs)
	populate(objectMap, "ipExtendedCommunityIds", s.IPExtendedCommunityIDs)
	populate(objectMap, "ipPrefixId", s.IPPrefixID)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatementConditionProperties.
func (s *StatementConditionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipCommunityIds":
			err = unpopulate(val, "IPCommunityIDs", &s.IPCommunityIDs)
			delete(rawMsg, key)
		case "ipExtendedCommunityIds":
			err = unpopulate(val, "IPExtendedCommunityIDs", &s.IPExtendedCommunityIDs)
			delete(rawMsg, key)
		case "ipPrefixId":
			err = unpopulate(val, "IPPrefixID", &s.IPPrefixID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticRouteConfiguration.
func (s StaticRouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", s.BfdConfiguration)
	populate(objectMap, "ipv4Routes", s.IPv4Routes)
	populate(objectMap, "ipv6Routes", s.IPv6Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticRouteConfiguration.
func (s *StaticRouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &s.BfdConfiguration)
			delete(rawMsg, key)
		case "ipv4Routes":
			err = unpopulate(val, "IPv4Routes", &s.IPv4Routes)
			delete(rawMsg, key)
		case "ipv6Routes":
			err = unpopulate(val, "IPv6Routes", &s.IPv6Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticRouteProperties.
func (s StaticRouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextHop", s.NextHop)
	populate(objectMap, "prefix", s.Prefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticRouteProperties.
func (s *StaticRouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextHop":
			err = unpopulate(val, "NextHop", &s.NextHop)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &s.Prefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedConnectorProperties.
func (s SupportedConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectorType", s.ConnectorType)
	populate(objectMap, "maxSpeedInMbps", s.MaxSpeedInMbps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedConnectorProperties.
func (s *SupportedConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectorType":
			err = unpopulate(val, "ConnectorType", &s.ConnectorType)
			delete(rawMsg, key)
		case "maxSpeedInMbps":
			err = unpopulate(val, "MaxSpeedInMbps", &s.MaxSpeedInMbps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedVersionProperties.
func (s SupportedVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "vendorFirmwareVersion", s.VendorFirmwareVersion)
	populate(objectMap, "vendorOsVersion", s.VendorOsVersion)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedVersionProperties.
func (s *SupportedVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "vendorFirmwareVersion":
			err = unpopulate(val, "VendorFirmwareVersion", &s.VendorFirmwareVersion)
			delete(rawMsg, key)
		case "vendorOsVersion":
			err = unpopulate(val, "VendorOsVersion", &s.VendorOsVersion)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsUpdate.
func (t TagsUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsUpdate.
func (t *TagsUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TerminalServerConfiguration.
func (t TerminalServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkDeviceId", t.NetworkDeviceID)
	populate(objectMap, "password", t.Password)
	populate(objectMap, "primaryIpv4Prefix", t.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", t.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", t.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", t.SecondaryIPv6Prefix)
	populate(objectMap, "serialNumber", t.SerialNumber)
	populate(objectMap, "username", t.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TerminalServerConfiguration.
func (t *TerminalServerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkDeviceId":
			err = unpopulate(val, "NetworkDeviceID", &t.NetworkDeviceID)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &t.Password)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &t.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &t.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &t.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &t.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &t.SerialNumber)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &t.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateAdministrativeState.
func (u UpdateAdministrativeState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceIds", u.ResourceIDs)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateAdministrativeState.
func (u *UpdateAdministrativeState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceIds":
			err = unpopulate(val, "ResourceIDs", &u.ResourceIDs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDeviceAdministrativeState.
func (u UpdateDeviceAdministrativeState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceIds", u.ResourceIDs)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateDeviceAdministrativeState.
func (u *UpdateDeviceAdministrativeState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceIds":
			err = unpopulate(val, "ResourceIDs", &u.ResourceIDs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateVersion.
func (u UpdateVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "version", u.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateVersion.
func (u *UpdateVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "version":
			err = unpopulate(val, "Version", &u.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConfigurationPatchableProperties.
func (v VPNConfigurationPatchableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkToNetworkInterconnectId", v.NetworkToNetworkInterconnectID)
	populate(objectMap, "optionAProperties", v.OptionAProperties)
	populate(objectMap, "optionBProperties", v.OptionBProperties)
	populate(objectMap, "peeringOption", v.PeeringOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConfigurationPatchableProperties.
func (v *VPNConfigurationPatchableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkToNetworkInterconnectId":
			err = unpopulate(val, "NetworkToNetworkInterconnectID", &v.NetworkToNetworkInterconnectID)
			delete(rawMsg, key)
		case "optionAProperties":
			err = unpopulate(val, "OptionAProperties", &v.OptionAProperties)
			delete(rawMsg, key)
		case "optionBProperties":
			err = unpopulate(val, "OptionBProperties", &v.OptionBProperties)
			delete(rawMsg, key)
		case "peeringOption":
			err = unpopulate(val, "PeeringOption", &v.PeeringOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConfigurationPatchablePropertiesOptionAProperties.
func (v VPNConfigurationPatchablePropertiesOptionAProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", v.BfdConfiguration)
	populate(objectMap, "mtu", v.Mtu)
	populate(objectMap, "peerASN", v.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", v.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", v.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", v.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", v.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", v.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConfigurationPatchablePropertiesOptionAProperties.
func (v *VPNConfigurationPatchablePropertiesOptionAProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &v.BfdConfiguration)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &v.Mtu)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &v.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &v.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &v.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &v.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &v.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &v.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConfigurationProperties.
func (v VPNConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administrativeState", v.AdministrativeState)
	populate(objectMap, "networkToNetworkInterconnectId", v.NetworkToNetworkInterconnectID)
	populate(objectMap, "optionAProperties", v.OptionAProperties)
	populate(objectMap, "optionBProperties", v.OptionBProperties)
	populate(objectMap, "peeringOption", v.PeeringOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConfigurationProperties.
func (v *VPNConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administrativeState":
			err = unpopulate(val, "AdministrativeState", &v.AdministrativeState)
			delete(rawMsg, key)
		case "networkToNetworkInterconnectId":
			err = unpopulate(val, "NetworkToNetworkInterconnectID", &v.NetworkToNetworkInterconnectID)
			delete(rawMsg, key)
		case "optionAProperties":
			err = unpopulate(val, "OptionAProperties", &v.OptionAProperties)
			delete(rawMsg, key)
		case "optionBProperties":
			err = unpopulate(val, "OptionBProperties", &v.OptionBProperties)
			delete(rawMsg, key)
		case "peeringOption":
			err = unpopulate(val, "PeeringOption", &v.PeeringOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConfigurationPropertiesOptionAProperties.
func (v VPNConfigurationPropertiesOptionAProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdConfiguration", v.BfdConfiguration)
	populate(objectMap, "mtu", v.Mtu)
	populate(objectMap, "peerASN", v.PeerASN)
	populate(objectMap, "primaryIpv4Prefix", v.PrimaryIPv4Prefix)
	populate(objectMap, "primaryIpv6Prefix", v.PrimaryIPv6Prefix)
	populate(objectMap, "secondaryIpv4Prefix", v.SecondaryIPv4Prefix)
	populate(objectMap, "secondaryIpv6Prefix", v.SecondaryIPv6Prefix)
	populate(objectMap, "vlanId", v.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConfigurationPropertiesOptionAProperties.
func (v *VPNConfigurationPropertiesOptionAProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdConfiguration":
			err = unpopulate(val, "BfdConfiguration", &v.BfdConfiguration)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &v.Mtu)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &v.PeerASN)
			delete(rawMsg, key)
		case "primaryIpv4Prefix":
			err = unpopulate(val, "PrimaryIPv4Prefix", &v.PrimaryIPv4Prefix)
			delete(rawMsg, key)
		case "primaryIpv6Prefix":
			err = unpopulate(val, "PrimaryIPv6Prefix", &v.PrimaryIPv6Prefix)
			delete(rawMsg, key)
		case "secondaryIpv4Prefix":
			err = unpopulate(val, "SecondaryIPv4Prefix", &v.SecondaryIPv4Prefix)
			delete(rawMsg, key)
		case "secondaryIpv6Prefix":
			err = unpopulate(val, "SecondaryIPv6Prefix", &v.SecondaryIPv6Prefix)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &v.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateConfigurationProperties.
func (v ValidateConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validateAction", v.ValidateAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateConfigurationProperties.
func (v *ValidateConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validateAction":
			err = unpopulate(val, "ValidateAction", &v.ValidateAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateConfigurationResponse.
func (v ValidateConfigurationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationState", v.ConfigurationState)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "url", v.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateConfigurationResponse.
func (v *ValidateConfigurationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationState":
			err = unpopulate(val, "ConfigurationState", &v.ConfigurationState)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &v.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VlanGroupProperties.
func (v VlanGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "vlans", v.Vlans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VlanGroupProperties.
func (v *VlanGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "vlans":
			err = unpopulate(val, "Vlans", &v.Vlans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VlanMatchCondition.
func (v VlanMatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "innerVlans", v.InnerVlans)
	populate(objectMap, "vlanGroupNames", v.VlanGroupNames)
	populate(objectMap, "vlans", v.Vlans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VlanMatchCondition.
func (v *VlanMatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "innerVlans":
			err = unpopulate(val, "InnerVlans", &v.InnerVlans)
			delete(rawMsg, key)
		case "vlanGroupNames":
			err = unpopulate(val, "VlanGroupNames", &v.VlanGroupNames)
			delete(rawMsg, key)
		case "vlans":
			err = unpopulate(val, "Vlans", &v.Vlans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
