//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/WorkspacesDisableIntelligencePack.json
func ExampleIntelligencePacksClient_Disable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntelligencePacksClient().Disable(ctx, "rg1", "TestLinkWS", "ChangeTracking", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/WorkspacesEnableIntelligencePack.json
func ExampleIntelligencePacksClient_Enable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntelligencePacksClient().Enable(ctx, "rg1", "TestLinkWS", "ChangeTracking", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/WorkspacesListIntelligencePacks.json
func ExampleIntelligencePacksClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntelligencePacksClient().List(ctx, "rg1", "TestLinkWS", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntelligencePackArray = []*armoperationalinsights.IntelligencePack{
	// 	{
	// 		Name: to.Ptr("CapacityPerformance"),
	// 		DisplayName: to.Ptr("Capacity and Performance"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureWebAppsAnalytics"),
	// 		DisplayName: to.Ptr("Azure Web Apps Analytics (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Security"),
	// 		DisplayName: to.Ptr("Security and Audit"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Updates"),
	// 		DisplayName: to.Ptr("Update Management"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AntiMalware"),
	// 		DisplayName: to.Ptr("Antimalware Assessment"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("LogManagement"),
	// 		DisplayName: to.Ptr("Log Management"),
	// 		Enabled: to.Ptr(true),
	// 	},
	// 	{
	// 		Name: to.Ptr("ChangeTracking"),
	// 		DisplayName: to.Ptr("Change Tracking"),
	// 		Enabled: to.Ptr(true),
	// 	},
	// 	{
	// 		Name: to.Ptr("SQLAssessment"),
	// 		DisplayName: to.Ptr("SQL Assessment"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("SCOMAssessment"),
	// 		DisplayName: to.Ptr("System Center Operations Manager Assessment (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ServiceDesk"),
	// 		DisplayName: to.Ptr("IT Service Management Connector(Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ADAssessment"),
	// 		DisplayName: to.Ptr("AD Assessment"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AlertManagement"),
	// 		DisplayName: to.Ptr("Alert Management"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureAutomation"),
	// 		DisplayName: to.Ptr("Azure Automation"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("WireData"),
	// 		DisplayName: to.Ptr("Wire Data"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("SiteRecovery"),
	// 		DisplayName: to.Ptr("Azure Site Recovery"),
	// 		Enabled: to.Ptr(true),
	// 	},
	// 	{
	// 		Name: to.Ptr("Backup"),
	// 		DisplayName: to.Ptr("Backup"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("SurfaceHub"),
	// 		DisplayName: to.Ptr("Surface Hub"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("NetworkMonitoring"),
	// 		DisplayName: to.Ptr("Network Performance Monitor"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Containers"),
	// 		DisplayName: to.Ptr("Container Monitoring Solution"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ServiceMap"),
	// 		DisplayName: to.Ptr("Service Map"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureNetworking"),
	// 		DisplayName: to.Ptr("Azure Networking Analytics (Deprecated)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ADReplication"),
	// 		DisplayName: to.Ptr("AD Replication Status"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Office365"),
	// 		DisplayName: to.Ptr("Office 365 (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("CompatibilityAssessment"),
	// 		DisplayName: to.Ptr("Upgrade Readiness"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("KeyVault"),
	// 		DisplayName: to.Ptr("Key Vault (Deprecated)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ServiceFabric"),
	// 		DisplayName: to.Ptr("Service Fabric"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("DnsAnalytics"),
	// 		DisplayName: to.Ptr("DNS Analytics (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ApplicationInsights"),
	// 		DisplayName: to.Ptr("Application Insights (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("WireData2"),
	// 		DisplayName: to.Ptr("Wire Data 2.0"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("WaaSUpdateInsights"),
	// 		DisplayName: to.Ptr("Update Compliance (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AgentHealthAssessment"),
	// 		DisplayName: to.Ptr("Agent Health "),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureActivity"),
	// 		DisplayName: to.Ptr("Activity Log Analytics"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("HDInsight"),
	// 		DisplayName: to.Ptr("HDInsight HBase Monitoring (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("HDInsightKafka"),
	// 		DisplayName: to.Ptr("HDInsight Kafka Monitoring"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("HDInsightSpark"),
	// 		DisplayName: to.Ptr("HDInsight Spark Monitoring"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("VMware"),
	// 		DisplayName: to.Ptr("VMware (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("SecurityCenterFree"),
	// 		DisplayName: to.Ptr("Security Center Free � for Azure Resources only"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("LogicAppsManagement"),
	// 		DisplayName: to.Ptr("Logic Apps Management"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("LogicAppB2B"),
	// 		DisplayName: to.Ptr("Logic Apps B2B"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureSQLAnalytics"),
	// 		DisplayName: to.Ptr("Azure SQL Analytics (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("KeyVaultAnalytics"),
	// 		DisplayName: to.Ptr("Key Vault Analytics"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureNSGAnalytics"),
	// 		DisplayName: to.Ptr("Azure Network Security Group Analytics"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("AzureAppGatewayAnalytics"),
	// 		DisplayName: to.Ptr("Azure Application Gateway Analytics"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("DeviceHealthProd"),
	// 		DisplayName: to.Ptr("Device Health (Preview)"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("WindowsDefenderATP"),
	// 		DisplayName: to.Ptr("Windows Defender ATP"),
	// 		Enabled: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("ProcessInvestigator"),
	// 		DisplayName: to.Ptr("ProcessInvestigator"),
	// 		Enabled: to.Ptr(false),
	// }}
}
