//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// TroubleshootersClient contains the methods for the Troubleshooters group.
// Don't use this type directly, use NewTroubleshootersClient() instead.
type TroubleshootersClient struct {
	internal *arm.Client
}

// NewTroubleshootersClient creates a new instance of TroubleshootersClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewTroubleshootersClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*TroubleshootersClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &TroubleshootersClient{
		internal: cl,
	}
	return client, nil
}

// Continue - Uses ‘stepId’ and ‘responses’ as the trigger to continue the troubleshooting steps for the respective troubleshooter
// resource name. Continue API is used to provide inputs that are required for the
// specific troubleshooter to progress into the next step in the process. This API is used after the Troubleshooter has been
// created using the Create API.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - troubleshooterName - Troubleshooter resource Name.
//   - options - TroubleshootersClientContinueOptions contains the optional parameters for the TroubleshootersClient.Continue
//     method.
func (client *TroubleshootersClient) Continue(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientContinueOptions) (TroubleshootersClientContinueResponse, error) {
	var err error
	const operationName = "TroubleshootersClient.Continue"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.continueCreateRequest(ctx, scope, troubleshooterName, options)
	if err != nil {
		return TroubleshootersClientContinueResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TroubleshootersClientContinueResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return TroubleshootersClientContinueResponse{}, err
	}
	resp, err := client.continueHandleResponse(httpResp)
	return resp, err
}

// continueCreateRequest creates the Continue request.
func (client *TroubleshootersClient) continueCreateRequest(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientContinueOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/continue"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if troubleshooterName == "" {
		return nil, errors.New("parameter troubleshooterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{troubleshooterName}", url.PathEscape(troubleshooterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ContinueRequestBody != nil {
		if err := runtime.MarshalAsJSON(req, *options.ContinueRequestBody); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// continueHandleResponse handles the Continue response.
func (client *TroubleshootersClient) continueHandleResponse(resp *http.Response) (TroubleshootersClientContinueResponse, error) {
	result := TroubleshootersClientContinueResponse{}
	if val := resp.Header.Get("Location"); val != "" {
		result.Location = &val
	}
	return result, nil
}

// Create - Creates the specific troubleshooter action under a resource or subscription using the ‘solutionId’ and ‘properties.parameters’
// as the trigger. Azure Troubleshooters help with hard to classify issues,
// reducing the gap between customer observed problems and solutions by guiding the user effortlessly through the troubleshooting
// process. Each Troubleshooter flow represents a problem area within Azure
// and has a complex tree-like structure that addresses many root causes. These flows are prepared with the help of Subject
// Matter experts and customer support engineers by carefully considering previous
// support requests raised by customers. Troubleshooters terminate at a well curated solution based off of resource backend
// signals and customer manual selections.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - troubleshooterName - Troubleshooter resource Name.
//   - createTroubleshooterRequestBody - The required request body for this Troubleshooter resource creation.
//   - options - TroubleshootersClientCreateOptions contains the optional parameters for the TroubleshootersClient.Create method.
func (client *TroubleshootersClient) Create(ctx context.Context, scope string, troubleshooterName string, createTroubleshooterRequestBody TroubleshooterResource, options *TroubleshootersClientCreateOptions) (TroubleshootersClientCreateResponse, error) {
	var err error
	const operationName = "TroubleshootersClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, scope, troubleshooterName, createTroubleshooterRequestBody, options)
	if err != nil {
		return TroubleshootersClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TroubleshootersClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return TroubleshootersClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *TroubleshootersClient) createCreateRequest(ctx context.Context, scope string, troubleshooterName string, createTroubleshooterRequestBody TroubleshooterResource, options *TroubleshootersClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if troubleshooterName == "" {
		return nil, errors.New("parameter troubleshooterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{troubleshooterName}", url.PathEscape(troubleshooterName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, createTroubleshooterRequestBody); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *TroubleshootersClient) createHandleResponse(resp *http.Response) (TroubleshootersClientCreateResponse, error) {
	result := TroubleshootersClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TroubleshooterResource); err != nil {
		return TroubleshootersClientCreateResponse{}, err
	}
	return result, nil
}

// End - Ends the troubleshooter action
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - troubleshooterName - Troubleshooter resource Name.
//   - options - TroubleshootersClientEndOptions contains the optional parameters for the TroubleshootersClient.End method.
func (client *TroubleshootersClient) End(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientEndOptions) (TroubleshootersClientEndResponse, error) {
	var err error
	const operationName = "TroubleshootersClient.End"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.endCreateRequest(ctx, scope, troubleshooterName, options)
	if err != nil {
		return TroubleshootersClientEndResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TroubleshootersClientEndResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return TroubleshootersClientEndResponse{}, err
	}
	resp, err := client.endHandleResponse(httpResp)
	return resp, err
}

// endCreateRequest creates the End request.
func (client *TroubleshootersClient) endCreateRequest(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientEndOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/end"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if troubleshooterName == "" {
		return nil, errors.New("parameter troubleshooterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{troubleshooterName}", url.PathEscape(troubleshooterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// endHandleResponse handles the End response.
func (client *TroubleshootersClient) endHandleResponse(resp *http.Response) (TroubleshootersClientEndResponse, error) {
	result := TroubleshootersClientEndResponse{}
	if val := resp.Header.Get("Location"); val != "" {
		result.Location = &val
	}
	return result, nil
}

// Get - Gets troubleshooter instance result which includes the step status/result of the troubleshooter resource name that
// is being executed. Get API is used to retrieve the result of a Troubleshooter
// instance, which includes the status and result of each step in the Troubleshooter workflow. This API requires the Troubleshooter
// resource name that was created using the Create API.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - troubleshooterName - Troubleshooter resource Name.
//   - options - TroubleshootersClientGetOptions contains the optional parameters for the TroubleshootersClient.Get method.
func (client *TroubleshootersClient) Get(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientGetOptions) (TroubleshootersClientGetResponse, error) {
	var err error
	const operationName = "TroubleshootersClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, troubleshooterName, options)
	if err != nil {
		return TroubleshootersClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TroubleshootersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return TroubleshootersClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *TroubleshootersClient) getCreateRequest(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if troubleshooterName == "" {
		return nil, errors.New("parameter troubleshooterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{troubleshooterName}", url.PathEscape(troubleshooterName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *TroubleshootersClient) getHandleResponse(resp *http.Response) (TroubleshootersClientGetResponse, error) {
	result := TroubleshootersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TroubleshooterResource); err != nil {
		return TroubleshootersClientGetResponse{}, err
	}
	return result, nil
}

// Restart - Restarts the troubleshooter API using applicable troubleshooter resource name as the input. It returns new resource
// name which should be used in subsequent request. The old resource name is obsolete
// after this API is invoked.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - troubleshooterName - Troubleshooter resource Name.
//   - options - TroubleshootersClientRestartOptions contains the optional parameters for the TroubleshootersClient.Restart method.
func (client *TroubleshootersClient) Restart(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientRestartOptions) (TroubleshootersClientRestartResponse, error) {
	var err error
	const operationName = "TroubleshootersClient.Restart"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.restartCreateRequest(ctx, scope, troubleshooterName, options)
	if err != nil {
		return TroubleshootersClientRestartResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TroubleshootersClientRestartResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return TroubleshootersClientRestartResponse{}, err
	}
	resp, err := client.restartHandleResponse(httpResp)
	return resp, err
}

// restartCreateRequest creates the Restart request.
func (client *TroubleshootersClient) restartCreateRequest(ctx context.Context, scope string, troubleshooterName string, options *TroubleshootersClientRestartOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/troubleshooters/{troubleshooterName}/restart"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if troubleshooterName == "" {
		return nil, errors.New("parameter troubleshooterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{troubleshooterName}", url.PathEscape(troubleshooterName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// restartHandleResponse handles the Restart response.
func (client *TroubleshootersClient) restartHandleResponse(resp *http.Response) (TroubleshootersClientRestartResponse, error) {
	result := TroubleshootersClientRestartResponse{}
	if val := resp.Header.Get("Location"); val != "" {
		result.Location = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.RestartTroubleshooterResponse); err != nil {
		return TroubleshootersClientRestartResponse{}, err
	}
	return result, nil
}
