//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADAdminProperties.
func (a AADAdminProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorType", a.AdministratorType)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "sid", a.Sid)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADAdminProperties.
func (a *AADAdminProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorType":
			err = unpopulate(val, "AdministratorType", &a.AdministratorType)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "Sid", &a.Sid)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDatabaseConfiguration.
func (a AttachedDatabaseConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDatabaseConfiguration.
func (a *AttachedDatabaseConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDatabaseConfigurationListResult.
func (a AttachedDatabaseConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDatabaseConfigurationListResult.
func (a *AttachedDatabaseConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDatabaseConfigurationProperties.
func (a AttachedDatabaseConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedDatabaseNames", a.AttachedDatabaseNames)
	populate(objectMap, "databaseName", a.DatabaseName)
	populate(objectMap, "defaultPrincipalsModificationKind", a.DefaultPrincipalsModificationKind)
	populate(objectMap, "clusterResourceId", a.KustoPoolResourceID)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "tableLevelSharingProperties", a.TableLevelSharingProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDatabaseConfigurationProperties.
func (a *AttachedDatabaseConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedDatabaseNames":
			err = unpopulate(val, "AttachedDatabaseNames", &a.AttachedDatabaseNames)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &a.DatabaseName)
			delete(rawMsg, key)
		case "defaultPrincipalsModificationKind":
			err = unpopulate(val, "DefaultPrincipalsModificationKind", &a.DefaultPrincipalsModificationKind)
			delete(rawMsg, key)
		case "clusterResourceId":
			err = unpopulate(val, "KustoPoolResourceID", &a.KustoPoolResourceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "tableLevelSharingProperties":
			err = unpopulate(val, "TableLevelSharingProperties", &a.TableLevelSharingProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoPauseProperties.
func (a AutoPauseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayInMinutes", a.DelayInMinutes)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoPauseProperties.
func (a *AutoPauseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayInMinutes":
			err = unpopulate(val, "DelayInMinutes", &a.DelayInMinutes)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScaleProperties.
func (a AutoScaleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "maxNodeCount", a.MaxNodeCount)
	populate(objectMap, "minNodeCount", a.MinNodeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScaleProperties.
func (a *AutoScaleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "maxNodeCount":
			err = unpopulate(val, "MaxNodeCount", &a.MaxNodeCount)
			delete(rawMsg, key)
		case "minNodeCount":
			err = unpopulate(val, "MinNodeCount", &a.MinNodeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableRpOperation.
func (a AvailableRpOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "isDataAction", a.IsDataAction)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "origin", a.Origin)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableRpOperation.
func (a *AvailableRpOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &a.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &a.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableRpOperationDisplayInfo.
func (a AvailableRpOperationDisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableRpOperationDisplayInfo.
func (a *AvailableRpOperationDisplayInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureADOnlyAuthentication.
func (a AzureADOnlyAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureADOnlyAuthentication.
func (a *AzureADOnlyAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureADOnlyAuthenticationListResult.
func (a AzureADOnlyAuthenticationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureADOnlyAuthenticationListResult.
func (a *AzureADOnlyAuthenticationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureADOnlyAuthenticationProperties.
func (a AzureADOnlyAuthenticationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureADOnlyAuthentication", a.AzureADOnlyAuthentication)
	populateDateTimeRFC3339(objectMap, "creationDate", a.CreationDate)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureADOnlyAuthenticationProperties.
func (a *AzureADOnlyAuthenticationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureADOnlyAuthentication":
			err = unpopulate(val, "AzureADOnlyAuthentication", &a.AzureADOnlyAuthentication)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &a.CreationDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCapacity.
func (a AzureCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", a.Default)
	populate(objectMap, "maximum", a.Maximum)
	populate(objectMap, "minimum", a.Minimum)
	populate(objectMap, "scaleType", a.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCapacity.
func (a *AzureCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &a.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &a.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &a.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &a.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureEntityResource.
func (a AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureEntityResource.
func (a *AzureEntityResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceSKU.
func (a AzureResourceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "resourceType", a.ResourceType)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceSKU.
func (a *AzureResourceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &a.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSKU.
func (a AzureSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "size", a.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSKU.
func (a *AzureSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &a.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolPatchInfo.
func (b BigDataPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolPatchInfo.
func (b *BigDataPoolPatchInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolResourceInfo.
func (b BigDataPoolResourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolResourceInfo.
func (b *BigDataPoolResourceInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolResourceInfoListResult.
func (b BigDataPoolResourceInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolResourceInfoListResult.
func (b *BigDataPoolResourceInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolResourceProperties.
func (b BigDataPoolResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoPause", b.AutoPause)
	populate(objectMap, "autoScale", b.AutoScale)
	populate(objectMap, "cacheSize", b.CacheSize)
	populateDateTimeRFC3339(objectMap, "creationDate", b.CreationDate)
	populate(objectMap, "customLibraries", b.CustomLibraries)
	populate(objectMap, "defaultSparkLogFolder", b.DefaultSparkLogFolder)
	populate(objectMap, "dynamicExecutorAllocation", b.DynamicExecutorAllocation)
	populate(objectMap, "isAutotuneEnabled", b.IsAutotuneEnabled)
	populate(objectMap, "isComputeIsolationEnabled", b.IsComputeIsolationEnabled)
	populateDateTimeRFC3339(objectMap, "lastSucceededTimestamp", b.LastSucceededTimestamp)
	populate(objectMap, "libraryRequirements", b.LibraryRequirements)
	populate(objectMap, "nodeCount", b.NodeCount)
	populate(objectMap, "nodeSize", b.NodeSize)
	populate(objectMap, "nodeSizeFamily", b.NodeSizeFamily)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "sessionLevelPackagesEnabled", b.SessionLevelPackagesEnabled)
	populate(objectMap, "sparkConfigProperties", b.SparkConfigProperties)
	populate(objectMap, "sparkEventsFolder", b.SparkEventsFolder)
	populate(objectMap, "sparkVersion", b.SparkVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolResourceProperties.
func (b *BigDataPoolResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoPause":
			err = unpopulate(val, "AutoPause", &b.AutoPause)
			delete(rawMsg, key)
		case "autoScale":
			err = unpopulate(val, "AutoScale", &b.AutoScale)
			delete(rawMsg, key)
		case "cacheSize":
			err = unpopulate(val, "CacheSize", &b.CacheSize)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &b.CreationDate)
			delete(rawMsg, key)
		case "customLibraries":
			err = unpopulate(val, "CustomLibraries", &b.CustomLibraries)
			delete(rawMsg, key)
		case "defaultSparkLogFolder":
			err = unpopulate(val, "DefaultSparkLogFolder", &b.DefaultSparkLogFolder)
			delete(rawMsg, key)
		case "dynamicExecutorAllocation":
			err = unpopulate(val, "DynamicExecutorAllocation", &b.DynamicExecutorAllocation)
			delete(rawMsg, key)
		case "isAutotuneEnabled":
			err = unpopulate(val, "IsAutotuneEnabled", &b.IsAutotuneEnabled)
			delete(rawMsg, key)
		case "isComputeIsolationEnabled":
			err = unpopulate(val, "IsComputeIsolationEnabled", &b.IsComputeIsolationEnabled)
			delete(rawMsg, key)
		case "lastSucceededTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastSucceededTimestamp", &b.LastSucceededTimestamp)
			delete(rawMsg, key)
		case "libraryRequirements":
			err = unpopulate(val, "LibraryRequirements", &b.LibraryRequirements)
			delete(rawMsg, key)
		case "nodeCount":
			err = unpopulate(val, "NodeCount", &b.NodeCount)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &b.NodeSize)
			delete(rawMsg, key)
		case "nodeSizeFamily":
			err = unpopulate(val, "NodeSizeFamily", &b.NodeSizeFamily)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "sessionLevelPackagesEnabled":
			err = unpopulate(val, "SessionLevelPackagesEnabled", &b.SessionLevelPackagesEnabled)
			delete(rawMsg, key)
		case "sparkConfigProperties":
			err = unpopulate(val, "SparkConfigProperties", &b.SparkConfigProperties)
			delete(rawMsg, key)
		case "sparkEventsFolder":
			err = unpopulate(val, "SparkEventsFolder", &b.SparkEventsFolder)
			delete(rawMsg, key)
		case "sparkVersion":
			err = unpopulate(val, "SparkVersion", &b.SparkVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponse.
func (c CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", c.Available)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponse.
func (c *CheckNameAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &c.Available)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameResult.
func (c CheckNameResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameResult.
func (c *CheckNameResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPrincipalAssignment.
func (c ClusterPrincipalAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPrincipalAssignment.
func (c *ClusterPrincipalAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPrincipalAssignmentCheckNameRequest.
func (c ClusterPrincipalAssignmentCheckNameRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	objectMap["type"] = "Microsoft.Synapse/workspaces/kustoPools/principalAssignments"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPrincipalAssignmentCheckNameRequest.
func (c *ClusterPrincipalAssignmentCheckNameRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPrincipalAssignmentListResult.
func (c ClusterPrincipalAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPrincipalAssignmentListResult.
func (c *ClusterPrincipalAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPrincipalProperties.
func (c ClusterPrincipalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadObjectId", c.AADObjectID)
	populate(objectMap, "principalId", c.PrincipalID)
	populate(objectMap, "principalName", c.PrincipalName)
	populate(objectMap, "principalType", c.PrincipalType)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "role", c.Role)
	populate(objectMap, "tenantId", c.TenantID)
	populate(objectMap, "tenantName", c.TenantName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPrincipalProperties.
func (c *ClusterPrincipalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadObjectId":
			err = unpopulate(val, "AADObjectID", &c.AADObjectID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &c.PrincipalName)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &c.PrincipalType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &c.Role)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "tenantName":
			err = unpopulate(val, "TenantName", &c.TenantName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetup.
func (c CmdkeySetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "CmdkeySetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetup.
func (c *CmdkeySetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetupTypeProperties.
func (c CmdkeySetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", c.Password)
	populateAny(objectMap, "targetName", c.TargetName)
	populateAny(objectMap, "userName", c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetupTypeProperties.
func (c *CmdkeySetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "targetName":
			err = unpopulate(val, "TargetName", &c.TargetName)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentSetup.
func (c ComponentSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "ComponentSetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentSetup.
func (c *ComponentSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateSQLPoolRestorePointDefinition.
func (c CreateSQLPoolRestorePointDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "restorePointLabel", c.RestorePointLabel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateSQLPoolRestorePointDefinition.
func (c *CreateSQLPoolRestorePointDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "restorePointLabel":
			err = unpopulate(val, "RestorePointLabel", &c.RestorePointLabel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CspWorkspaceAdminProperties.
func (c CspWorkspaceAdminProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialWorkspaceAdminObjectId", c.InitialWorkspaceAdminObjectID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CspWorkspaceAdminProperties.
func (c *CspWorkspaceAdminProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialWorkspaceAdminObjectId":
			err = unpopulate(val, "InitialWorkspaceAdminObjectID", &c.InitialWorkspaceAdminObjectID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomSetupBase.
func (c CustomSetupBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomSetupBase.
func (c *CustomSetupBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerManagedKeyDetails.
func (c CustomerManagedKeyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kekIdentity", c.KekIdentity)
	populate(objectMap, "key", c.Key)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerManagedKeyDetails.
func (c *CustomerManagedKeyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kekIdentity":
			err = unpopulate(val, "KekIdentity", &c.KekIdentity)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &c.Key)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnection.
func (d DataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = d.Kind
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnection.
func (d *DataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionCheckNameRequest.
func (d DataConnectionCheckNameRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	objectMap["type"] = "Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionCheckNameRequest.
func (d *DataConnectionCheckNameRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionListResult.
func (d DataConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionListResult.
func (d *DataConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			d.Value, err = unmarshalDataConnectionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionValidation.
func (d DataConnectionValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataConnectionName", d.DataConnectionName)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionValidation.
func (d *DataConnectionValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataConnectionName":
			err = unpopulate(val, "DataConnectionName", &d.DataConnectionName)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDataConnectionClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionValidationListResult.
func (d DataConnectionValidationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionValidationListResult.
func (d *DataConnectionValidationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionValidationResult.
func (d DataConnectionValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", d.ErrorMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionValidationResult.
func (d *DataConnectionValidationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &d.ErrorMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeStorageAccountDetails.
func (d DataLakeStorageAccountDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountUrl", d.AccountURL)
	populate(objectMap, "createManagedPrivateEndpoint", d.CreateManagedPrivateEndpoint)
	populate(objectMap, "filesystem", d.Filesystem)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeStorageAccountDetails.
func (d *DataLakeStorageAccountDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountUrl":
			err = unpopulate(val, "AccountURL", &d.AccountURL)
			delete(rawMsg, key)
		case "createManagedPrivateEndpoint":
			err = unpopulate(val, "CreateManagedPrivateEndpoint", &d.CreateManagedPrivateEndpoint)
			delete(rawMsg, key)
		case "filesystem":
			err = unpopulate(val, "Filesystem", &d.Filesystem)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingPolicy.
func (d DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingPolicy.
func (d *DataMaskingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &d.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingPolicyProperties.
func (d DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationPrincipals", d.ApplicationPrincipals)
	populate(objectMap, "dataMaskingState", d.DataMaskingState)
	populate(objectMap, "exemptPrincipals", d.ExemptPrincipals)
	populate(objectMap, "maskingLevel", d.MaskingLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingPolicyProperties.
func (d *DataMaskingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationPrincipals":
			err = unpopulate(val, "ApplicationPrincipals", &d.ApplicationPrincipals)
			delete(rawMsg, key)
		case "dataMaskingState":
			err = unpopulate(val, "DataMaskingState", &d.DataMaskingState)
			delete(rawMsg, key)
		case "exemptPrincipals":
			err = unpopulate(val, "ExemptPrincipals", &d.ExemptPrincipals)
			delete(rawMsg, key)
		case "maskingLevel":
			err = unpopulate(val, "MaskingLevel", &d.MaskingLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingRule.
func (d DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingRule.
func (d *DataMaskingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingRuleListResult.
func (d DataMaskingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingRuleListResult.
func (d *DataMaskingRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingRuleProperties.
func (d DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aliasName", d.AliasName)
	populate(objectMap, "columnName", d.ColumnName)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "maskingFunction", d.MaskingFunction)
	populate(objectMap, "numberFrom", d.NumberFrom)
	populate(objectMap, "numberTo", d.NumberTo)
	populate(objectMap, "prefixSize", d.PrefixSize)
	populate(objectMap, "replacementString", d.ReplacementString)
	populate(objectMap, "ruleState", d.RuleState)
	populate(objectMap, "schemaName", d.SchemaName)
	populate(objectMap, "suffixSize", d.SuffixSize)
	populate(objectMap, "tableName", d.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingRuleProperties.
func (d *DataMaskingRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aliasName":
			err = unpopulate(val, "AliasName", &d.AliasName)
			delete(rawMsg, key)
		case "columnName":
			err = unpopulate(val, "ColumnName", &d.ColumnName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "maskingFunction":
			err = unpopulate(val, "MaskingFunction", &d.MaskingFunction)
			delete(rawMsg, key)
		case "numberFrom":
			err = unpopulate(val, "NumberFrom", &d.NumberFrom)
			delete(rawMsg, key)
		case "numberTo":
			err = unpopulate(val, "NumberTo", &d.NumberTo)
			delete(rawMsg, key)
		case "prefixSize":
			err = unpopulate(val, "PrefixSize", &d.PrefixSize)
			delete(rawMsg, key)
		case "replacementString":
			err = unpopulate(val, "ReplacementString", &d.ReplacementString)
			delete(rawMsg, key)
		case "ruleState":
			err = unpopulate(val, "RuleState", &d.RuleState)
			delete(rawMsg, key)
		case "schemaName":
			err = unpopulate(val, "SchemaName", &d.SchemaName)
			delete(rawMsg, key)
		case "suffixSize":
			err = unpopulate(val, "SuffixSize", &d.SuffixSize)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &d.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataWarehouseUserActivities.
func (d DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataWarehouseUserActivities.
func (d *DataWarehouseUserActivities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataWarehouseUserActivitiesProperties.
func (d DataWarehouseUserActivitiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeQueriesCount", d.ActiveQueriesCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataWarehouseUserActivitiesProperties.
func (d *DataWarehouseUserActivitiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeQueriesCount":
			err = unpopulate(val, "ActiveQueriesCount", &d.ActiveQueriesCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = d.Kind
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Database.
func (d *Database) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseCheckNameRequest.
func (d DatabaseCheckNameRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseCheckNameRequest.
func (d *DatabaseCheckNameRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseListResult.
func (d DatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseListResult.
func (d *DatabaseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			d.Value, err = unmarshalDatabaseClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabasePrincipalAssignment.
func (d DatabasePrincipalAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabasePrincipalAssignment.
func (d *DatabasePrincipalAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabasePrincipalAssignmentCheckNameRequest.
func (d DatabasePrincipalAssignmentCheckNameRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	objectMap["type"] = "Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabasePrincipalAssignmentCheckNameRequest.
func (d *DatabasePrincipalAssignmentCheckNameRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabasePrincipalAssignmentListResult.
func (d DatabasePrincipalAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabasePrincipalAssignmentListResult.
func (d *DatabasePrincipalAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabasePrincipalProperties.
func (d DatabasePrincipalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadObjectId", d.AADObjectID)
	populate(objectMap, "principalId", d.PrincipalID)
	populate(objectMap, "principalName", d.PrincipalName)
	populate(objectMap, "principalType", d.PrincipalType)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "role", d.Role)
	populate(objectMap, "tenantId", d.TenantID)
	populate(objectMap, "tenantName", d.TenantName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabasePrincipalProperties.
func (d *DatabasePrincipalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadObjectId":
			err = unpopulate(val, "AADObjectID", &d.AADObjectID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &d.PrincipalID)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &d.PrincipalName)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &d.PrincipalType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &d.Role)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &d.TenantID)
			delete(rawMsg, key)
		case "tenantName":
			err = unpopulate(val, "TenantName", &d.TenantName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseStatistics.
func (d DatabaseStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "size", d.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseStatistics.
func (d *DatabaseStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "size":
			err = unpopulate(val, "Size", &d.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedSQLminimalTLSSettings.
func (d DedicatedSQLminimalTLSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedSQLminimalTLSSettings.
func (d *DedicatedSQLminimalTLSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedSQLminimalTLSSettingsListResult.
func (d DedicatedSQLminimalTLSSettingsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedSQLminimalTLSSettingsListResult.
func (d *DedicatedSQLminimalTLSSettingsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedSQLminimalTLSSettingsPatchInfo.
func (d DedicatedSQLminimalTLSSettingsPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "minimalTlsVersion", d.MinimalTLSVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedSQLminimalTLSSettingsPatchInfo.
func (d *DedicatedSQLminimalTLSSettingsPatchInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &d.MinimalTLSVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedSQLminimalTLSSettingsProperties.
func (d DedicatedSQLminimalTLSSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "minimalTlsVersion", d.MinimalTLSVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedSQLminimalTLSSettingsProperties.
func (d *DedicatedSQLminimalTLSSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &d.MinimalTLSVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicExecutorAllocation.
func (d DynamicExecutorAllocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "maxExecutors", d.MaxExecutors)
	populate(objectMap, "minExecutors", d.MinExecutors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicExecutorAllocation.
func (d *DynamicExecutorAllocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "maxExecutors":
			err = unpopulate(val, "MaxExecutors", &d.MaxExecutors)
			delete(rawMsg, key)
		case "minExecutors":
			err = unpopulate(val, "MinExecutors", &d.MinExecutors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionDetails.
func (e EncryptionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cmk", e.Cmk)
	populate(objectMap, "doubleEncryptionEnabled", e.DoubleEncryptionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionDetails.
func (e *EncryptionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cmk":
			err = unpopulate(val, "Cmk", &e.Cmk)
			delete(rawMsg, key)
		case "doubleEncryptionEnabled":
			err = unpopulate(val, "DoubleEncryptionEnabled", &e.DoubleEncryptionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionProtector.
func (e EncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "kind", e.Kind)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionProtector.
func (e *EncryptionProtector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionProtectorListResult.
func (e EncryptionProtectorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionProtectorListResult.
func (e *EncryptionProtectorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionProtectorProperties.
func (e EncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serverKeyName", e.ServerKeyName)
	populate(objectMap, "serverKeyType", e.ServerKeyType)
	populate(objectMap, "subregion", e.Subregion)
	populate(objectMap, "thumbprint", e.Thumbprint)
	populate(objectMap, "uri", e.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionProtectorProperties.
func (e *EncryptionProtectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serverKeyName":
			err = unpopulate(val, "ServerKeyName", &e.ServerKeyName)
			delete(rawMsg, key)
		case "serverKeyType":
			err = unpopulate(val, "ServerKeyType", &e.ServerKeyType)
			delete(rawMsg, key)
		case "subregion":
			err = unpopulate(val, "Subregion", &e.Subregion)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &e.Thumbprint)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &e.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EntityReference.
func (e EntityReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "referenceName", e.ReferenceName)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EntityReference.
func (e *EntityReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &e.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariableSetup.
func (e EnvironmentVariableSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "EnvironmentVariableSetup"
	populate(objectMap, "typeProperties", e.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariableSetupTypeProperties.
func (e EnvironmentVariableSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "variableName", e.VariableName)
	populate(objectMap, "variableValue", e.VariableValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariableSetupTypeProperties.
func (e *EnvironmentVariableSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "variableName":
			err = unpopulate(val, "VariableName", &e.VariableName)
			delete(rawMsg, key)
		case "variableValue":
			err = unpopulate(val, "VariableValue", &e.VariableValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseAutoGenerated.
func (e ErrorResponseAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseAutoGenerated.
func (e *ErrorResponseAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridConnectionProperties.
func (e EventGridConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobStorageEventType", e.BlobStorageEventType)
	populate(objectMap, "consumerGroup", e.ConsumerGroup)
	populate(objectMap, "dataFormat", e.DataFormat)
	populate(objectMap, "eventHubResourceId", e.EventHubResourceID)
	populate(objectMap, "ignoreFirstRecord", e.IgnoreFirstRecord)
	populate(objectMap, "mappingRuleName", e.MappingRuleName)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "storageAccountResourceId", e.StorageAccountResourceID)
	populate(objectMap, "tableName", e.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridConnectionProperties.
func (e *EventGridConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobStorageEventType":
			err = unpopulate(val, "BlobStorageEventType", &e.BlobStorageEventType)
			delete(rawMsg, key)
		case "consumerGroup":
			err = unpopulate(val, "ConsumerGroup", &e.ConsumerGroup)
			delete(rawMsg, key)
		case "dataFormat":
			err = unpopulate(val, "DataFormat", &e.DataFormat)
			delete(rawMsg, key)
		case "eventHubResourceId":
			err = unpopulate(val, "EventHubResourceID", &e.EventHubResourceID)
			delete(rawMsg, key)
		case "ignoreFirstRecord":
			err = unpopulate(val, "IgnoreFirstRecord", &e.IgnoreFirstRecord)
			delete(rawMsg, key)
		case "mappingRuleName":
			err = unpopulate(val, "MappingRuleName", &e.MappingRuleName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "storageAccountResourceId":
			err = unpopulate(val, "StorageAccountResourceID", &e.StorageAccountResourceID)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &e.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridDataConnection.
func (e EventGridDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = DataConnectionKindEventGrid
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridDataConnection.
func (e *EventGridDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubConnectionProperties.
func (e EventHubConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", e.Compression)
	populate(objectMap, "consumerGroup", e.ConsumerGroup)
	populate(objectMap, "dataFormat", e.DataFormat)
	populate(objectMap, "eventHubResourceId", e.EventHubResourceID)
	populate(objectMap, "eventSystemProperties", e.EventSystemProperties)
	populate(objectMap, "managedIdentityResourceId", e.ManagedIdentityResourceID)
	populate(objectMap, "mappingRuleName", e.MappingRuleName)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "tableName", e.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubConnectionProperties.
func (e *EventHubConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &e.Compression)
			delete(rawMsg, key)
		case "consumerGroup":
			err = unpopulate(val, "ConsumerGroup", &e.ConsumerGroup)
			delete(rawMsg, key)
		case "dataFormat":
			err = unpopulate(val, "DataFormat", &e.DataFormat)
			delete(rawMsg, key)
		case "eventHubResourceId":
			err = unpopulate(val, "EventHubResourceID", &e.EventHubResourceID)
			delete(rawMsg, key)
		case "eventSystemProperties":
			err = unpopulate(val, "EventSystemProperties", &e.EventSystemProperties)
			delete(rawMsg, key)
		case "managedIdentityResourceId":
			err = unpopulate(val, "ManagedIdentityResourceID", &e.ManagedIdentityResourceID)
			delete(rawMsg, key)
		case "mappingRuleName":
			err = unpopulate(val, "MappingRuleName", &e.MappingRuleName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &e.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubDataConnection.
func (e EventHubDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = DataConnectionKindEventHub
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubDataConnection.
func (e *EventHubDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedSQLPoolBlobAuditingPolicy.
func (e ExtendedSQLPoolBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedSQLPoolBlobAuditingPolicy.
func (e *ExtendedSQLPoolBlobAuditingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedSQLPoolBlobAuditingPolicyListResult.
func (e ExtendedSQLPoolBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedSQLPoolBlobAuditingPolicyListResult.
func (e *ExtendedSQLPoolBlobAuditingPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedSQLPoolBlobAuditingPolicyProperties.
func (e ExtendedSQLPoolBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedSQLPoolBlobAuditingPolicyProperties.
func (e *ExtendedSQLPoolBlobAuditingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditActionsAndGroups":
			err = unpopulate(val, "AuditActionsAndGroups", &e.AuditActionsAndGroups)
			delete(rawMsg, key)
		case "isAzureMonitorTargetEnabled":
			err = unpopulate(val, "IsAzureMonitorTargetEnabled", &e.IsAzureMonitorTargetEnabled)
			delete(rawMsg, key)
		case "isStorageSecondaryKeyInUse":
			err = unpopulate(val, "IsStorageSecondaryKeyInUse", &e.IsStorageSecondaryKeyInUse)
			delete(rawMsg, key)
		case "predicateExpression":
			err = unpopulate(val, "PredicateExpression", &e.PredicateExpression)
			delete(rawMsg, key)
		case "queueDelayMs":
			err = unpopulate(val, "QueueDelayMs", &e.QueueDelayMs)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &e.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &e.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageAccountSubscriptionId":
			err = unpopulate(val, "StorageAccountSubscriptionID", &e.StorageAccountSubscriptionID)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &e.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedServerBlobAuditingPolicy.
func (e ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedServerBlobAuditingPolicy.
func (e *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedServerBlobAuditingPolicyListResult.
func (e ExtendedServerBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedServerBlobAuditingPolicyListResult.
func (e *ExtendedServerBlobAuditingPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedServerBlobAuditingPolicyProperties.
func (e ExtendedServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", e.IsDevopsAuditEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedServerBlobAuditingPolicyProperties.
func (e *ExtendedServerBlobAuditingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditActionsAndGroups":
			err = unpopulate(val, "AuditActionsAndGroups", &e.AuditActionsAndGroups)
			delete(rawMsg, key)
		case "isAzureMonitorTargetEnabled":
			err = unpopulate(val, "IsAzureMonitorTargetEnabled", &e.IsAzureMonitorTargetEnabled)
			delete(rawMsg, key)
		case "isDevopsAuditEnabled":
			err = unpopulate(val, "IsDevopsAuditEnabled", &e.IsDevopsAuditEnabled)
			delete(rawMsg, key)
		case "isStorageSecondaryKeyInUse":
			err = unpopulate(val, "IsStorageSecondaryKeyInUse", &e.IsStorageSecondaryKeyInUse)
			delete(rawMsg, key)
		case "predicateExpression":
			err = unpopulate(val, "PredicateExpression", &e.PredicateExpression)
			delete(rawMsg, key)
		case "queueDelayMs":
			err = unpopulate(val, "QueueDelayMs", &e.QueueDelayMs)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &e.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &e.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageAccountSubscriptionId":
			err = unpopulate(val, "StorageAccountSubscriptionID", &e.StorageAccountSubscriptionID)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &e.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FollowerDatabaseDefinition.
func (f FollowerDatabaseDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedDatabaseConfigurationName", f.AttachedDatabaseConfigurationName)
	populate(objectMap, "databaseName", f.DatabaseName)
	populate(objectMap, "clusterResourceId", f.KustoPoolResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FollowerDatabaseDefinition.
func (f *FollowerDatabaseDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedDatabaseConfigurationName":
			err = unpopulate(val, "AttachedDatabaseConfigurationName", &f.AttachedDatabaseConfigurationName)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &f.DatabaseName)
			delete(rawMsg, key)
		case "clusterResourceId":
			err = unpopulate(val, "KustoPoolResourceID", &f.KustoPoolResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FollowerDatabaseListResult.
func (f FollowerDatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FollowerDatabaseListResult.
func (f *FollowerDatabaseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoBackupPolicy.
func (g GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "kind", g.Kind)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoBackupPolicy.
func (g *GeoBackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoBackupPolicyListResult.
func (g GeoBackupPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoBackupPolicyListResult.
func (g *GeoBackupPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoBackupPolicyProperties.
func (g GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", g.State)
	populate(objectMap, "storageType", g.StorageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoBackupPolicyProperties.
func (g *GeoBackupPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &g.StorageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetSsisObjectMetadataRequest.
func (g GetSsisObjectMetadataRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadataPath", g.MetadataPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetSsisObjectMetadataRequest.
func (g *GetSsisObjectMetadataRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadataPath":
			err = unpopulate(val, "MetadataPath", &g.MetadataPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPFirewallRuleInfo.
func (i IPFirewallRuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPFirewallRuleInfo.
func (i *IPFirewallRuleInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPFirewallRuleInfoListResult.
func (i IPFirewallRuleInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPFirewallRuleInfoListResult.
func (i *IPFirewallRuleInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPFirewallRuleProperties.
func (i IPFirewallRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endIpAddress", i.EndIPAddress)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "startIpAddress", i.StartIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPFirewallRuleProperties.
func (i *IPFirewallRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIpAddress":
			err = unpopulate(val, "EndIPAddress", &i.EndIPAddress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "startIpAddress":
			err = unpopulate(val, "StartIPAddress", &i.StartIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntime.
func (i IntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", i.Description)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntime.
func (i *IntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeAuthKeys.
func (i IntegrationRuntimeAuthKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authKey1", i.AuthKey1)
	populate(objectMap, "authKey2", i.AuthKey2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeAuthKeys.
func (i *IntegrationRuntimeAuthKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authKey1":
			err = unpopulate(val, "AuthKey1", &i.AuthKey1)
			delete(rawMsg, key)
		case "authKey2":
			err = unpopulate(val, "AuthKey2", &i.AuthKey2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeComputeProperties.
func (i IntegrationRuntimeComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFlowProperties", i.DataFlowProperties)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "maxParallelExecutionsPerNode", i.MaxParallelExecutionsPerNode)
	populate(objectMap, "nodeSize", i.NodeSize)
	populate(objectMap, "numberOfNodes", i.NumberOfNodes)
	populate(objectMap, "vNetProperties", i.VNetProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeComputeProperties.
func (i *IntegrationRuntimeComputeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFlowProperties":
			err = unpopulate(val, "DataFlowProperties", &i.DataFlowProperties)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "maxParallelExecutionsPerNode":
			err = unpopulate(val, "MaxParallelExecutionsPerNode", &i.MaxParallelExecutionsPerNode)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &i.NodeSize)
			delete(rawMsg, key)
		case "numberOfNodes":
			err = unpopulate(val, "NumberOfNodes", &i.NumberOfNodes)
			delete(rawMsg, key)
		case "vNetProperties":
			err = unpopulate(val, "VNetProperties", &i.VNetProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeConnectionInfo.
func (i IntegrationRuntimeConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostServiceUri", i.HostServiceURI)
	populate(objectMap, "identityCertThumbprint", i.IdentityCertThumbprint)
	populate(objectMap, "isIdentityCertExprired", i.IsIdentityCertExprired)
	populate(objectMap, "publicKey", i.PublicKey)
	populate(objectMap, "serviceToken", i.ServiceToken)
	populate(objectMap, "version", i.Version)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeConnectionInfo.
func (i *IntegrationRuntimeConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostServiceUri":
			err = unpopulate(val, "HostServiceURI", &i.HostServiceURI)
			delete(rawMsg, key)
		case "identityCertThumbprint":
			err = unpopulate(val, "IdentityCertThumbprint", &i.IdentityCertThumbprint)
			delete(rawMsg, key)
		case "isIdentityCertExprired":
			err = unpopulate(val, "IsIdentityCertExprired", &i.IsIdentityCertExprired)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &i.PublicKey)
			delete(rawMsg, key)
		case "serviceToken":
			err = unpopulate(val, "ServiceToken", &i.ServiceToken)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeCustomSetupScriptProperties.
func (i IntegrationRuntimeCustomSetupScriptProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerUri", i.BlobContainerURI)
	populate(objectMap, "sasToken", i.SasToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeCustomSetupScriptProperties.
func (i *IntegrationRuntimeCustomSetupScriptProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerUri":
			err = unpopulate(val, "BlobContainerURI", &i.BlobContainerURI)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &i.SasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i IntegrationRuntimeDataFlowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cleanup", i.Cleanup)
	populate(objectMap, "computeType", i.ComputeType)
	populate(objectMap, "coreCount", i.CoreCount)
	populate(objectMap, "timeToLive", i.TimeToLive)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i *IntegrationRuntimeDataFlowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cleanup":
			err = unpopulate(val, "Cleanup", &i.Cleanup)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &i.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &i.CoreCount)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &i.TimeToLive)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataProxyProperties.
func (i IntegrationRuntimeDataProxyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectVia", i.ConnectVia)
	populate(objectMap, "path", i.Path)
	populate(objectMap, "stagingLinkedService", i.StagingLinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataProxyProperties.
func (i *IntegrationRuntimeDataProxyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &i.ConnectVia)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &i.Path)
			delete(rawMsg, key)
		case "stagingLinkedService":
			err = unpopulate(val, "StagingLinkedService", &i.StagingLinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeEnableinteractivequery.
func (i IntegrationRuntimeEnableinteractivequery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", i.Error)
	populate(objectMap, "name", i.Name)
	populateAny(objectMap, "properties", i.Properties)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeEnableinteractivequery.
func (i *IntegrationRuntimeEnableinteractivequery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &i.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeListResponse.
func (i IntegrationRuntimeListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeListResponse.
func (i *IntegrationRuntimeListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeMonitoringData.
func (i IntegrationRuntimeMonitoringData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "nodes", i.Nodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeMonitoringData.
func (i *IntegrationRuntimeMonitoringData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &i.Nodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeNodeIPAddress.
func (i IntegrationRuntimeNodeIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddress", i.IPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeNodeIPAddress.
func (i *IntegrationRuntimeNodeIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeNodeMonitoringData.
func (i IntegrationRuntimeNodeMonitoringData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableMemoryInMB", i.AvailableMemoryInMB)
	populate(objectMap, "cpuUtilization", i.CPUUtilization)
	populate(objectMap, "concurrentJobsLimit", i.ConcurrentJobsLimit)
	populate(objectMap, "concurrentJobsRunning", i.ConcurrentJobsRunning)
	populate(objectMap, "maxConcurrentJobs", i.MaxConcurrentJobs)
	populate(objectMap, "nodeName", i.NodeName)
	populate(objectMap, "receivedBytes", i.ReceivedBytes)
	populate(objectMap, "sentBytes", i.SentBytes)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeNodeMonitoringData.
func (i *IntegrationRuntimeNodeMonitoringData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableMemoryInMB":
			err = unpopulate(val, "AvailableMemoryInMB", &i.AvailableMemoryInMB)
			delete(rawMsg, key)
		case "cpuUtilization":
			err = unpopulate(val, "CPUUtilization", &i.CPUUtilization)
			delete(rawMsg, key)
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &i.ConcurrentJobsLimit)
			delete(rawMsg, key)
		case "concurrentJobsRunning":
			err = unpopulate(val, "ConcurrentJobsRunning", &i.ConcurrentJobsRunning)
			delete(rawMsg, key)
		case "maxConcurrentJobs":
			err = unpopulate(val, "MaxConcurrentJobs", &i.MaxConcurrentJobs)
			delete(rawMsg, key)
		case "nodeName":
			err = unpopulate(val, "NodeName", &i.NodeName)
			delete(rawMsg, key)
		case "receivedBytes":
			err = unpopulate(val, "ReceivedBytes", &i.ReceivedBytes)
			delete(rawMsg, key)
		case "sentBytes":
			err = unpopulate(val, "SentBytes", &i.SentBytes)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOperationStatus.
func (i IntegrationRuntimeOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", i.Error)
	populate(objectMap, "name", i.Name)
	populateAny(objectMap, "properties", i.Properties)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOperationStatus.
func (i *IntegrationRuntimeOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &i.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint.
func (i IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "endpoints", i.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint.
func (i *IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &i.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpoint.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", i.DomainName)
	populate(objectMap, "endpointDetails", i.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpoint.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &i.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &i.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", i.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &i.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeRegenerateKeyParameters.
func (i IntegrationRuntimeRegenerateKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", i.KeyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeRegenerateKeyParameters.
func (i *IntegrationRuntimeRegenerateKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeResource.
func (i IntegrationRuntimeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeResource.
func (i *IntegrationRuntimeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i IntegrationRuntimeSsisCatalogInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogAdminPassword", i.CatalogAdminPassword)
	populate(objectMap, "catalogAdminUserName", i.CatalogAdminUserName)
	populate(objectMap, "catalogPricingTier", i.CatalogPricingTier)
	populate(objectMap, "catalogServerEndpoint", i.CatalogServerEndpoint)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i *IntegrationRuntimeSsisCatalogInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogAdminPassword":
			err = unpopulate(val, "CatalogAdminPassword", &i.CatalogAdminPassword)
			delete(rawMsg, key)
		case "catalogAdminUserName":
			err = unpopulate(val, "CatalogAdminUserName", &i.CatalogAdminUserName)
			delete(rawMsg, key)
		case "catalogPricingTier":
			err = unpopulate(val, "CatalogPricingTier", &i.CatalogPricingTier)
			delete(rawMsg, key)
		case "catalogServerEndpoint":
			err = unpopulate(val, "CatalogServerEndpoint", &i.CatalogServerEndpoint)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisProperties.
func (i IntegrationRuntimeSsisProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogInfo", i.CatalogInfo)
	populate(objectMap, "customSetupScriptProperties", i.CustomSetupScriptProperties)
	populate(objectMap, "dataProxyProperties", i.DataProxyProperties)
	populate(objectMap, "edition", i.Edition)
	populate(objectMap, "expressCustomSetupProperties", i.ExpressCustomSetupProperties)
	populate(objectMap, "licenseType", i.LicenseType)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisProperties.
func (i *IntegrationRuntimeSsisProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogInfo":
			err = unpopulate(val, "CatalogInfo", &i.CatalogInfo)
			delete(rawMsg, key)
		case "customSetupScriptProperties":
			err = unpopulate(val, "CustomSetupScriptProperties", &i.CustomSetupScriptProperties)
			delete(rawMsg, key)
		case "dataProxyProperties":
			err = unpopulate(val, "DataProxyProperties", &i.DataProxyProperties)
			delete(rawMsg, key)
		case "edition":
			err = unpopulate(val, "Edition", &i.Edition)
			delete(rawMsg, key)
		case "expressCustomSetupProperties":
			i.ExpressCustomSetupProperties, err = unmarshalCustomSetupBaseClassificationArray(val)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeStatus.
func (i IntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFactoryName", i.DataFactoryName)
	populate(objectMap, "state", i.State)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &i.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeStatusResponse.
func (i IntegrationRuntimeStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatusResponse.
func (i *IntegrationRuntimeStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeStatusClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeStopOperationStatus.
func (i IntegrationRuntimeStopOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", i.Error)
	populate(objectMap, "name", i.Name)
	populateAny(objectMap, "properties", i.Properties)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStopOperationStatus.
func (i *IntegrationRuntimeStopOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &i.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeVNetProperties.
func (i IntegrationRuntimeVNetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPs", i.PublicIPs)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "subnetId", i.SubnetID)
	populate(objectMap, "vNetId", i.VNetID)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeVNetProperties.
func (i *IntegrationRuntimeVNetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &i.PublicIPs)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		case "vNetId":
			err = unpopulate(val, "VNetID", &i.VNetID)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IotHubConnectionProperties.
func (i IotHubConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroup", i.ConsumerGroup)
	populate(objectMap, "dataFormat", i.DataFormat)
	populate(objectMap, "eventSystemProperties", i.EventSystemProperties)
	populate(objectMap, "iotHubResourceId", i.IotHubResourceID)
	populate(objectMap, "mappingRuleName", i.MappingRuleName)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sharedAccessPolicyName", i.SharedAccessPolicyName)
	populate(objectMap, "tableName", i.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IotHubConnectionProperties.
func (i *IotHubConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroup":
			err = unpopulate(val, "ConsumerGroup", &i.ConsumerGroup)
			delete(rawMsg, key)
		case "dataFormat":
			err = unpopulate(val, "DataFormat", &i.DataFormat)
			delete(rawMsg, key)
		case "eventSystemProperties":
			err = unpopulate(val, "EventSystemProperties", &i.EventSystemProperties)
			delete(rawMsg, key)
		case "iotHubResourceId":
			err = unpopulate(val, "IotHubResourceID", &i.IotHubResourceID)
			delete(rawMsg, key)
		case "mappingRuleName":
			err = unpopulate(val, "MappingRuleName", &i.MappingRuleName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &i.SharedAccessPolicyName)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &i.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IotHubDataConnection.
func (i IotHubDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = DataConnectionKindIotHub
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IotHubDataConnection.
func (i *IotHubDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KekIdentityProperties.
func (k KekIdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "useSystemAssignedIdentity", k.UseSystemAssignedIdentity)
	populate(objectMap, "userAssignedIdentity", k.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KekIdentityProperties.
func (k *KekIdentityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "useSystemAssignedIdentity":
			err = unpopulate(val, "UseSystemAssignedIdentity", &k.UseSystemAssignedIdentity)
			delete(rawMsg, key)
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &k.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Key.
func (k Key) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Key.
func (k *Key) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyInfoListResult.
func (k KeyInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyInfoListResult.
func (k *KeyInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &k.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyProperties.
func (k KeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isActiveCMK", k.IsActiveCMK)
	populate(objectMap, "keyVaultUrl", k.KeyVaultURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyProperties.
func (k *KeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isActiveCMK":
			err = unpopulate(val, "IsActiveCMK", &k.IsActiveCMK)
			delete(rawMsg, key)
		case "keyVaultUrl":
			err = unpopulate(val, "KeyVaultURL", &k.KeyVaultURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPool.
func (k KustoPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", k.Etag)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "sku", k.SKU)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPool.
func (k *KustoPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &k.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &k.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &k.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &k.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &k.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolCheckNameRequest.
func (k KustoPoolCheckNameRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", k.Name)
	objectMap["type"] = "Microsoft.Synapse/workspaces/kustoPools"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolCheckNameRequest.
func (k *KustoPoolCheckNameRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolListResult.
func (k KustoPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolListResult.
func (k *KustoPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolPrivateLinkResources.
func (k KustoPoolPrivateLinkResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolPrivateLinkResources.
func (k *KustoPoolPrivateLinkResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &k.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolProperties.
func (k KustoPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataIngestionUri", k.DataIngestionURI)
	populate(objectMap, "enablePurge", k.EnablePurge)
	populate(objectMap, "enableStreamingIngest", k.EnableStreamingIngest)
	populate(objectMap, "languageExtensions", k.LanguageExtensions)
	populate(objectMap, "optimizedAutoscale", k.OptimizedAutoscale)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "state", k.State)
	populate(objectMap, "stateReason", k.StateReason)
	populate(objectMap, "uri", k.URI)
	populate(objectMap, "workspaceUID", k.WorkspaceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolProperties.
func (k *KustoPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataIngestionUri":
			err = unpopulate(val, "DataIngestionURI", &k.DataIngestionURI)
			delete(rawMsg, key)
		case "enablePurge":
			err = unpopulate(val, "EnablePurge", &k.EnablePurge)
			delete(rawMsg, key)
		case "enableStreamingIngest":
			err = unpopulate(val, "EnableStreamingIngest", &k.EnableStreamingIngest)
			delete(rawMsg, key)
		case "languageExtensions":
			err = unpopulate(val, "LanguageExtensions", &k.LanguageExtensions)
			delete(rawMsg, key)
		case "optimizedAutoscale":
			err = unpopulate(val, "OptimizedAutoscale", &k.OptimizedAutoscale)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &k.State)
			delete(rawMsg, key)
		case "stateReason":
			err = unpopulate(val, "StateReason", &k.StateReason)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &k.URI)
			delete(rawMsg, key)
		case "workspaceUID":
			err = unpopulate(val, "WorkspaceUID", &k.WorkspaceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolUpdate.
func (k KustoPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "sku", k.SKU)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolUpdate.
func (k *KustoPoolUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &k.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &k.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LanguageExtension.
func (l LanguageExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "languageExtensionName", l.LanguageExtensionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LanguageExtension.
func (l *LanguageExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "languageExtensionName":
			err = unpopulate(val, "LanguageExtensionName", &l.LanguageExtensionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LanguageExtensionsList.
func (l LanguageExtensionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LanguageExtensionsList.
func (l *LanguageExtensionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LibraryInfo.
func (l LibraryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", l.ContainerName)
	populate(objectMap, "creatorId", l.CreatorID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "path", l.Path)
	populate(objectMap, "provisioningStatus", l.ProvisioningStatus)
	populate(objectMap, "type", l.Type)
	populateDateTimeRFC3339(objectMap, "uploadedTimestamp", l.UploadedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryInfo.
func (l *LibraryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &l.ContainerName)
			delete(rawMsg, key)
		case "creatorId":
			err = unpopulate(val, "CreatorID", &l.CreatorID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &l.Path)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &l.ProvisioningStatus)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "uploadedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UploadedTimestamp", &l.UploadedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LibraryListResponse.
func (l LibraryListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryListResponse.
func (l *LibraryListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LibraryRequirements.
func (l LibraryRequirements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", l.Content)
	populate(objectMap, "filename", l.Filename)
	populateDateTimeRFC3339(objectMap, "time", l.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryRequirements.
func (l *LibraryRequirements) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &l.Content)
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &l.Filename)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &l.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LibraryResource.
func (l LibraryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryResource.
func (l *LibraryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LicensedComponentSetupTypeProperties.
func (l LicensedComponentSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentName", l.ComponentName)
	populate(objectMap, "licenseKey", l.LicenseKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LicensedComponentSetupTypeProperties.
func (l *LicensedComponentSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &l.ComponentName)
			delete(rawMsg, key)
		case "licenseKey":
			l.LicenseKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntime.
func (l LinkedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", l.CreateTime)
	populate(objectMap, "dataFactoryLocation", l.DataFactoryLocation)
	populate(objectMap, "dataFactoryName", l.DataFactoryName)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "subscriptionId", l.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntime.
func (l *LinkedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &l.CreateTime)
			delete(rawMsg, key)
		case "dataFactoryLocation":
			err = unpopulate(val, "DataFactoryLocation", &l.DataFactoryLocation)
			delete(rawMsg, key)
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &l.DataFactoryName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l LinkedIntegrationRuntimeKeyAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = "Key"
	populate(objectMap, "key", l.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &l.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l LinkedIntegrationRuntimeRbacAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = "RBAC"
	populate(objectMap, "resourceId", l.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeType.
func (l LinkedIntegrationRuntimeType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = l.AuthorizationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResourceSKUsResult.
func (l ListResourceSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResourceSKUsResult.
func (l *ListResourceSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListSQLPoolSecurityAlertPolicies.
func (l ListSQLPoolSecurityAlertPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListSQLPoolSecurityAlertPolicies.
func (l *ListSQLPoolSecurityAlertPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowOptions.
func (m MaintenanceWindowOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowOptions.
func (m *MaintenanceWindowOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowOptionsProperties.
func (m MaintenanceWindowOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowMultipleMaintenanceWindowsPerCycle", m.AllowMultipleMaintenanceWindowsPerCycle)
	populate(objectMap, "defaultDurationInMinutes", m.DefaultDurationInMinutes)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maintenanceWindowCycles", m.MaintenanceWindowCycles)
	populate(objectMap, "minCycles", m.MinCycles)
	populate(objectMap, "minDurationInMinutes", m.MinDurationInMinutes)
	populate(objectMap, "timeGranularityInMinutes", m.TimeGranularityInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowOptionsProperties.
func (m *MaintenanceWindowOptionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowMultipleMaintenanceWindowsPerCycle":
			err = unpopulate(val, "AllowMultipleMaintenanceWindowsPerCycle", &m.AllowMultipleMaintenanceWindowsPerCycle)
			delete(rawMsg, key)
		case "defaultDurationInMinutes":
			err = unpopulate(val, "DefaultDurationInMinutes", &m.DefaultDurationInMinutes)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		case "maintenanceWindowCycles":
			err = unpopulate(val, "MaintenanceWindowCycles", &m.MaintenanceWindowCycles)
			delete(rawMsg, key)
		case "minCycles":
			err = unpopulate(val, "MinCycles", &m.MinCycles)
			delete(rawMsg, key)
		case "minDurationInMinutes":
			err = unpopulate(val, "MinDurationInMinutes", &m.MinDurationInMinutes)
			delete(rawMsg, key)
		case "timeGranularityInMinutes":
			err = unpopulate(val, "TimeGranularityInMinutes", &m.TimeGranularityInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowTimeRange.
func (m MaintenanceWindowTimeRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", m.DayOfWeek)
	populate(objectMap, "duration", m.Duration)
	populate(objectMap, "startTime", m.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowTimeRange.
func (m *MaintenanceWindowTimeRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &m.DayOfWeek)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &m.Duration)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindows.
func (m MaintenanceWindows) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindows.
func (m *MaintenanceWindows) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowsProperties.
func (m MaintenanceWindowsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "timeRanges", m.TimeRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowsProperties.
func (m *MaintenanceWindowsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "timeRanges":
			err = unpopulate(val, "TimeRanges", &m.TimeRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentity.
func (m ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentity.
func (m *ManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentitySQLControlSettingsModel.
func (m ManagedIdentitySQLControlSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentitySQLControlSettingsModel.
func (m *ManagedIdentitySQLControlSettingsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentitySQLControlSettingsModelProperties.
func (m ManagedIdentitySQLControlSettingsModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grantSqlControlToManagedIdentity", m.GrantSQLControlToManagedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentitySQLControlSettingsModelProperties.
func (m *ManagedIdentitySQLControlSettingsModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grantSqlControlToManagedIdentity":
			err = unpopulate(val, "GrantSQLControlToManagedIdentity", &m.GrantSQLControlToManagedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity.
func (m ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actualState", m.ActualState)
	populate(objectMap, "desiredState", m.DesiredState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity.
func (m *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actualState":
			err = unpopulate(val, "ActualState", &m.ActualState)
			delete(rawMsg, key)
		case "desiredState":
			err = unpopulate(val, "DesiredState", &m.DesiredState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntime.
func (m ManagedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "managedVirtualNetwork", m.ManagedVirtualNetwork)
	populate(objectMap, "state", m.State)
	objectMap["type"] = IntegrationRuntimeTypeManaged
	populate(objectMap, "typeProperties", m.TypeProperties)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "managedVirtualNetwork":
			err = unpopulate(val, "ManagedVirtualNetwork", &m.ManagedVirtualNetwork)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeError.
func (m ManagedIntegrationRuntimeError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "parameters", m.Parameters)
	populateDateTimeRFC3339(objectMap, "time", m.Time)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeError.
func (m *ManagedIntegrationRuntimeError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &m.Time)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeManagedVirtualNetworkReference.
func (m ManagedIntegrationRuntimeManagedVirtualNetworkReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "referenceName", m.ReferenceName)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeManagedVirtualNetworkReference.
func (m *ManagedIntegrationRuntimeManagedVirtualNetworkReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &m.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeNode.
func (m ManagedIntegrationRuntimeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "nodeId", m.NodeID)
	populate(objectMap, "status", m.Status)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeNode.
func (m *ManagedIntegrationRuntimeNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "nodeId":
			err = unpopulate(val, "NodeID", &m.NodeID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeOperationResult.
func (m ManagedIntegrationRuntimeOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", m.ActivityID)
	populate(objectMap, "errorCode", m.ErrorCode)
	populate(objectMap, "parameters", m.Parameters)
	populate(objectMap, "result", m.Result)
	populateDateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "type", m.Type)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeOperationResult.
func (m *ManagedIntegrationRuntimeOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &m.ActivityID)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &m.ErrorCode)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &m.Result)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeStatus.
func (m ManagedIntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFactoryName", m.DataFactoryName)
	populate(objectMap, "state", m.State)
	objectMap["type"] = IntegrationRuntimeTypeManaged
	populate(objectMap, "typeProperties", m.TypeProperties)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &m.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeStatusTypeProperties.
func (m ManagedIntegrationRuntimeStatusTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", m.CreateTime)
	populate(objectMap, "lastOperation", m.LastOperation)
	populate(objectMap, "nodes", m.Nodes)
	populate(objectMap, "otherErrors", m.OtherErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeStatusTypeProperties.
func (m *ManagedIntegrationRuntimeStatusTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &m.CreateTime)
			delete(rawMsg, key)
		case "lastOperation":
			err = unpopulate(val, "LastOperation", &m.LastOperation)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &m.Nodes)
			delete(rawMsg, key)
		case "otherErrors":
			err = unpopulate(val, "OtherErrors", &m.OtherErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntimeTypeProperties.
func (m ManagedIntegrationRuntimeTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeProperties", m.ComputeProperties)
	populate(objectMap, "ssisProperties", m.SsisProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeTypeProperties.
func (m *ManagedIntegrationRuntimeTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeProperties":
			err = unpopulate(val, "ComputeProperties", &m.ComputeProperties)
			delete(rawMsg, key)
		case "ssisProperties":
			err = unpopulate(val, "SsisProperties", &m.SsisProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedVirtualNetworkSettings.
func (m ManagedVirtualNetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAadTenantIdsForLinking", m.AllowedAADTenantIDsForLinking)
	populate(objectMap, "linkedAccessCheckOnTargetResource", m.LinkedAccessCheckOnTargetResource)
	populate(objectMap, "preventDataExfiltration", m.PreventDataExfiltration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedVirtualNetworkSettings.
func (m *ManagedVirtualNetworkSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAadTenantIdsForLinking":
			err = unpopulate(val, "AllowedAADTenantIDsForLinking", &m.AllowedAADTenantIDsForLinking)
			delete(rawMsg, key)
		case "linkedAccessCheckOnTargetResource":
			err = unpopulate(val, "LinkedAccessCheckOnTargetResource", &m.LinkedAccessCheckOnTargetResource)
			delete(rawMsg, key)
		case "preventDataExfiltration":
			err = unpopulate(val, "PreventDataExfiltration", &m.PreventDataExfiltration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataSyncConfig.
func (m MetadataSyncConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataSyncConfig.
func (m *MetadataSyncConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataSyncConfigProperties.
func (m MetadataSyncConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "syncIntervalInMinutes", m.SyncIntervalInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataSyncConfigProperties.
func (m *MetadataSyncConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "syncIntervalInMinutes":
			err = unpopulate(val, "SyncIntervalInMinutes", &m.SyncIntervalInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetaLogSpecification.
func (o OperationMetaLogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", o.BlobDuration)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetaLogSpecification.
func (o *OperationMetaLogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &o.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetaMetricDimensionSpecification.
func (o OperationMetaMetricDimensionSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "toBeExportedForShoebox", o.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetaMetricDimensionSpecification.
func (o *OperationMetaMetricDimensionSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &o.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetaMetricSpecification.
func (o OperationMetaMetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", o.AggregationType)
	populate(objectMap, "dimensions", o.Dimensions)
	populate(objectMap, "displayDescription", o.DisplayDescription)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", o.EnableRegionalMdmAccount)
	populate(objectMap, "metricFilterPattern", o.MetricFilterPattern)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "sourceMdmAccount", o.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", o.SourceMdmNamespace)
	populate(objectMap, "supportsInstanceLevelAggregation", o.SupportsInstanceLevelAggregation)
	populate(objectMap, "unit", o.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetaMetricSpecification.
func (o *OperationMetaMetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &o.AggregationType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &o.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &o.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &o.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &o.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &o.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &o.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportsInstanceLevelAggregation":
			err = unpopulate(val, "SupportsInstanceLevelAggregation", &o.SupportsInstanceLevelAggregation)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &o.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetaPropertyInfo.
func (o OperationMetaPropertyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetaPropertyInfo.
func (o *OperationMetaPropertyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetaServiceSpecification.
func (o OperationMetaServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", o.LogSpecifications)
	populate(objectMap, "metricSpecifications", o.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetaServiceSpecification.
func (o *OperationMetaServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &o.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &o.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResource.
func (o OperationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "percentComplete", o.PercentComplete)
	populateAny(objectMap, "properties", o.Properties)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResource.
func (o *OperationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OptimizedAutoscale.
func (o OptimizedAutoscale) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isEnabled", o.IsEnabled)
	populate(objectMap, "maximum", o.Maximum)
	populate(objectMap, "minimum", o.Minimum)
	populate(objectMap, "version", o.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OptimizedAutoscale.
func (o *OptimizedAutoscale) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &o.IsEnabled)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &o.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &o.Minimum)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &o.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionForPrivateLinkHub.
func (p PrivateEndpointConnectionForPrivateLinkHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionForPrivateLinkHub.
func (p *PrivateEndpointConnectionForPrivateLinkHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionForPrivateLinkHubBasic.
func (p PrivateEndpointConnectionForPrivateLinkHubBasic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionForPrivateLinkHubBasic.
func (p *PrivateEndpointConnectionForPrivateLinkHubBasic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated.
func (p PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated.
func (p *PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse.
func (p PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse.
func (p *PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionList.
func (p PrivateEndpointConnectionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionList.
func (p *PrivateEndpointConnectionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHub.
func (p PrivateLinkHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkHub.
func (p *PrivateLinkHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHubInfoListResult.
func (p PrivateLinkHubInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkHubInfoListResult.
func (p *PrivateLinkHubInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHubPatchInfo.
func (p PrivateLinkHubPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkHubPatchInfo.
func (p *PrivateLinkHubPatchInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHubProperties.
func (p PrivateLinkHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkHubProperties.
func (p *PrivateLinkHubProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &p.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResources.
func (p PrivateLinkResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResources.
func (p *PrivateLinkResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourcesProperties.
func (p PrivateLinkResourcesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourcesProperties.
func (p *PrivateLinkResourcesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurviewConfiguration.
func (p PurviewConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "purviewResourceId", p.PurviewResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurviewConfiguration.
func (p *PurviewConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "purviewResourceId":
			err = unpopulate(val, "PurviewResourceID", &p.PurviewResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryInterval.
func (q QueryInterval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "executionCount", q.ExecutionCount)
	populateDateTimeRFC3339(objectMap, "intervalStartTime", q.IntervalStartTime)
	populate(objectMap, "metrics", q.Metrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryInterval.
func (q *QueryInterval) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionCount":
			err = unpopulate(val, "ExecutionCount", &q.ExecutionCount)
			delete(rawMsg, key)
		case "intervalStartTime":
			err = unpopulateDateTimeRFC3339(val, "IntervalStartTime", &q.IntervalStartTime)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &q.Metrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryMetric.
func (q QueryMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", q.DisplayName)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "unit", q.Unit)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryMetric.
func (q *QueryMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &q.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &q.Unit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryStatistic.
func (q QueryStatistic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "intervals", q.Intervals)
	populate(objectMap, "queryId", q.QueryID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryStatistic.
func (q *QueryStatistic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "intervals":
			err = unpopulate(val, "Intervals", &q.Intervals)
			delete(rawMsg, key)
		case "queryId":
			err = unpopulate(val, "QueryID", &q.QueryID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadOnlyFollowingDatabase.
func (r ReadOnlyFollowingDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = KindReadOnlyFollowing
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadOnlyFollowingDatabaseProperties.
func (r ReadOnlyFollowingDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedDatabaseConfigurationName", r.AttachedDatabaseConfigurationName)
	populate(objectMap, "hotCachePeriod", r.HotCachePeriod)
	populate(objectMap, "leaderClusterResourceId", r.LeaderClusterResourceID)
	populate(objectMap, "principalsModificationKind", r.PrincipalsModificationKind)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "softDeletePeriod", r.SoftDeletePeriod)
	populate(objectMap, "statistics", r.Statistics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadOnlyFollowingDatabaseProperties.
func (r *ReadOnlyFollowingDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedDatabaseConfigurationName":
			err = unpopulate(val, "AttachedDatabaseConfigurationName", &r.AttachedDatabaseConfigurationName)
			delete(rawMsg, key)
		case "hotCachePeriod":
			err = unpopulate(val, "HotCachePeriod", &r.HotCachePeriod)
			delete(rawMsg, key)
		case "leaderClusterResourceId":
			err = unpopulate(val, "LeaderClusterResourceID", &r.LeaderClusterResourceID)
			delete(rawMsg, key)
		case "principalsModificationKind":
			err = unpopulate(val, "PrincipalsModificationKind", &r.PrincipalsModificationKind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "softDeletePeriod":
			err = unpopulate(val, "SoftDeletePeriod", &r.SoftDeletePeriod)
			delete(rawMsg, key)
		case "statistics":
			err = unpopulate(val, "Statistics", &r.Statistics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadWriteDatabase.
func (r ReadWriteDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = KindReadWrite
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadWriteDatabaseProperties.
func (r ReadWriteDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hotCachePeriod", r.HotCachePeriod)
	populate(objectMap, "isFollowed", r.IsFollowed)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "softDeletePeriod", r.SoftDeletePeriod)
	populate(objectMap, "statistics", r.Statistics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadWriteDatabaseProperties.
func (r *ReadWriteDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hotCachePeriod":
			err = unpopulate(val, "HotCachePeriod", &r.HotCachePeriod)
			delete(rawMsg, key)
		case "isFollowed":
			err = unpopulate(val, "IsFollowed", &r.IsFollowed)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "softDeletePeriod":
			err = unpopulate(val, "SoftDeletePeriod", &r.SoftDeletePeriod)
			delete(rawMsg, key)
		case "statistics":
			err = unpopulate(val, "Statistics", &r.Statistics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedSensitivityLabelUpdate.
func (r RecommendedSensitivityLabelUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedSensitivityLabelUpdate.
func (r *RecommendedSensitivityLabelUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedSensitivityLabelUpdateList.
func (r RecommendedSensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operations", r.Operations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedSensitivityLabelUpdateList.
func (r *RecommendedSensitivityLabelUpdateList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operations":
			err = unpopulate(val, "Operations", &r.Operations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedSensitivityLabelUpdateProperties.
func (r RecommendedSensitivityLabelUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "column", r.Column)
	populate(objectMap, "op", r.Op)
	populate(objectMap, "schema", r.Schema)
	populate(objectMap, "table", r.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedSensitivityLabelUpdateProperties.
func (r *RecommendedSensitivityLabelUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "column":
			err = unpopulate(val, "Column", &r.Column)
			delete(rawMsg, key)
		case "op":
			err = unpopulate(val, "Op", &r.Op)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &r.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &r.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoverableSQLPool.
func (r RecoverableSQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoverableSQLPool.
func (r *RecoverableSQLPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoverableSQLPoolListResult.
func (r RecoverableSQLPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoverableSQLPoolListResult.
func (r *RecoverableSQLPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoverableSQLPoolProperties.
func (r RecoverableSQLPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "edition", r.Edition)
	populate(objectMap, "elasticPoolName", r.ElasticPoolName)
	populateDateTimeRFC3339(objectMap, "lastAvailableBackupDate", r.LastAvailableBackupDate)
	populate(objectMap, "serviceLevelObjective", r.ServiceLevelObjective)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoverableSQLPoolProperties.
func (r *RecoverableSQLPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "edition":
			err = unpopulate(val, "Edition", &r.Edition)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &r.ElasticPoolName)
			delete(rawMsg, key)
		case "lastAvailableBackupDate":
			err = unpopulateDateTimeRFC3339(val, "LastAvailableBackupDate", &r.LastAvailableBackupDate)
			delete(rawMsg, key)
		case "serviceLevelObjective":
			err = unpopulate(val, "ServiceLevelObjective", &r.ServiceLevelObjective)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplaceAllFirewallRulesOperationResponse.
func (r ReplaceAllFirewallRulesOperationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", r.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplaceAllFirewallRulesOperationResponse.
func (r *ReplaceAllFirewallRulesOperationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplaceAllIPFirewallRulesRequest.
func (r ReplaceAllIPFirewallRulesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipFirewallRules", r.IPFirewallRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplaceAllIPFirewallRulesRequest.
func (r *ReplaceAllIPFirewallRulesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipFirewallRules":
			err = unpopulate(val, "IPFirewallRules", &r.IPFirewallRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationLink.
func (r ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationLink.
func (r *ReplicationLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationLinkListResult.
func (r ReplicationLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationLinkListResult.
func (r *ReplicationLinkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationLinkProperties.
func (r ReplicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isTerminationAllowed", r.IsTerminationAllowed)
	populate(objectMap, "partnerDatabase", r.PartnerDatabase)
	populate(objectMap, "partnerLocation", r.PartnerLocation)
	populate(objectMap, "partnerRole", r.PartnerRole)
	populate(objectMap, "partnerServer", r.PartnerServer)
	populate(objectMap, "percentComplete", r.PercentComplete)
	populate(objectMap, "replicationMode", r.ReplicationMode)
	populate(objectMap, "replicationState", r.ReplicationState)
	populate(objectMap, "role", r.Role)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationLinkProperties.
func (r *ReplicationLinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isTerminationAllowed":
			err = unpopulate(val, "IsTerminationAllowed", &r.IsTerminationAllowed)
			delete(rawMsg, key)
		case "partnerDatabase":
			err = unpopulate(val, "PartnerDatabase", &r.PartnerDatabase)
			delete(rawMsg, key)
		case "partnerLocation":
			err = unpopulate(val, "PartnerLocation", &r.PartnerLocation)
			delete(rawMsg, key)
		case "partnerRole":
			err = unpopulate(val, "PartnerRole", &r.PartnerRole)
			delete(rawMsg, key)
		case "partnerServer":
			err = unpopulate(val, "PartnerServer", &r.PartnerServer)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &r.PercentComplete)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &r.ReplicationMode)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &r.ReplicationState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &r.Role)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMoveDefinition.
func (r ResourceMoveDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMoveDefinition.
func (r *ResourceMoveDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedSQLPool.
func (r RestorableDroppedSQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedSQLPool.
func (r *RestorableDroppedSQLPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedSQLPoolListResult.
func (r RestorableDroppedSQLPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedSQLPoolListResult.
func (r *RestorableDroppedSQLPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedSQLPoolProperties.
func (r RestorableDroppedSQLPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationDate", r.CreationDate)
	populate(objectMap, "databaseName", r.DatabaseName)
	populateDateTimeRFC3339(objectMap, "deletionDate", r.DeletionDate)
	populateDateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populate(objectMap, "edition", r.Edition)
	populate(objectMap, "elasticPoolName", r.ElasticPoolName)
	populate(objectMap, "maxSizeBytes", r.MaxSizeBytes)
	populate(objectMap, "serviceLevelObjective", r.ServiceLevelObjective)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedSQLPoolProperties.
func (r *RestorableDroppedSQLPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &r.CreationDate)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &r.DatabaseName)
			delete(rawMsg, key)
		case "deletionDate":
			err = unpopulateDateTimeRFC3339(val, "DeletionDate", &r.DeletionDate)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateDateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "edition":
			err = unpopulate(val, "Edition", &r.Edition)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &r.ElasticPoolName)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &r.MaxSizeBytes)
			delete(rawMsg, key)
		case "serviceLevelObjective":
			err = unpopulate(val, "ServiceLevelObjective", &r.ServiceLevelObjective)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePoint.
func (r RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePoint.
func (r *RestorePoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointListResult.
func (r RestorePointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointListResult.
func (r *RestorePointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointProperties.
func (r RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populateDateTimeRFC3339(objectMap, "restorePointCreationDate", r.RestorePointCreationDate)
	populate(objectMap, "restorePointLabel", r.RestorePointLabel)
	populate(objectMap, "restorePointType", r.RestorePointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointProperties.
func (r *RestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "earliestRestoreDate":
			err = unpopulateDateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "restorePointCreationDate":
			err = unpopulateDateTimeRFC3339(val, "RestorePointCreationDate", &r.RestorePointCreationDate)
			delete(rawMsg, key)
		case "restorePointLabel":
			err = unpopulate(val, "RestorePointLabel", &r.RestorePointLabel)
			delete(rawMsg, key)
		case "restorePointType":
			err = unpopulate(val, "RestorePointType", &r.RestorePointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescription.
func (s SKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locationInfo", s.LocationInfo)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "restrictions", s.Restrictions)
	populate(objectMap, "size", s.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescription.
func (s *SKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &s.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &s.Restrictions)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescriptionList.
func (s SKUDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescriptionList.
func (s *SKUDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKULocationInfoItem.
func (s SKULocationInfoItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKULocationInfoItem.
func (s *SKULocationInfoItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPool.
func (s SQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPool.
func (s *SQLPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolBlobAuditingPolicy.
func (s SQLPoolBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolBlobAuditingPolicy.
func (s *SQLPoolBlobAuditingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolBlobAuditingPolicyListResult.
func (s SQLPoolBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolBlobAuditingPolicyListResult.
func (s *SQLPoolBlobAuditingPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolBlobAuditingPolicyProperties.
func (s SQLPoolBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditActionsAndGroups", s.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", s.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", s.IsStorageSecondaryKeyInUse)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", s.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolBlobAuditingPolicyProperties.
func (s *SQLPoolBlobAuditingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditActionsAndGroups":
			err = unpopulate(val, "AuditActionsAndGroups", &s.AuditActionsAndGroups)
			delete(rawMsg, key)
		case "isAzureMonitorTargetEnabled":
			err = unpopulate(val, "IsAzureMonitorTargetEnabled", &s.IsAzureMonitorTargetEnabled)
			delete(rawMsg, key)
		case "isStorageSecondaryKeyInUse":
			err = unpopulate(val, "IsStorageSecondaryKeyInUse", &s.IsStorageSecondaryKeyInUse)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageAccountSubscriptionId":
			err = unpopulate(val, "StorageAccountSubscriptionID", &s.StorageAccountSubscriptionID)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolBlobAuditingPolicySQLPoolOperationListResult.
func (s SQLPoolBlobAuditingPolicySQLPoolOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolBlobAuditingPolicySQLPoolOperationListResult.
func (s *SQLPoolBlobAuditingPolicySQLPoolOperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolColumn.
func (s SQLPoolColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolColumn.
func (s *SQLPoolColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolColumnListResult.
func (s SQLPoolColumnListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolColumnListResult.
func (s *SQLPoolColumnListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolColumnProperties.
func (s SQLPoolColumnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnType", s.ColumnType)
	populate(objectMap, "isComputed", s.IsComputed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolColumnProperties.
func (s *SQLPoolColumnProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnType":
			err = unpopulate(val, "ColumnType", &s.ColumnType)
			delete(rawMsg, key)
		case "isComputed":
			err = unpopulate(val, "IsComputed", &s.IsComputed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolConnectionPolicy.
func (s SQLPoolConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolConnectionPolicy.
func (s *SQLPoolConnectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolConnectionPolicyProperties.
func (s SQLPoolConnectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "proxyDnsName", s.ProxyDNSName)
	populate(objectMap, "proxyPort", s.ProxyPort)
	populate(objectMap, "redirectionState", s.RedirectionState)
	populate(objectMap, "securityEnabledAccess", s.SecurityEnabledAccess)
	populate(objectMap, "state", s.State)
	populate(objectMap, "useServerDefault", s.UseServerDefault)
	populate(objectMap, "visibility", s.Visibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolConnectionPolicyProperties.
func (s *SQLPoolConnectionPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "proxyDnsName":
			err = unpopulate(val, "ProxyDNSName", &s.ProxyDNSName)
			delete(rawMsg, key)
		case "proxyPort":
			err = unpopulate(val, "ProxyPort", &s.ProxyPort)
			delete(rawMsg, key)
		case "redirectionState":
			err = unpopulate(val, "RedirectionState", &s.RedirectionState)
			delete(rawMsg, key)
		case "securityEnabledAccess":
			err = unpopulate(val, "SecurityEnabledAccess", &s.SecurityEnabledAccess)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "useServerDefault":
			err = unpopulate(val, "UseServerDefault", &s.UseServerDefault)
			delete(rawMsg, key)
		case "visibility":
			err = unpopulate(val, "Visibility", &s.Visibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolInfoListResult.
func (s SQLPoolInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolInfoListResult.
func (s *SQLPoolInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolOperation.
func (s SQLPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolOperation.
func (s *SQLPoolOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolOperationProperties.
func (s SQLPoolOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "databaseName", s.DatabaseName)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "errorCode", s.ErrorCode)
	populate(objectMap, "errorDescription", s.ErrorDescription)
	populate(objectMap, "errorSeverity", s.ErrorSeverity)
	populateDateTimeRFC3339(objectMap, "estimatedCompletionTime", s.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", s.IsCancellable)
	populate(objectMap, "isUserError", s.IsUserError)
	populate(objectMap, "operation", s.Operation)
	populate(objectMap, "operationFriendlyName", s.OperationFriendlyName)
	populate(objectMap, "percentComplete", s.PercentComplete)
	populate(objectMap, "serverName", s.ServerName)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolOperationProperties.
func (s *SQLPoolOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &s.DatabaseName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &s.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &s.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateDateTimeRFC3339(val, "EstimatedCompletionTime", &s.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &s.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &s.IsUserError)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &s.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &s.OperationFriendlyName)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &s.PercentComplete)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &s.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolPatchInfo.
func (s SQLPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolPatchInfo.
func (s *SQLPoolPatchInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolResourceProperties.
func (s SQLPoolResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collation", s.Collation)
	populate(objectMap, "createMode", s.CreateMode)
	populateDateTimeRFC3339(objectMap, "creationDate", s.CreationDate)
	populate(objectMap, "maxSizeBytes", s.MaxSizeBytes)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "recoverableDatabaseId", s.RecoverableDatabaseID)
	populateDateTimeRFC3339(objectMap, "restorePointInTime", s.RestorePointInTime)
	populateDateTimeRFC3339(objectMap, "sourceDatabaseDeletionDate", s.SourceDatabaseDeletionDate)
	populate(objectMap, "sourceDatabaseId", s.SourceDatabaseID)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "storageAccountType", s.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolResourceProperties.
func (s *SQLPoolResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collation":
			err = unpopulate(val, "Collation", &s.Collation)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &s.CreationDate)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &s.MaxSizeBytes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "recoverableDatabaseId":
			err = unpopulate(val, "RecoverableDatabaseID", &s.RecoverableDatabaseID)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateDateTimeRFC3339(val, "RestorePointInTime", &s.RestorePointInTime)
			delete(rawMsg, key)
		case "sourceDatabaseDeletionDate":
			err = unpopulateDateTimeRFC3339(val, "SourceDatabaseDeletionDate", &s.SourceDatabaseDeletionDate)
			delete(rawMsg, key)
		case "sourceDatabaseId":
			err = unpopulate(val, "SourceDatabaseID", &s.SourceDatabaseID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &s.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolSchema.
func (s SQLPoolSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolSchema.
func (s *SQLPoolSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolSchemaListResult.
func (s SQLPoolSchemaListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolSchemaListResult.
func (s *SQLPoolSchemaListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolSecurityAlertPolicy.
func (s SQLPoolSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolSecurityAlertPolicy.
func (s *SQLPoolSecurityAlertPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolTable.
func (s SQLPoolTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolTable.
func (s *SQLPoolTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolTableListResult.
func (s SQLPoolTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolTableListResult.
func (s *SQLPoolTableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolUsage.
func (s SQLPoolUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", s.CurrentValue)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "limit", s.Limit)
	populate(objectMap, "name", s.Name)
	populateDateTimeRFC3339(objectMap, "nextResetTime", s.NextResetTime)
	populate(objectMap, "resourceName", s.ResourceName)
	populate(objectMap, "unit", s.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolUsage.
func (s *SQLPoolUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &s.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateDateTimeRFC3339(val, "NextResetTime", &s.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &s.ResourceName)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolUsageListResult.
func (s SQLPoolUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolUsageListResult.
func (s *SQLPoolUsageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessment.
func (s SQLPoolVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessment.
func (s *SQLPoolVulnerabilityAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentListResult.
func (s SQLPoolVulnerabilityAssessmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentListResult.
func (s *SQLPoolVulnerabilityAssessmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentProperties.
func (s SQLPoolVulnerabilityAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recurringScans", s.RecurringScans)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageContainerPath", s.StorageContainerPath)
	populate(objectMap, "storageContainerSasKey", s.StorageContainerSasKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentProperties.
func (s *SQLPoolVulnerabilityAssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recurringScans":
			err = unpopulate(val, "RecurringScans", &s.RecurringScans)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageContainerPath":
			err = unpopulate(val, "StorageContainerPath", &s.StorageContainerPath)
			delete(rawMsg, key)
		case "storageContainerSasKey":
			err = unpopulate(val, "StorageContainerSasKey", &s.StorageContainerSasKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaseline.
func (s SQLPoolVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaseline.
func (s *SQLPoolVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineItem.
func (s SQLPoolVulnerabilityAssessmentRuleBaselineItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "result", s.Result)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineItem.
func (s *SQLPoolVulnerabilityAssessmentRuleBaselineItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "result":
			err = unpopulate(val, "Result", &s.Result)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineProperties.
func (s SQLPoolVulnerabilityAssessmentRuleBaselineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baselineResults", s.BaselineResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineProperties.
func (s *SQLPoolVulnerabilityAssessmentRuleBaselineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baselineResults":
			err = unpopulate(val, "BaselineResults", &s.BaselineResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentScanExportProperties.
func (s SQLPoolVulnerabilityAssessmentScanExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exportedReportLocation", s.ExportedReportLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentScanExportProperties.
func (s *SQLPoolVulnerabilityAssessmentScanExportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exportedReportLocation":
			err = unpopulate(val, "ExportedReportLocation", &s.ExportedReportLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentScansExport.
func (s SQLPoolVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolVulnerabilityAssessmentScansExport.
func (s *SQLPoolVulnerabilityAssessmentScansExport) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretBase.
func (s SecretBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretBase.
func (s *SecretBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureString.
func (s SecureString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "SecureString"
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureString.
func (s *SecureString) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertPolicyProperties.
func (s SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertPolicyProperties.
func (s *SecurityAlertPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntime.
func (s SelfHostedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	objectMap["type"] = IntegrationRuntimeTypeSelfHosted
	populate(objectMap, "typeProperties", s.TypeProperties)
	if s.AdditionalProperties != nil {
		for key, val := range s.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntime.
func (s *SelfHostedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &s.TypeProperties)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntimeNode.
func (s SelfHostedIntegrationRuntimeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "concurrentJobsLimit", s.ConcurrentJobsLimit)
	populateDateTimeRFC3339(objectMap, "expiryTime", s.ExpiryTime)
	populate(objectMap, "hostServiceUri", s.HostServiceURI)
	populate(objectMap, "isActiveDispatcher", s.IsActiveDispatcher)
	populateDateTimeRFC3339(objectMap, "lastConnectTime", s.LastConnectTime)
	populateDateTimeRFC3339(objectMap, "lastEndUpdateTime", s.LastEndUpdateTime)
	populateDateTimeRFC3339(objectMap, "lastStartTime", s.LastStartTime)
	populateDateTimeRFC3339(objectMap, "lastStartUpdateTime", s.LastStartUpdateTime)
	populateDateTimeRFC3339(objectMap, "lastStopTime", s.LastStopTime)
	populate(objectMap, "lastUpdateResult", s.LastUpdateResult)
	populate(objectMap, "machineName", s.MachineName)
	populate(objectMap, "maxConcurrentJobs", s.MaxConcurrentJobs)
	populate(objectMap, "nodeName", s.NodeName)
	populateDateTimeRFC3339(objectMap, "registerTime", s.RegisterTime)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "version", s.Version)
	populate(objectMap, "versionStatus", s.VersionStatus)
	if s.AdditionalProperties != nil {
		for key, val := range s.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeNode.
func (s *SelfHostedIntegrationRuntimeNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &s.ConcurrentJobsLimit)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "hostServiceUri":
			err = unpopulate(val, "HostServiceURI", &s.HostServiceURI)
			delete(rawMsg, key)
		case "isActiveDispatcher":
			err = unpopulate(val, "IsActiveDispatcher", &s.IsActiveDispatcher)
			delete(rawMsg, key)
		case "lastConnectTime":
			err = unpopulateDateTimeRFC3339(val, "LastConnectTime", &s.LastConnectTime)
			delete(rawMsg, key)
		case "lastEndUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastEndUpdateTime", &s.LastEndUpdateTime)
			delete(rawMsg, key)
		case "lastStartTime":
			err = unpopulateDateTimeRFC3339(val, "LastStartTime", &s.LastStartTime)
			delete(rawMsg, key)
		case "lastStartUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastStartUpdateTime", &s.LastStartUpdateTime)
			delete(rawMsg, key)
		case "lastStopTime":
			err = unpopulateDateTimeRFC3339(val, "LastStopTime", &s.LastStopTime)
			delete(rawMsg, key)
		case "lastUpdateResult":
			err = unpopulate(val, "LastUpdateResult", &s.LastUpdateResult)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &s.MachineName)
			delete(rawMsg, key)
		case "maxConcurrentJobs":
			err = unpopulate(val, "MaxConcurrentJobs", &s.MaxConcurrentJobs)
			delete(rawMsg, key)
		case "nodeName":
			err = unpopulate(val, "NodeName", &s.NodeName)
			delete(rawMsg, key)
		case "registerTime":
			err = unpopulateDateTimeRFC3339(val, "RegisterTime", &s.RegisterTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &s.VersionStatus)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntimeStatus.
func (s SelfHostedIntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFactoryName", s.DataFactoryName)
	populate(objectMap, "state", s.State)
	objectMap["type"] = IntegrationRuntimeTypeSelfHosted
	populate(objectMap, "typeProperties", s.TypeProperties)
	if s.AdditionalProperties != nil {
		for key, val := range s.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeStatus.
func (s *SelfHostedIntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &s.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &s.TypeProperties)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntimeStatusTypeProperties.
func (s SelfHostedIntegrationRuntimeStatusTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpdate", s.AutoUpdate)
	populateDateTimeRFC3339(objectMap, "autoUpdateETA", s.AutoUpdateETA)
	populate(objectMap, "capabilities", s.Capabilities)
	populateDateTimeRFC3339(objectMap, "createTime", s.CreateTime)
	populate(objectMap, "internalChannelEncryption", s.InternalChannelEncryption)
	populate(objectMap, "latestVersion", s.LatestVersion)
	populate(objectMap, "links", s.Links)
	populate(objectMap, "localTimeZoneOffset", s.LocalTimeZoneOffset)
	populate(objectMap, "newerVersions", s.NewerVersions)
	populate(objectMap, "nodeCommunicationChannelEncryptionMode", s.NodeCommunicationChannelEncryptionMode)
	populate(objectMap, "nodes", s.Nodes)
	populate(objectMap, "pushedVersion", s.PushedVersion)
	populateDateTimeRFC3339(objectMap, "scheduledUpdateDate", s.ScheduledUpdateDate)
	populate(objectMap, "serviceRegion", s.ServiceRegion)
	populate(objectMap, "serviceUrls", s.ServiceUrls)
	populate(objectMap, "taskQueueId", s.TaskQueueID)
	populate(objectMap, "updateDelayOffset", s.UpdateDelayOffset)
	populate(objectMap, "version", s.Version)
	populate(objectMap, "versionStatus", s.VersionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeStatusTypeProperties.
func (s *SelfHostedIntegrationRuntimeStatusTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpdate":
			err = unpopulate(val, "AutoUpdate", &s.AutoUpdate)
			delete(rawMsg, key)
		case "autoUpdateETA":
			err = unpopulateDateTimeRFC3339(val, "AutoUpdateETA", &s.AutoUpdateETA)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &s.CreateTime)
			delete(rawMsg, key)
		case "internalChannelEncryption":
			err = unpopulate(val, "InternalChannelEncryption", &s.InternalChannelEncryption)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &s.LatestVersion)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &s.Links)
			delete(rawMsg, key)
		case "localTimeZoneOffset":
			err = unpopulate(val, "LocalTimeZoneOffset", &s.LocalTimeZoneOffset)
			delete(rawMsg, key)
		case "newerVersions":
			err = unpopulate(val, "NewerVersions", &s.NewerVersions)
			delete(rawMsg, key)
		case "nodeCommunicationChannelEncryptionMode":
			err = unpopulate(val, "NodeCommunicationChannelEncryptionMode", &s.NodeCommunicationChannelEncryptionMode)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &s.Nodes)
			delete(rawMsg, key)
		case "pushedVersion":
			err = unpopulate(val, "PushedVersion", &s.PushedVersion)
			delete(rawMsg, key)
		case "scheduledUpdateDate":
			err = unpopulateDateTimeRFC3339(val, "ScheduledUpdateDate", &s.ScheduledUpdateDate)
			delete(rawMsg, key)
		case "serviceRegion":
			err = unpopulate(val, "ServiceRegion", &s.ServiceRegion)
			delete(rawMsg, key)
		case "serviceUrls":
			err = unpopulate(val, "ServiceUrls", &s.ServiceUrls)
			delete(rawMsg, key)
		case "taskQueueId":
			err = unpopulate(val, "TaskQueueID", &s.TaskQueueID)
			delete(rawMsg, key)
		case "updateDelayOffset":
			err = unpopulate(val, "UpdateDelayOffset", &s.UpdateDelayOffset)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &s.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntimeTypeProperties.
func (s SelfHostedIntegrationRuntimeTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkedInfo", s.LinkedInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeTypeProperties.
func (s *SelfHostedIntegrationRuntimeTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkedInfo":
			s.LinkedInfo, err = unmarshalLinkedIntegrationRuntimeTypeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabel.
func (s SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "managedBy", s.ManagedBy)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabel.
func (s *SensitivityLabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &s.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelListResult.
func (s SensitivityLabelListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabelListResult.
func (s *SensitivityLabelListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelProperties.
func (s SensitivityLabelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnName", s.ColumnName)
	populate(objectMap, "informationType", s.InformationType)
	populate(objectMap, "informationTypeId", s.InformationTypeID)
	populate(objectMap, "isDisabled", s.IsDisabled)
	populate(objectMap, "labelId", s.LabelID)
	populate(objectMap, "labelName", s.LabelName)
	populate(objectMap, "rank", s.Rank)
	populate(objectMap, "schemaName", s.SchemaName)
	populate(objectMap, "tableName", s.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabelProperties.
func (s *SensitivityLabelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &s.ColumnName)
			delete(rawMsg, key)
		case "informationType":
			err = unpopulate(val, "InformationType", &s.InformationType)
			delete(rawMsg, key)
		case "informationTypeId":
			err = unpopulate(val, "InformationTypeID", &s.InformationTypeID)
			delete(rawMsg, key)
		case "isDisabled":
			err = unpopulate(val, "IsDisabled", &s.IsDisabled)
			delete(rawMsg, key)
		case "labelId":
			err = unpopulate(val, "LabelID", &s.LabelID)
			delete(rawMsg, key)
		case "labelName":
			err = unpopulate(val, "LabelName", &s.LabelName)
			delete(rawMsg, key)
		case "rank":
			err = unpopulate(val, "Rank", &s.Rank)
			delete(rawMsg, key)
		case "schemaName":
			err = unpopulate(val, "SchemaName", &s.SchemaName)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &s.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelUpdate.
func (s SensitivityLabelUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabelUpdate.
func (s *SensitivityLabelUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelUpdateList.
func (s SensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operations", s.Operations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabelUpdateList.
func (s *SensitivityLabelUpdateList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operations":
			err = unpopulate(val, "Operations", &s.Operations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelUpdateProperties.
func (s SensitivityLabelUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "column", s.Column)
	populate(objectMap, "op", s.Op)
	populate(objectMap, "schema", s.Schema)
	populate(objectMap, "sensitivityLabel", s.SensitivityLabel)
	populate(objectMap, "table", s.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SensitivityLabelUpdateProperties.
func (s *SensitivityLabelUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "column":
			err = unpopulate(val, "Column", &s.Column)
			delete(rawMsg, key)
		case "op":
			err = unpopulate(val, "Op", &s.Op)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &s.Schema)
			delete(rawMsg, key)
		case "sensitivityLabel":
			err = unpopulate(val, "SensitivityLabel", &s.SensitivityLabel)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &s.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBlobAuditingPolicy.
func (s ServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBlobAuditingPolicy.
func (s *ServerBlobAuditingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBlobAuditingPolicyListResult.
func (s ServerBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBlobAuditingPolicyListResult.
func (s *ServerBlobAuditingPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBlobAuditingPolicyProperties.
func (s ServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditActionsAndGroups", s.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", s.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", s.IsDevopsAuditEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", s.IsStorageSecondaryKeyInUse)
	populate(objectMap, "queueDelayMs", s.QueueDelayMs)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", s.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBlobAuditingPolicyProperties.
func (s *ServerBlobAuditingPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditActionsAndGroups":
			err = unpopulate(val, "AuditActionsAndGroups", &s.AuditActionsAndGroups)
			delete(rawMsg, key)
		case "isAzureMonitorTargetEnabled":
			err = unpopulate(val, "IsAzureMonitorTargetEnabled", &s.IsAzureMonitorTargetEnabled)
			delete(rawMsg, key)
		case "isDevopsAuditEnabled":
			err = unpopulate(val, "IsDevopsAuditEnabled", &s.IsDevopsAuditEnabled)
			delete(rawMsg, key)
		case "isStorageSecondaryKeyInUse":
			err = unpopulate(val, "IsStorageSecondaryKeyInUse", &s.IsStorageSecondaryKeyInUse)
			delete(rawMsg, key)
		case "queueDelayMs":
			err = unpopulate(val, "QueueDelayMs", &s.QueueDelayMs)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageAccountSubscriptionId":
			err = unpopulate(val, "StorageAccountSubscriptionID", &s.StorageAccountSubscriptionID)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerSecurityAlertPolicy.
func (s ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSecurityAlertPolicy.
func (s *ServerSecurityAlertPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerSecurityAlertPolicyListResult.
func (s ServerSecurityAlertPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSecurityAlertPolicyListResult.
func (s *ServerSecurityAlertPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerSecurityAlertPolicyProperties.
func (s ServerSecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSecurityAlertPolicyProperties.
func (s *ServerSecurityAlertPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerUsage.
func (s ServerUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", s.CurrentValue)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "limit", s.Limit)
	populate(objectMap, "name", s.Name)
	populateDateTimeRFC3339(objectMap, "nextResetTime", s.NextResetTime)
	populate(objectMap, "resourceName", s.ResourceName)
	populate(objectMap, "unit", s.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerUsage.
func (s *ServerUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &s.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateDateTimeRFC3339(val, "NextResetTime", &s.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &s.ResourceName)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerUsageListResult.
func (s ServerUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerUsageListResult.
func (s *ServerUsageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessment.
func (s ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessment.
func (s *ServerVulnerabilityAssessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessmentListResult.
func (s ServerVulnerabilityAssessmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentListResult.
func (s *ServerVulnerabilityAssessmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVulnerabilityAssessmentProperties.
func (s ServerVulnerabilityAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recurringScans", s.RecurringScans)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageContainerPath", s.StorageContainerPath)
	populate(objectMap, "storageContainerSasKey", s.StorageContainerSasKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentProperties.
func (s *ServerVulnerabilityAssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recurringScans":
			err = unpopulate(val, "RecurringScans", &s.RecurringScans)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageContainerPath":
			err = unpopulate(val, "StorageContainerPath", &s.StorageContainerPath)
			delete(rawMsg, key)
		case "storageContainerSasKey":
			err = unpopulate(val, "StorageContainerSasKey", &s.StorageContainerSasKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigProperties.
func (s SparkConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationType", s.ConfigurationType)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "filename", s.Filename)
	populateDateTimeRFC3339(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigProperties.
func (s *SparkConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &s.ConfigurationType)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &s.Filename)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigurationInfo.
func (s SparkConfigurationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", s.Annotations)
	populate(objectMap, "configMergeRule", s.ConfigMergeRule)
	populate(objectMap, "configs", s.Configs)
	populateDateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "notes", s.Notes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigurationInfo.
func (s *SparkConfigurationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &s.Annotations)
			delete(rawMsg, key)
		case "configMergeRule":
			err = unpopulate(val, "ConfigMergeRule", &s.ConfigMergeRule)
			delete(rawMsg, key)
		case "configs":
			err = unpopulate(val, "Configs", &s.Configs)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &s.Notes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigurationListResponse.
func (s SparkConfigurationListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigurationListResponse.
func (s *SparkConfigurationListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigurationResource.
func (s SparkConfigurationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigurationResource.
func (s *SparkConfigurationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisEnvironment.
func (s SsisEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "folderId", s.FolderID)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	objectMap["type"] = SsisObjectMetadataTypeEnvironment
	populate(objectMap, "variables", s.Variables)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisEnvironment.
func (s *SsisEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "variables":
			err = unpopulate(val, "Variables", &s.Variables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisEnvironmentReference.
func (s SsisEnvironmentReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "environmentFolderName", s.EnvironmentFolderName)
	populate(objectMap, "environmentName", s.EnvironmentName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "referenceType", s.ReferenceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisEnvironmentReference.
func (s *SsisEnvironmentReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentFolderName":
			err = unpopulate(val, "EnvironmentFolderName", &s.EnvironmentFolderName)
			delete(rawMsg, key)
		case "environmentName":
			err = unpopulate(val, "EnvironmentName", &s.EnvironmentName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "referenceType":
			err = unpopulate(val, "ReferenceType", &s.ReferenceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisFolder.
func (s SsisFolder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	objectMap["type"] = SsisObjectMetadataTypeFolder
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisFolder.
func (s *SsisFolder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisObjectMetadata.
func (s SsisObjectMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisObjectMetadata.
func (s *SsisObjectMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisObjectMetadataListResponse.
func (s SsisObjectMetadataListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisObjectMetadataListResponse.
func (s *SsisObjectMetadataListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			s.Value, err = unmarshalSsisObjectMetadataClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisObjectMetadataStatusResponse.
func (s SsisObjectMetadataStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisObjectMetadataStatusResponse.
func (s *SsisObjectMetadataStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisPackage.
func (s SsisPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "folderId", s.FolderID)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "projectId", s.ProjectID)
	populate(objectMap, "projectVersion", s.ProjectVersion)
	objectMap["type"] = SsisObjectMetadataTypePackage
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisPackage.
func (s *SsisPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "projectId":
			err = unpopulate(val, "ProjectID", &s.ProjectID)
			delete(rawMsg, key)
		case "projectVersion":
			err = unpopulate(val, "ProjectVersion", &s.ProjectVersion)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisParameter.
func (s SsisParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", s.DataType)
	populate(objectMap, "defaultValue", s.DefaultValue)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "designDefaultValue", s.DesignDefaultValue)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "required", s.Required)
	populate(objectMap, "sensitive", s.Sensitive)
	populate(objectMap, "sensitiveDefaultValue", s.SensitiveDefaultValue)
	populate(objectMap, "valueSet", s.ValueSet)
	populate(objectMap, "valueType", s.ValueType)
	populate(objectMap, "variable", s.Variable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisParameter.
func (s *SsisParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &s.DataType)
			delete(rawMsg, key)
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &s.DefaultValue)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "designDefaultValue":
			err = unpopulate(val, "DesignDefaultValue", &s.DesignDefaultValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &s.Required)
			delete(rawMsg, key)
		case "sensitive":
			err = unpopulate(val, "Sensitive", &s.Sensitive)
			delete(rawMsg, key)
		case "sensitiveDefaultValue":
			err = unpopulate(val, "SensitiveDefaultValue", &s.SensitiveDefaultValue)
			delete(rawMsg, key)
		case "valueSet":
			err = unpopulate(val, "ValueSet", &s.ValueSet)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &s.ValueType)
			delete(rawMsg, key)
		case "variable":
			err = unpopulate(val, "Variable", &s.Variable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisProject.
func (s SsisProject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "environmentRefs", s.EnvironmentRefs)
	populate(objectMap, "folderId", s.FolderID)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	objectMap["type"] = SsisObjectMetadataTypeProject
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisProject.
func (s *SsisProject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "environmentRefs":
			err = unpopulate(val, "EnvironmentRefs", &s.EnvironmentRefs)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsisVariable.
func (s SsisVariable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", s.DataType)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "sensitive", s.Sensitive)
	populate(objectMap, "sensitiveValue", s.SensitiveValue)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisVariable.
func (s *SsisVariable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &s.DataType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "sensitive":
			err = unpopulate(val, "Sensitive", &s.Sensitive)
			delete(rawMsg, key)
		case "sensitiveValue":
			err = unpopulate(val, "SensitiveValue", &s.SensitiveValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableLevelSharingProperties.
func (t TableLevelSharingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "externalTablesToExclude", t.ExternalTablesToExclude)
	populate(objectMap, "externalTablesToInclude", t.ExternalTablesToInclude)
	populate(objectMap, "materializedViewsToExclude", t.MaterializedViewsToExclude)
	populate(objectMap, "materializedViewsToInclude", t.MaterializedViewsToInclude)
	populate(objectMap, "tablesToExclude", t.TablesToExclude)
	populate(objectMap, "tablesToInclude", t.TablesToInclude)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableLevelSharingProperties.
func (t *TableLevelSharingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "externalTablesToExclude":
			err = unpopulate(val, "ExternalTablesToExclude", &t.ExternalTablesToExclude)
			delete(rawMsg, key)
		case "externalTablesToInclude":
			err = unpopulate(val, "ExternalTablesToInclude", &t.ExternalTablesToInclude)
			delete(rawMsg, key)
		case "materializedViewsToExclude":
			err = unpopulate(val, "MaterializedViewsToExclude", &t.MaterializedViewsToExclude)
			delete(rawMsg, key)
		case "materializedViewsToInclude":
			err = unpopulate(val, "MaterializedViewsToInclude", &t.MaterializedViewsToInclude)
			delete(rawMsg, key)
		case "tablesToExclude":
			err = unpopulate(val, "TablesToExclude", &t.TablesToExclude)
			delete(rawMsg, key)
		case "tablesToInclude":
			err = unpopulate(val, "TablesToInclude", &t.TablesToInclude)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopQueries.
func (t TopQueries) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationFunction", t.AggregationFunction)
	populate(objectMap, "executionType", t.ExecutionType)
	populate(objectMap, "intervalType", t.IntervalType)
	populate(objectMap, "numberOfTopQueries", t.NumberOfTopQueries)
	populateDateTimeRFC3339(objectMap, "observationEndTime", t.ObservationEndTime)
	populateDateTimeRFC3339(objectMap, "observationStartTime", t.ObservationStartTime)
	populate(objectMap, "observedMetric", t.ObservedMetric)
	populate(objectMap, "queries", t.Queries)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopQueries.
func (t *TopQueries) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationFunction":
			err = unpopulate(val, "AggregationFunction", &t.AggregationFunction)
			delete(rawMsg, key)
		case "executionType":
			err = unpopulate(val, "ExecutionType", &t.ExecutionType)
			delete(rawMsg, key)
		case "intervalType":
			err = unpopulate(val, "IntervalType", &t.IntervalType)
			delete(rawMsg, key)
		case "numberOfTopQueries":
			err = unpopulate(val, "NumberOfTopQueries", &t.NumberOfTopQueries)
			delete(rawMsg, key)
		case "observationEndTime":
			err = unpopulateDateTimeRFC3339(val, "ObservationEndTime", &t.ObservationEndTime)
			delete(rawMsg, key)
		case "observationStartTime":
			err = unpopulateDateTimeRFC3339(val, "ObservationStartTime", &t.ObservationStartTime)
			delete(rawMsg, key)
		case "observedMetric":
			err = unpopulate(val, "ObservedMetric", &t.ObservedMetric)
			delete(rawMsg, key)
		case "queries":
			err = unpopulate(val, "Queries", &t.Queries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopQueriesListResult.
func (t TopQueriesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopQueriesListResult.
func (t *TopQueriesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransparentDataEncryption.
func (t TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransparentDataEncryption.
func (t *TransparentDataEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransparentDataEncryptionListResult.
func (t TransparentDataEncryptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransparentDataEncryptionListResult.
func (t *TransparentDataEncryptionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransparentDataEncryptionProperties.
func (t TransparentDataEncryptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", t.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransparentDataEncryptionProperties.
func (t *TransparentDataEncryptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIntegrationRuntimeNodeRequest.
func (u UpdateIntegrationRuntimeNodeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "concurrentJobsLimit", u.ConcurrentJobsLimit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateIntegrationRuntimeNodeRequest.
func (u *UpdateIntegrationRuntimeNodeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &u.ConcurrentJobsLimit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIntegrationRuntimeRequest.
func (u UpdateIntegrationRuntimeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpdate", u.AutoUpdate)
	populate(objectMap, "updateDelayOffset", u.UpdateDelayOffset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateIntegrationRuntimeRequest.
func (u *UpdateIntegrationRuntimeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpdate":
			err = unpopulate(val, "AutoUpdate", &u.AutoUpdate)
			delete(rawMsg, key)
		case "updateDelayOffset":
			err = unpopulate(val, "UpdateDelayOffset", &u.UpdateDelayOffset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedManagedIdentity.
func (u UserAssignedManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedManagedIdentity.
func (u *UserAssignedManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProfile.
func (v VirtualNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeSubnetId", v.ComputeSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProfile.
func (v *VirtualNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeSubnetId":
			err = unpopulate(val, "ComputeSubnetID", &v.ComputeSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentRecurringScansProperties.
func (v VulnerabilityAssessmentRecurringScansProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emailSubscriptionAdmins", v.EmailSubscriptionAdmins)
	populate(objectMap, "emails", v.Emails)
	populate(objectMap, "isEnabled", v.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentRecurringScansProperties.
func (v *VulnerabilityAssessmentRecurringScansProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emailSubscriptionAdmins":
			err = unpopulate(val, "EmailSubscriptionAdmins", &v.EmailSubscriptionAdmins)
			delete(rawMsg, key)
		case "emails":
			err = unpopulate(val, "Emails", &v.Emails)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &v.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanError.
func (v VulnerabilityAssessmentScanError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanError.
func (v *VulnerabilityAssessmentScanError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanRecord.
func (v VulnerabilityAssessmentScanRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanRecord.
func (v *VulnerabilityAssessmentScanRecord) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanRecordListResult.
func (v VulnerabilityAssessmentScanRecordListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanRecordListResult.
func (v *VulnerabilityAssessmentScanRecordListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v VulnerabilityAssessmentScanRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "numberOfFailedSecurityChecks", v.NumberOfFailedSecurityChecks)
	populate(objectMap, "scanId", v.ScanID)
	populateDateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "state", v.State)
	populate(objectMap, "storageContainerPath", v.StorageContainerPath)
	populate(objectMap, "triggerType", v.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v *VulnerabilityAssessmentScanRecordProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "numberOfFailedSecurityChecks":
			err = unpopulate(val, "NumberOfFailedSecurityChecks", &v.NumberOfFailedSecurityChecks)
			delete(rawMsg, key)
		case "scanId":
			err = unpopulate(val, "ScanID", &v.ScanID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "storageContainerPath":
			err = unpopulate(val, "StorageContainerPath", &v.StorageContainerPath)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &v.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadClassifier.
func (w WorkloadClassifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadClassifier.
func (w *WorkloadClassifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadClassifierListResult.
func (w WorkloadClassifierListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadClassifierListResult.
func (w *WorkloadClassifierListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadClassifierProperties.
func (w WorkloadClassifierProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "context", w.Context)
	populate(objectMap, "endTime", w.EndTime)
	populate(objectMap, "importance", w.Importance)
	populate(objectMap, "label", w.Label)
	populate(objectMap, "memberName", w.MemberName)
	populate(objectMap, "startTime", w.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadClassifierProperties.
func (w *WorkloadClassifierProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "context":
			err = unpopulate(val, "Context", &w.Context)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulate(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "importance":
			err = unpopulate(val, "Importance", &w.Importance)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &w.Label)
			delete(rawMsg, key)
		case "memberName":
			err = unpopulate(val, "MemberName", &w.MemberName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadGroup.
func (w WorkloadGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadGroup.
func (w *WorkloadGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadGroupListResult.
func (w WorkloadGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadGroupListResult.
func (w *WorkloadGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadGroupProperties.
func (w WorkloadGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "importance", w.Importance)
	populate(objectMap, "maxResourcePercent", w.MaxResourcePercent)
	populate(objectMap, "maxResourcePercentPerRequest", w.MaxResourcePercentPerRequest)
	populate(objectMap, "minResourcePercent", w.MinResourcePercent)
	populate(objectMap, "minResourcePercentPerRequest", w.MinResourcePercentPerRequest)
	populate(objectMap, "queryExecutionTimeout", w.QueryExecutionTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadGroupProperties.
func (w *WorkloadGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "importance":
			err = unpopulate(val, "Importance", &w.Importance)
			delete(rawMsg, key)
		case "maxResourcePercent":
			err = unpopulate(val, "MaxResourcePercent", &w.MaxResourcePercent)
			delete(rawMsg, key)
		case "maxResourcePercentPerRequest":
			err = unpopulate(val, "MaxResourcePercentPerRequest", &w.MaxResourcePercentPerRequest)
			delete(rawMsg, key)
		case "minResourcePercent":
			err = unpopulate(val, "MinResourcePercent", &w.MinResourcePercent)
			delete(rawMsg, key)
		case "minResourcePercentPerRequest":
			err = unpopulate(val, "MinResourcePercentPerRequest", &w.MinResourcePercentPerRequest)
			delete(rawMsg, key)
		case "queryExecutionTimeout":
			err = unpopulate(val, "QueryExecutionTimeout", &w.QueryExecutionTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workspace.
func (w *Workspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceAADAdminInfo.
func (w WorkspaceAADAdminInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceAADAdminInfo.
func (w *WorkspaceAADAdminInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceInfoListResult.
func (w WorkspaceInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceInfoListResult.
func (w *WorkspaceInfoListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceKeyDetails.
func (w WorkspaceKeyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultUrl", w.KeyVaultURL)
	populate(objectMap, "name", w.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceKeyDetails.
func (w *WorkspaceKeyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultUrl":
			err = unpopulate(val, "KeyVaultURL", &w.KeyVaultURL)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePatchInfo.
func (w WorkspacePatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspacePatchInfo.
func (w *WorkspacePatchInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePatchProperties.
func (w WorkspacePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryption", w.Encryption)
	populate(objectMap, "managedVirtualNetworkSettings", w.ManagedVirtualNetworkSettings)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "purviewConfiguration", w.PurviewConfiguration)
	populate(objectMap, "sqlAdministratorLoginPassword", w.SQLAdministratorLoginPassword)
	populate(objectMap, "workspaceRepositoryConfiguration", w.WorkspaceRepositoryConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspacePatchProperties.
func (w *WorkspacePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryption":
			err = unpopulate(val, "Encryption", &w.Encryption)
			delete(rawMsg, key)
		case "managedVirtualNetworkSettings":
			err = unpopulate(val, "ManagedVirtualNetworkSettings", &w.ManagedVirtualNetworkSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purviewConfiguration":
			err = unpopulate(val, "PurviewConfiguration", &w.PurviewConfiguration)
			delete(rawMsg, key)
		case "sqlAdministratorLoginPassword":
			err = unpopulate(val, "SQLAdministratorLoginPassword", &w.SQLAdministratorLoginPassword)
			delete(rawMsg, key)
		case "workspaceRepositoryConfiguration":
			err = unpopulate(val, "WorkspaceRepositoryConfiguration", &w.WorkspaceRepositoryConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adlaResourceId", w.AdlaResourceID)
	populate(objectMap, "azureADOnlyAuthentication", w.AzureADOnlyAuthentication)
	populate(objectMap, "connectivityEndpoints", w.ConnectivityEndpoints)
	populate(objectMap, "cspWorkspaceAdminProperties", w.CspWorkspaceAdminProperties)
	populate(objectMap, "defaultDataLakeStorage", w.DefaultDataLakeStorage)
	populate(objectMap, "encryption", w.Encryption)
	populate(objectMap, "extraProperties", w.ExtraProperties)
	populate(objectMap, "managedResourceGroupName", w.ManagedResourceGroupName)
	populate(objectMap, "managedVirtualNetwork", w.ManagedVirtualNetwork)
	populate(objectMap, "managedVirtualNetworkSettings", w.ManagedVirtualNetworkSettings)
	populate(objectMap, "privateEndpointConnections", w.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "purviewConfiguration", w.PurviewConfiguration)
	populate(objectMap, "sqlAdministratorLogin", w.SQLAdministratorLogin)
	populate(objectMap, "sqlAdministratorLoginPassword", w.SQLAdministratorLoginPassword)
	populate(objectMap, "settings", w.Settings)
	populate(objectMap, "trustedServiceBypassEnabled", w.TrustedServiceBypassEnabled)
	populate(objectMap, "virtualNetworkProfile", w.VirtualNetworkProfile)
	populate(objectMap, "workspaceRepositoryConfiguration", w.WorkspaceRepositoryConfiguration)
	populate(objectMap, "workspaceUID", w.WorkspaceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceProperties.
func (w *WorkspaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adlaResourceId":
			err = unpopulate(val, "AdlaResourceID", &w.AdlaResourceID)
			delete(rawMsg, key)
		case "azureADOnlyAuthentication":
			err = unpopulate(val, "AzureADOnlyAuthentication", &w.AzureADOnlyAuthentication)
			delete(rawMsg, key)
		case "connectivityEndpoints":
			err = unpopulate(val, "ConnectivityEndpoints", &w.ConnectivityEndpoints)
			delete(rawMsg, key)
		case "cspWorkspaceAdminProperties":
			err = unpopulate(val, "CspWorkspaceAdminProperties", &w.CspWorkspaceAdminProperties)
			delete(rawMsg, key)
		case "defaultDataLakeStorage":
			err = unpopulate(val, "DefaultDataLakeStorage", &w.DefaultDataLakeStorage)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &w.Encryption)
			delete(rawMsg, key)
		case "extraProperties":
			err = unpopulate(val, "ExtraProperties", &w.ExtraProperties)
			delete(rawMsg, key)
		case "managedResourceGroupName":
			err = unpopulate(val, "ManagedResourceGroupName", &w.ManagedResourceGroupName)
			delete(rawMsg, key)
		case "managedVirtualNetwork":
			err = unpopulate(val, "ManagedVirtualNetwork", &w.ManagedVirtualNetwork)
			delete(rawMsg, key)
		case "managedVirtualNetworkSettings":
			err = unpopulate(val, "ManagedVirtualNetworkSettings", &w.ManagedVirtualNetworkSettings)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &w.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purviewConfiguration":
			err = unpopulate(val, "PurviewConfiguration", &w.PurviewConfiguration)
			delete(rawMsg, key)
		case "sqlAdministratorLogin":
			err = unpopulate(val, "SQLAdministratorLogin", &w.SQLAdministratorLogin)
			delete(rawMsg, key)
		case "sqlAdministratorLoginPassword":
			err = unpopulate(val, "SQLAdministratorLoginPassword", &w.SQLAdministratorLoginPassword)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &w.Settings)
			delete(rawMsg, key)
		case "trustedServiceBypassEnabled":
			err = unpopulate(val, "TrustedServiceBypassEnabled", &w.TrustedServiceBypassEnabled)
			delete(rawMsg, key)
		case "virtualNetworkProfile":
			err = unpopulate(val, "VirtualNetworkProfile", &w.VirtualNetworkProfile)
			delete(rawMsg, key)
		case "workspaceRepositoryConfiguration":
			err = unpopulate(val, "WorkspaceRepositoryConfiguration", &w.WorkspaceRepositoryConfiguration)
			delete(rawMsg, key)
		case "workspaceUID":
			err = unpopulate(val, "WorkspaceUID", &w.WorkspaceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceRepositoryConfiguration.
func (w WorkspaceRepositoryConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", w.AccountName)
	populate(objectMap, "collaborationBranch", w.CollaborationBranch)
	populate(objectMap, "hostName", w.HostName)
	populate(objectMap, "lastCommitId", w.LastCommitID)
	populate(objectMap, "projectName", w.ProjectName)
	populate(objectMap, "repositoryName", w.RepositoryName)
	populate(objectMap, "rootFolder", w.RootFolder)
	populate(objectMap, "tenantId", w.TenantID)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceRepositoryConfiguration.
func (w *WorkspaceRepositoryConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &w.AccountName)
			delete(rawMsg, key)
		case "collaborationBranch":
			err = unpopulate(val, "CollaborationBranch", &w.CollaborationBranch)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &w.HostName)
			delete(rawMsg, key)
		case "lastCommitId":
			err = unpopulate(val, "LastCommitID", &w.LastCommitID)
			delete(rawMsg, key)
		case "projectName":
			err = unpopulate(val, "ProjectName", &w.ProjectName)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &w.RepositoryName)
			delete(rawMsg, key)
		case "rootFolder":
			err = unpopulate(val, "RootFolder", &w.RootFolder)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
