// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.18.1
// source: google/cloud/osconfig/logging/patch_job_log.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of the various states a patch job passes through as it
// executes.
type PatchJobCompletedLog_State int32

const (
	// State must be specified.
	PatchJobCompletedLog_STATE_UNSPECIFIED PatchJobCompletedLog_State = 0
	// The patch job was successfully initiated.
	PatchJobCompletedLog_STARTED PatchJobCompletedLog_State = 1
	// The patch job is looking up instances to run the patch on.
	PatchJobCompletedLog_INSTANCE_LOOKUP PatchJobCompletedLog_State = 2
	// Instances are being patched.
	PatchJobCompletedLog_PATCHING PatchJobCompletedLog_State = 3
	// Patch job completed successfully.
	PatchJobCompletedLog_SUCCEEDED PatchJobCompletedLog_State = 4
	// Patch job completed but there were errors.
	PatchJobCompletedLog_COMPLETED_WITH_ERRORS PatchJobCompletedLog_State = 5
	// The patch job was canceled.
	PatchJobCompletedLog_CANCELED PatchJobCompletedLog_State = 6
	// The patch job has timed out.
	PatchJobCompletedLog_TIMED_OUT PatchJobCompletedLog_State = 7
)

// Enum value maps for PatchJobCompletedLog_State.
var (
	PatchJobCompletedLog_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "INSTANCE_LOOKUP",
		3: "PATCHING",
		4: "SUCCEEDED",
		5: "COMPLETED_WITH_ERRORS",
		6: "CANCELED",
		7: "TIMED_OUT",
	}
	PatchJobCompletedLog_State_value = map[string]int32{
		"STATE_UNSPECIFIED":     0,
		"STARTED":               1,
		"INSTANCE_LOOKUP":       2,
		"PATCHING":              3,
		"SUCCEEDED":             4,
		"COMPLETED_WITH_ERRORS": 5,
		"CANCELED":              6,
		"TIMED_OUT":             7,
	}
)

func (x PatchJobCompletedLog_State) Enum() *PatchJobCompletedLog_State {
	p := new(PatchJobCompletedLog_State)
	*p = x
	return p
}

func (x PatchJobCompletedLog_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PatchJobCompletedLog_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_logging_patch_job_log_proto_enumTypes[0].Descriptor()
}

func (PatchJobCompletedLog_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_logging_patch_job_log_proto_enumTypes[0]
}

func (x PatchJobCompletedLog_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PatchJobCompletedLog_State.Descriptor instead.
func (PatchJobCompletedLog_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescGZIP(), []int{0, 0}
}

type PatchJobCompletedLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The patch job name. For example:
	// projects/PROJECT_ID/patchJobs/PATCH_JOB_ID
	PatchJob string `protobuf:"bytes,1,opt,name=patch_job,json=patchJob,proto3" json:"patch_job,omitempty"`
	// The current state of the PatchJob.
	State PatchJobCompletedLog_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.osconfig.logging.PatchJobCompletedLog_State" json:"state,omitempty"`
	// Summary of instance details.
	InstanceDetailsSummary *PatchJobCompletedLog_InstanceDetailsSummary `protobuf:"bytes,3,opt,name=instance_details_summary,json=instanceDetailsSummary,proto3" json:"instance_details_summary,omitempty"`
	// If this patch job is a dry run, the agent will report that it has
	// finished without running any updates on the VM.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// If this patch job failed, this message will provide information about the
	// failure.
	ErrorMessage string `protobuf:"bytes,5,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Time this PatchJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Last time this PatchJob was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PatchJobCompletedLog) Reset() {
	*x = PatchJobCompletedLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchJobCompletedLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchJobCompletedLog) ProtoMessage() {}

func (x *PatchJobCompletedLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchJobCompletedLog.ProtoReflect.Descriptor instead.
func (*PatchJobCompletedLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescGZIP(), []int{0}
}

func (x *PatchJobCompletedLog) GetPatchJob() string {
	if x != nil {
		return x.PatchJob
	}
	return ""
}

func (x *PatchJobCompletedLog) GetState() PatchJobCompletedLog_State {
	if x != nil {
		return x.State
	}
	return PatchJobCompletedLog_STATE_UNSPECIFIED
}

func (x *PatchJobCompletedLog) GetInstanceDetailsSummary() *PatchJobCompletedLog_InstanceDetailsSummary {
	if x != nil {
		return x.InstanceDetailsSummary
	}
	return nil
}

func (x *PatchJobCompletedLog) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *PatchJobCompletedLog) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *PatchJobCompletedLog) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PatchJobCompletedLog) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A summary of the current patch state across all instances this patch job
// affects. Contains counts of instances in different states. These states map
// to InstancePatchState. List patch job instance details to see the specific
// states of each instance.
type PatchJobCompletedLog_InstanceDetailsSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of instances pending patch job.
	InstancesPending int64 `protobuf:"varint,1,opt,name=instances_pending,json=instancesPending,proto3" json:"instances_pending,omitempty"`
	// Number of instances that are inactive.
	InstancesInactive int64 `protobuf:"varint,2,opt,name=instances_inactive,json=instancesInactive,proto3" json:"instances_inactive,omitempty"`
	// Number of instances notified about patch job.
	InstancesNotified int64 `protobuf:"varint,3,opt,name=instances_notified,json=instancesNotified,proto3" json:"instances_notified,omitempty"`
	// Number of instances that have started.
	InstancesStarted int64 `protobuf:"varint,4,opt,name=instances_started,json=instancesStarted,proto3" json:"instances_started,omitempty"`
	// Number of instances that are downloading patches.
	InstancesDownloadingPatches int64 `protobuf:"varint,5,opt,name=instances_downloading_patches,json=instancesDownloadingPatches,proto3" json:"instances_downloading_patches,omitempty"`
	// Number of instances that are applying patches.
	InstancesApplyingPatches int64 `protobuf:"varint,6,opt,name=instances_applying_patches,json=instancesApplyingPatches,proto3" json:"instances_applying_patches,omitempty"`
	// Number of instances rebooting.
	InstancesRebooting int64 `protobuf:"varint,7,opt,name=instances_rebooting,json=instancesRebooting,proto3" json:"instances_rebooting,omitempty"`
	// Number of instances that have completed successfully.
	InstancesSucceeded int64 `protobuf:"varint,8,opt,name=instances_succeeded,json=instancesSucceeded,proto3" json:"instances_succeeded,omitempty"`
	// Number of instances that require reboot.
	InstancesSucceededRebootRequired int64 `protobuf:"varint,9,opt,name=instances_succeeded_reboot_required,json=instancesSucceededRebootRequired,proto3" json:"instances_succeeded_reboot_required,omitempty"`
	// Number of instances that failed.
	InstancesFailed int64 `protobuf:"varint,10,opt,name=instances_failed,json=instancesFailed,proto3" json:"instances_failed,omitempty"`
	// Number of instances that have acked and will start shortly.
	InstancesAcked int64 `protobuf:"varint,11,opt,name=instances_acked,json=instancesAcked,proto3" json:"instances_acked,omitempty"`
	// Number of instances that exceeded the time out while applying the patch.
	InstancesTimedOut int64 `protobuf:"varint,12,opt,name=instances_timed_out,json=instancesTimedOut,proto3" json:"instances_timed_out,omitempty"`
	// Number of instances that are running the pre-patch step.
	InstancesRunningPrePatchStep int64 `protobuf:"varint,13,opt,name=instances_running_pre_patch_step,json=instancesRunningPrePatchStep,proto3" json:"instances_running_pre_patch_step,omitempty"`
	// Number of instances that are running the post-patch step.
	InstancesRunningPostPatchStep int64 `protobuf:"varint,14,opt,name=instances_running_post_patch_step,json=instancesRunningPostPatchStep,proto3" json:"instances_running_post_patch_step,omitempty"`
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) Reset() {
	*x = PatchJobCompletedLog_InstanceDetailsSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchJobCompletedLog_InstanceDetailsSummary) ProtoMessage() {}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchJobCompletedLog_InstanceDetailsSummary.ProtoReflect.Descriptor instead.
func (*PatchJobCompletedLog_InstanceDetailsSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesPending() int64 {
	if x != nil {
		return x.InstancesPending
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesInactive() int64 {
	if x != nil {
		return x.InstancesInactive
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesNotified() int64 {
	if x != nil {
		return x.InstancesNotified
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesStarted() int64 {
	if x != nil {
		return x.InstancesStarted
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesDownloadingPatches() int64 {
	if x != nil {
		return x.InstancesDownloadingPatches
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesApplyingPatches() int64 {
	if x != nil {
		return x.InstancesApplyingPatches
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesRebooting() int64 {
	if x != nil {
		return x.InstancesRebooting
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesSucceeded() int64 {
	if x != nil {
		return x.InstancesSucceeded
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesSucceededRebootRequired() int64 {
	if x != nil {
		return x.InstancesSucceededRebootRequired
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesFailed() int64 {
	if x != nil {
		return x.InstancesFailed
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesAcked() int64 {
	if x != nil {
		return x.InstancesAcked
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesTimedOut() int64 {
	if x != nil {
		return x.InstancesTimedOut
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesRunningPrePatchStep() int64 {
	if x != nil {
		return x.InstancesRunningPrePatchStep
	}
	return 0
}

func (x *PatchJobCompletedLog_InstanceDetailsSummary) GetInstancesRunningPostPatchStep() int64 {
	if x != nil {
		return x.InstancesRunningPostPatchStep
	}
	return 0
}

var File_google_cloud_osconfig_logging_patch_job_log_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_logging_patch_job_log_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x0a, 0x0a, 0x14, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x18, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x5f,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x16, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x99, 0x06, 0x0a, 0x16, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x69,
	0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x42, 0x0a, 0x1d,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x2f,
	0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x62, 0x6f,
	0x6f, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x2f, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64,
	0x12, 0x4d, 0x0a, 0x23, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x20, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12,
	0x29, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x63,
	0x6b, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x64,
	0x4f, 0x75, 0x74, 0x12, 0x46, 0x0a, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x65, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x65, 0x70, 0x12, 0x48, 0x0a, 0x21, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x65, 0x70,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x53, 0x74, 0x65, 0x70, 0x22, 0x95, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x4c, 0x4f, 0x4f, 0x4b, 0x55, 0x50, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x41, 0x54, 0x43,
	0x48, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x10, 0x05,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d,
	0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x07, 0x42, 0x7d, 0x0a,
	0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x42, 0x10, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescData = file_google_cloud_osconfig_logging_patch_job_log_proto_rawDesc
)

func file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescData)
	})
	return file_google_cloud_osconfig_logging_patch_job_log_proto_rawDescData
}

var file_google_cloud_osconfig_logging_patch_job_log_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_osconfig_logging_patch_job_log_proto_goTypes = []interface{}{
	(PatchJobCompletedLog_State)(0),                     // 0: google.cloud.osconfig.logging.PatchJobCompletedLog.State
	(*PatchJobCompletedLog)(nil),                        // 1: google.cloud.osconfig.logging.PatchJobCompletedLog
	(*PatchJobCompletedLog_InstanceDetailsSummary)(nil), // 2: google.cloud.osconfig.logging.PatchJobCompletedLog.InstanceDetailsSummary
	(*timestamppb.Timestamp)(nil),                       // 3: google.protobuf.Timestamp
}
var file_google_cloud_osconfig_logging_patch_job_log_proto_depIdxs = []int32{
	0, // 0: google.cloud.osconfig.logging.PatchJobCompletedLog.state:type_name -> google.cloud.osconfig.logging.PatchJobCompletedLog.State
	2, // 1: google.cloud.osconfig.logging.PatchJobCompletedLog.instance_details_summary:type_name -> google.cloud.osconfig.logging.PatchJobCompletedLog.InstanceDetailsSummary
	3, // 2: google.cloud.osconfig.logging.PatchJobCompletedLog.create_time:type_name -> google.protobuf.Timestamp
	3, // 3: google.cloud.osconfig.logging.PatchJobCompletedLog.update_time:type_name -> google.protobuf.Timestamp
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_logging_patch_job_log_proto_init() }
func file_google_cloud_osconfig_logging_patch_job_log_proto_init() {
	if File_google_cloud_osconfig_logging_patch_job_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchJobCompletedLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchJobCompletedLog_InstanceDetailsSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_logging_patch_job_log_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_logging_patch_job_log_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_logging_patch_job_log_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_logging_patch_job_log_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_logging_patch_job_log_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_logging_patch_job_log_proto = out.File
	file_google_cloud_osconfig_logging_patch_job_log_proto_rawDesc = nil
	file_google_cloud_osconfig_logging_patch_job_log_proto_goTypes = nil
	file_google_cloud_osconfig_logging_patch_job_log_proto_depIdxs = nil
}
