// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMSY",

  0xee,
  "TeX math symbols",
  0x00800000,
  0xbe4bc80b,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x00110010 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000b242c },
  { 0x09, "num2", 0x00068a94 },
  { 0x0a, "num3", 0x000751b0 },
  { 0x0b, "denom1", 0x000bfc5a },
  { 0x0c, "denom2", 0x00064650 },
  { 0x0d, "sup1", 0x0006a58c },
  { 0x0e, "sup2", 0x0005a58c },
  { 0x0f, "sup3", 0x00048e38 },
  { 0x10, "sub1", 0x00020000 },
  { 0x11, "sub2", 0x00040000 },
  { 0x12, "supdrop", 0x00065556 },
  { 0x13, "subdrop", 0x00010000 },
  { 0x14, "delim1", 0x0017cccc },
  { 0x15, "delim2", 0x00123334 },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x00034e3c }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x000078e4 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x0002d558 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x0000f1c8 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x0001e390 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x000078e4 }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x000078e4 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x00025c74 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x00016aac }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x00025c74 }
};


static TFM::Character character[] = {
  { 0x00, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x0004b8e8, 0x00074e3c, 0xffff4e3c, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00088008, 0x000771c8, 0xffff71c8, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00088008, 0x00074e3c, 0xffff4e3c, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000d38f0, 0x0009aab0, 0x0001aab0, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x00110010, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00088008, 0x00074e3c, 0xffff4e3c, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00088008, 0x00074e3c, 0xffff4e3c, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x000d38f0, 0x0007bc4e, 0xffffbc4e, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000d38f0, 0x0007bc4e, 0xffffbc4e, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000d38f0, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000d38f0, 0x000812b6, 0x000012b6, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000d38f0, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000d38f0, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00110010, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00110010, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000d38f0, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000d38f0, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x00088008, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00088008, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00110010, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00110010, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000d38f0, 0x0007bc4e, 0xffffbc4e, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000a6398, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000a6398, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x00110010, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00110010, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00110010, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000d38f0, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00049c72, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00110010, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000b5560, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000b5560, 0x00090290, 0x00010290, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x000f1c80, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x000f1c80, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x00060c3c, 0xfffe0c3c, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000971d0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000971d0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000b5560, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00088008, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000c4728, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000c4728, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000d38f0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000d38f0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000a6398, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000d975c, 0x000aeeee, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000b1d56, 0x000aeeee, 0x00000000, 0x00006e7e, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x0009009a, 0x000aeeee, 0x00000000, 0x0000dae4, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x000d25e2, 0x000aeeee, 0x00000000, 0x000078e4, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x0008f8ec, 0x000aeeee, 0x00000000, 0x00016244, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000c2228, 0x000aeeee, 0x00000000, 0x00019a50, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x000a1880, 0x000aeeee, 0x00018e3a, 0x0000ec3a, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000e77ce, 0x000aeeee, 0x00000000, 0x000004d8, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x00095e2e, 0x000aeeee, 0x00000000, 0x000116c4, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000b85bc, 0x000aeeee, 0x00018e3a, 0x00000000, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000ceb4c, 0x000aeeee, 0x00000000, 0x00001be0, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000bb0f6, 0x000aeeee, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00143b7a, 0x000aeeee, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000de7de, 0x000aeeee, 0x00000000, 0x000262b4, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000d773a, 0x000aeeee, 0x00000000, 0x000078e4, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000be49a, 0x000aeeee, 0x00000000, 0x00015456, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000de230, 0x000aeeee, 0x00018e3a, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000e829e, 0x000aeeee, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000a4b6a, 0x000aeeee, 0x00000000, 0x00012c26, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x00096190, 0x000aeeee, 0x00000000, 0x000004d8, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000a9ae6, 0x000aeeee, 0x00000000, 0x00019a50, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000a7fc4, 0x000aeeee, 0x00000000, 0x00015456, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x0010dfca, 0x000aeeee, 0x00000000, 0x00015456, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000c1a0c, 0x000aeeee, 0x00000000, 0x000257c6, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000b4b22, 0x000aeeee, 0x00018e3a, 0x00015456, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000c37cc, 0x000aeeee, 0x00000000, 0x0001483e, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000a6398, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000a6398, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00078e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00078e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00078e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00078e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00088008, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x00088008, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00069c78, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00069c78, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x0004b8e8, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x00088008, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00088008, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000a6398, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00088008, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x0004b8e8, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000e2ab8, 0x0000b852, 0x000f47ae, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000cbbc8, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x000e2ab8, 0x000aeeee, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x000718ea, 0x000b1c72, 0x00031c72, 0x0001e390, 0, 0, 0, 0 },
  { 0x74, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000b5560, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000d38f0, 0x000ab2a2, 0x0002b2a2, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x00078e40, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00078e40, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00078e40, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000a6398, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000d38f0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000d38f0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000d38f0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000d38f0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 }
};

void
cmsy8_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
