#! /usr/bin/env python

import io
import glob
import re
import sys

if len(sys.argv) == 2:
    srcdir = sys.argv[1]
else:
    srcdir = '.'


fd = io.StringIO()

print("/* This file has been autogenerated; changes will be lost */", file=fd)
print("", file=fd)
print("typedef GType (*type_function) ();", file=fd)
print("", file=fd)

header_files = []
for header_file in sorted(glob.glob('%s/*/*.h' % srcdir) + glob.glob('%s/*/*/*.h' % srcdir)):
    assert not ('/id-wsf/' in header_file or '/id-wsf-2.0' in header_file)
    header_files.append(header_file)
    try:
        type = re.findall('lasso_.*get_type', open(header_file, encoding='utf-8').read())[0]
    except IndexError:
        continue
    print("extern GType %s();" % type, file=fd)

print("", file=fd)
print("type_function functions[] = {", file=fd)
for header_file in header_files:
    try:
        type = re.findall('lasso_.*get_type', open(header_file, encoding='utf-8').read())[0]
    except IndexError:
        continue
    print("\t%s," % type, file=fd)
print("\tNULL", file=fd)
print("};", file=fd)

open('types.c', 'w', encoding='utf-8').write(fd.getvalue())
