/* SPDX-FileCopyrightText: 2012-2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <glib.h>

G_BEGIN_DECLS

/* This header exists to avoid cycles in header inclusions, when header A needs
 * the type B and header B needs the type A. For an alternative way to solve
 * this problem (in C11), see:
 * https://bugzilla.gnome.org/show_bug.cgi?id=679424#c20
 *
 * TODO: instead of putting systematically all typedefs here, have only what's
 * strictly necessary. To make most classes easier to copy in other repos, and
 * have a better view of the cycles that are avoided.
 */

typedef struct _GtkSourceBuffer  GtkSourceBuffer;
typedef struct _GtkSourceView    GtkSourceView;

/* Really needed: */
typedef struct _GtkSourceCompletionContext   GtkSourceCompletionContext;
typedef struct _GtkSourceCompletionProvider  GtkSourceCompletionProvider;

G_END_DECLS
