# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterDeviceSecurityGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_device_security_groups_list(self, resource_group):
        response = self.client.device_security_groups.list(
            resource_id="str",
            api_version="2019-08-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_device_security_groups_get(self, resource_group):
        response = self.client.device_security_groups.get(
            resource_id="str",
            device_security_group_name="str",
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_device_security_groups_create_or_update(self, resource_group):
        response = self.client.device_security_groups.create_or_update(
            resource_id="str",
            device_security_group_name="str",
            device_security_group={
                "allowlistRules": ["allowlist_custom_alert_rule"],
                "denylistRules": [
                    {
                        "denylistValues": ["str"],
                        "isEnabled": bool,
                        "ruleType": "DenylistCustomAlertRule",
                        "description": "str",
                        "displayName": "str",
                        "valueType": "str",
                    }
                ],
                "id": "str",
                "name": "str",
                "thresholdRules": ["threshold_custom_alert_rule"],
                "timeWindowRules": ["time_window_custom_alert_rule"],
                "type": "str",
            },
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_device_security_groups_delete(self, resource_group):
        response = self.client.device_security_groups.delete(
            resource_id="str",
            device_security_group_name="str",
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...
