/*****************************************************************************
 *                                                                           *
 *          UNURAN -- Universal Non-Uniform Random number generator          *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 *   FILE: dss.h                                                             *
 *                                                                           *
 *   PURPOSE:                                                                *
 *         function prototypes for method DSS                                *
 *         ((Discrete) Sequential Search (guide table))                      *
 *                                                                           *
 *   USAGE:                                                                  *
 *         only included in unuran.h                                         *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 *   Copyright (c) 2000-2022 Wolfgang Hoermann and Josef Leydold             *
 *   Department of Statistics and Mathematics, WU Wien, Austria              *
 *   SPDX-License-Identifier: BSD-3-Clause                                   *
 *                                                                           *

 *                                                                           *
 *****************************************************************************/

/* 
   =METHOD  DSS  (Discrete) Sequential Search method

   =UP  Methods_for_DISCR

   =REQUIRED probability vector (PV) and sum over PV; or
             probability mass function(PMF), sum over PV and domain; or
             or cumulative distribution function (CDF)

   =SPEED Set-up: fast, Sampling: very slow (linear in expectation)

   =REINIT supported

   =REF [HLD04: Sect.3.1.1, Alg.3.1]

   =DESCRIPTION
      DSS samples from arbitrary discrete distributions.
      Random numbers are generated by the inversion method, i.e.,

      @enumerate
      @item
      Generate a random number U ~ U(0,1).
      @item
      Find smallest integer I such that F(I) = P(X<=I) >= U.
      @end enumerate

      Step (2) is the crucial step. Using sequential search requires
      @i{O(E(X))} comparisons, where @i{E(X)} is the expectation of
      the distribution. Thus this method is only recommended when only
      a few random variates from the given distribution are required.
      Otherwise, table methods like DGT (@pxref{DGT}) or DAU (@pxref{DAU})
      are much faster. These methods also need not the sum over the
      PMF (or PV) as input. On the other hand, however, these methods
      always compute a table.

      DSS runs with the PV, the PMF, or the CDF of the distribution.
      It uses actually uses the first one in this list (in this
      ordering) that could be found.

   =HOWTOUSE
      It works with a discrete distribution object with contains at
      least the PV, the PMF, or the CDF. 

      It is possible to change the parameters and the domain of the chosen 
      distribution and run unur_reinit() to reinitialize the generator object.

   =END
*/

/*---------------------------------------------------------------------------*/
/* Routines for user interface                                               */

/* =ROUTINES */

UNUR_PAR *unur_dss_new( const UNUR_DISTR *distribution );
/* 
   Get default parameters for generator.
*/

/* =END */

/*---------------------------------------------------------------------------*/
