#ifndef SRC_LOG_H_
#define SRC_LOG_H_

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>
#if WIN32
#include <io.h>
#include <share.h>
#endif
#if UNIX
#include <unistd.h>
#endif

#if defined(WIN32) && !defined(_MODE_T_DEFINED)
#define _MODE_T_DEFINED 1
typedef int mode_t;
#endif

enum {
	OPFL_APPEND,
	OPFL_WRITE,
	OPFL_APLUS,
	OPFL_WPLUS
};

__SWIRC_BEGIN_DECLS
extern const char	g_log_filesuffix[5];
extern const int	g_open_flags[4];
extern const mode_t	g_open_modes;

char	*log_get_path(const char *, const char *);
void	 log_msg(const char *, const char *);
void	 log_toggle_on_off(void);
__SWIRC_END_DECLS

#endif
