/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterType;
import com.mongodb.ServerAddress;
import com.mongodb.ServerDescription;
import com.mongodb.ServerSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongosHAServerSelector
implements ServerSelector {
    private ServerAddress stickTo;
    private Set<ServerAddress> consideredServers = new HashSet<ServerAddress>();

    MongosHAServerSelector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerDescription> choose(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.Multiple || clusterDescription.getType() != ClusterType.Sharded) {
            throw new IllegalArgumentException("This is not a sharded cluster with multiple mongos servers");
        }
        Set<ServerAddress> okServers = this.getOkServers(clusterDescription);
        MongosHAServerSelector mongosHAServerSelector = this;
        synchronized (mongosHAServerSelector) {
            if (!this.consideredServers.containsAll(okServers) || !okServers.contains(this.stickTo)) {
                if (this.stickTo != null && !okServers.contains(this.stickTo)) {
                    this.stickTo = null;
                    this.consideredServers.clear();
                }
                ServerDescription fastestServer = null;
                for (ServerDescription cur : clusterDescription.getAny()) {
                    if (fastestServer != null && cur.getAverageLatencyNanos() >= fastestServer.getAverageLatencyNanos()) continue;
                    fastestServer = cur;
                }
                if (fastestServer != null) {
                    this.stickTo = fastestServer.getAddress();
                    this.consideredServers.addAll(okServers);
                }
            }
            if (this.stickTo == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(clusterDescription.getByServerAddress(this.stickTo));
        }
    }

    public String toString() {
        return "MongosHAServerSelector{" + (this.stickTo == null ? "" : "stickTo=" + this.stickTo) + '}';
    }

    private Set<ServerAddress> getOkServers(ClusterDescription clusterDescription) {
        HashSet<ServerAddress> okServers = new HashSet<ServerAddress>();
        for (ServerDescription cur : clusterDescription.getAny()) {
            okServers.add(cur.getAddress());
        }
        return okServers;
    }
}

