/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.WebBookVisualPanel3;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openide.util.NbBundle;

public class WebSources
extends WebSection {
    private static final TagPath PATH2ABBR = new TagPath("SOUR:ABBR");
    private static final TagPath PATH2AUTH = new TagPath("SOUR:AUTH");
    private static final TagPath PATH2TEXT = new TagPath("SOUR:TEXT");
    private static final TagPath PATH2DATATEXT = new TagPath("SOUR:DATA:TEXT");
    private static final TagPath PATH2REPO = new TagPath("SOUR:REPO");
    private static final TagPath PATH2EVEN = new TagPath("SOUR:DATA:EVEN");
    private static final TagPath PATH2NOTE = new TagPath("SOUR:NOTE");
    private static final TagPath PATH2SNOTE = new TagPath("SOUR:SNOTE");
    private static final TagPath PATH2XREF = new TagPath("SOUR:XREF");
    private Comparator<Entity> sortEntities = new Comparator<Entity>(){

        @Override
        public int compare(Entity ent1, Entity ent2) {
            Indi wife;
            Indi husband;
            Fam famRel;
            Indi indi;
            if (ent1 == null && ent2 != null) {
                return -1;
            }
            if (ent1 != null && ent2 == null) {
                return 1;
            }
            if (ent1 == null && ent2 == null) {
                return 0;
            }
            Object str1 = "";
            Object str2 = "";
            if (ent1 instanceof Indi) {
                indi = (Indi)ent1;
                str1 = (WebSources.this.wh.getLastName(indi, "_") + ", " + indi.getFirstName()).trim();
            }
            if (ent1 instanceof Fam) {
                famRel = (Fam)ent1;
                husband = famRel.getHusband();
                wife = famRel.getWife();
                if (husband != null) {
                    str1 = (String)str1 + (WebSources.this.wh.getLastName(husband, "_") + ", " + husband.getFirstName()).trim();
                }
                if (husband != null && wife != null) {
                    str1 = (String)str1 + " + ";
                }
                if (wife != null) {
                    str1 = (String)str1 + (WebSources.this.wh.getLastName(wife, "_") + ", " + wife.getFirstName()).trim();
                }
            }
            if (ent2 instanceof Indi) {
                indi = (Indi)ent2;
                str2 = (WebSources.this.wh.getLastName(indi, "_") + ", " + indi.getFirstName()).trim();
            }
            if (ent2 instanceof Fam) {
                famRel = (Fam)ent2;
                husband = famRel.getHusband();
                wife = famRel.getWife();
                if (husband != null) {
                    str2 = (String)str2 + (WebSources.this.wh.getLastName(husband, "_") + ", " + husband.getFirstName()).trim();
                }
                if (husband != null && wife != null) {
                    str2 = (String)str2 + " + ";
                }
                if (wife != null) {
                    str2 = (String)str2 + (WebSources.this.wh.getLastName(wife, "_") + ", " + wife.getFirstName()).trim();
                }
            }
            return ((String)str1).toLowerCase().compareTo(((String)str2).toLowerCase());
        }
    };

    public WebSources(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        if (!this.toBeGenerated) {
            return;
        }
        this.init(this.trs("TXT_Sources"), "sources", "sources_", this.formatFromSize(this.wh.getNbIndis()), 0, 15);
        this.calcPages();
    }

    @Override
    public void create() {
        if (!this.toBeGenerated) {
            return;
        }
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
        this.wh.log.write(this.POPUP + this.trs("EXEC_DONE"));
    }

    private void exportData(File dir) {
        List<Source> sources = this.wh.getSources(this.wh.gedcom);
        Object fileStr = "";
        File file = null;
        PrintWriter out = null;
        Object sourcefile = "";
        int cpt = 0;
        int nbSources = sources.size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbSources / this.nbPerPage + 1;
        fileStr = sourcefile = this.sectionPrefix + String.format(this.formatNbrs, 0) + this.sectionSuffix;
        file = this.wh.getFileForName(dir, (String)sourcefile);
        out = this.wh.getWriter(file, this.UTF8);
        this.printOpenHTML(out, "TXT_SourcesIndex", this);
        out.println("<br /><br />");
        this.exportLinks(out, (String)sourcefile, 0, 0, 1, lastPage);
        out.println("<br /><br />");
        Object src_title = "";
        Object src_abbr = "";
        String src_author = "";
        String description = "";
        for (Source src : sources) {
            src_title = src.getTitle();
            if (src_title == null || ((String)src_title).length() == 0) {
                src_title = src.toString();
            }
            Object object = src_abbr = src.getProperty(PATH2ABBR) == null ? "" : src.getProperty(PATH2ABBR).getValue();
            if (src_abbr == null || ((String)src_abbr).length() == 0) {
                src_abbr = "";
            } else {
                src_title = (String)src_title + "   -   ";
            }
            String string = src_author = src.getProperty(PATH2AUTH) == null ? "" : src.getProperty(PATH2AUTH).getValue();
            if (src_author == null || src_author.length() == 0) {
                src_author = "";
            } else {
                src_abbr = (String)src_abbr + "   -   ";
            }
            description = this.htmlText((String)src_title + (String)src_abbr + src_author);
            out.println("<div class=\"conteneur\">");
            out.println("<p class=\"srclist\">" + src.getId() + "</p>");
            out.println("<p class=\"srclisttitle\"><a href=\"" + this.getPageForSource(src) + "#" + src.getId() + "\">" + description + "</a></p><br />");
            out.println("<div class=\"spacer\">&nbsp;</div>");
            out.println("</div>");
        }
        this.exportLinks(out, (String)sourcefile, 0, 0, 1, lastPage);
        this.printCloseHTML(out);
        out.close();
        this.wh.log.write((String)sourcefile + this.trs("EXEC_DONE"));
        cpt = 0;
        out = null;
        for (Source src : sources) {
            previousPage = (currentPage = ++cpt / this.nbPerPage + 1) == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            sourcefile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (((String)fileStr).compareTo((String)sourcefile) != 0) {
                if (out != null) {
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 0, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    out.close();
                    this.wh.log.write((String)fileStr + this.trs("EXEC_DONE"));
                }
                fileStr = sourcefile;
                file = this.wh.getFileForName(dir, (String)sourcefile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Sources", this);
                this.includePopupScript(out);
            }
            if (cpt == 1 || cpt / 5 * 5 == cpt) {
                this.exportLinks(out, (String)sourcefile, 0, previousPage, nextPage, lastPage);
            }
            this.exportSectionDetails(out, src, dir);
        }
        if (out != null) {
            this.exportLinks(out, (String)sourcefile, 0, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write((String)fileStr + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void exportSectionDetails(PrintWriter out, Source src, File dir) {
        String anchor = src.getId();
        ArrayList<PropertyFile> files = new ArrayList<PropertyFile>();
        List propsToAdd = new ArrayList();
        for (Property obje : src.getAllProperties("OBJE")) {
            if (obje == null) continue;
            if (obje instanceof PropertyMedia && obje.isValid()) {
                Media media = (Media)((PropertyMedia)obje).getTargetEntity().get();
                propsToAdd = media.getProperties(PropertyFile.class);
            } else {
                propsToAdd = obje.getProperties(PropertyFile.class);
            }
            for (PropertyFile pFile : propsToAdd) {
                files.add(pFile);
            }
        }
        Property[] props = src.getProperties(PATH2XREF);
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (props != null && props.length > 0) {
            for (Media media : props) {
                PropertyXRef p = (PropertyXRef)media;
                Entity target = p.getTargetEntity().orElse(null);
                if (target == null || list.contains(target) || !(target instanceof Indi) && !(target instanceof Fam)) continue;
                list.add(target);
            }
        }
        Collections.sort(list, this.sortEntities);
        out.println("<p><a id=\"" + anchor + "\"></a>&nbsp;</p>");
        String src_title = src.getTitle();
        if (src_title == null || src_title.length() == 0) {
            src_title = src.toString();
        }
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"srcdecal\"><span class=\"gras\">" + src.getId() + "&nbsp;" + this.htmlText(src_title) + "</span></p>");
        out.println("<p class=\"srcitems\">");
        Property prop = null;
        prop = src.getProperty(PATH2ABBR);
        this.printProperty(out, prop, "", "srcitems2");
        prop = src.getProperty(PATH2AUTH);
        this.printProperty(out, prop, "", "srcitems2");
        prop = src.getProperty(PATH2EVEN);
        if (prop != null) {
            void var12_20;
            Property pdate = prop.getProperty("DATE");
            String string = "";
            if (pdate != null) {
                String string2 = pdate.getDisplayValue();
            }
            Property pplace = prop.getProperty("PLAC");
            String place = "";
            if (pplace != null) {
                place = pplace.getDisplayValue().replaceAll(",", " ");
            }
            this.printProperty(out, prop, ", " + (String)var12_20 + " - " + place, "srcitems2");
        }
        prop = src.getProperty(PATH2REPO);
        this.printProperty(out, prop, "", "srcitems2");
        prop = src.getProperty(PATH2TEXT);
        this.printProperty(out, prop, "", "srcitems3");
        prop = src.getProperty(PATH2DATATEXT);
        this.printProperty(out, prop, "", "srcitems3");
        prop = src.getProperty(PATH2NOTE);
        this.printProperty(out, prop, "", "srcitems2");
        prop = src.getProperty(PATH2SNOTE);
        this.printProperty(out, prop, "", "srcitems2");
        if (this.wp.param_media_GeneSources.equals("1") && !files.isEmpty()) {
            out.println("<span class=\"srcitems1\">" + this.htmlText(this.trs("src_media")) + ":</span><span class=\"srcimage\">");
            for (PropertyFile propertyFile : files) {
                out.println("<span class=\"srcimage1\">");
                out.println(this.wrapMedia(dir, propertyFile, "", true, !this.wp.param_media_CopySources.equals("1"), true, true, "", "", true, "OBJE:NOTE", "tooltipL"));
                out.println("</span><span class=\"srcimage2\">&nbsp;</span>");
            }
            out.println("</span>");
            files.clear();
        }
        if (!list.isEmpty()) {
            ArrayList mediasOfEntity = new ArrayList();
            out.println("<span class=\"srcitems1\">" + this.htmlText(this.trs("src_associations")) + ":</span>");
            out.println("<span class=\"srcitems2\">");
            for (Entity target : list) {
                out.println(this.wrapEntity(target));
                out.println("<br />");
                if (this.wp.param_media_DisplaySources.equals(NbBundle.getMessage(WebBookVisualPanel3.class, (String)"sourceType.type1"))) continue;
                mediasOfEntity.addAll(target.getProperties(PropertyFile.class));
                for (PropertyFile file : mediasOfEntity) {
                    if (!this.isUnderSource((Property)file, anchor)) continue;
                    files.add(file);
                }
                mediasOfEntity.clear();
                if (!files.isEmpty()) {
                    out.println("</span><span class=\"srcimage0\">");
                    for (PropertyFile file : files) {
                        out.println("<span class=\"srcimage1\">");
                        out.println(this.wrapMedia(dir, file, "", true, !this.wp.param_media_CopySources.equals("1"), this.wp.param_media_DisplaySources.equals(NbBundle.getMessage(WebBookVisualPanel3.class, (String)"sourceType.type3")), true, "", "", false, PATH2DATATEXT.toString(), "tooltipL"));
                        out.println("</span><span class=\"srcimage2\">&nbsp;</span>");
                    }
                    out.println("</span><br />");
                    files.clear();
                    out.println("<span class =\"srcitems0\">");
                    continue;
                }
                out.println("<br />");
            }
            out.println("</span><br />");
        }
        out.println("</p><div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    private void calcPages() {
        Object sourcefile = "";
        Object fileStr = "";
        int cpt = 0;
        for (Source src : this.wh.getSources(this.wh.gedcom)) {
            if (((String)fileStr).compareTo((String)(sourcefile = this.sectionPrefix + String.format(this.formatNbrs, ++cpt / this.nbPerPage + 1) + this.sectionSuffix)) != 0) {
                fileStr = sourcefile;
            }
            this.sourcePage.put(src.getId(), sourcefile);
        }
    }

    public String getPageForSource(Source src) {
        return src == null ? "" : (String)this.sourcePage.get(src.getId());
    }

    public Map<String, String> getPagesMap() {
        return this.sourcePage;
    }

    public boolean isUnderSource(Property in, String srcId) {
        Property parent = in.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getTag().compareTo("SOUR") == 0) {
            return parent.getValue().compareTo("@" + srcId + "@") == 0;
        }
        return this.isUnderSource(parent, srcId);
    }

    private void printProperty(PrintWriter out, Property prop, String str, String style) {
        if (prop == null || prop.getValue().trim().isEmpty()) {
            return;
        }
        out.println("<span class=\"srcitems1\">");
        out.println(this.wrapPropertyName(prop));
        out.println(":</span>");
        out.println("<span class=\"" + style + "\">");
        out.println(this.wrapPropertyValue(prop));
        out.println(this.wrapString(prop, str));
        out.println("</span><br />");
    }
}

